/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cdc.io.j2me.ssl;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class J2meTrustManager
implements X509TrustManager {
    private static X509TrustManager impl = null;
    private static TrustManagerFactory tmf = null;
    private X509Certificate[] trusted = null;
    private X509Certificate[] peerChain = null;
    private String TRUST_ALG = "SunX509";
    private byte errorType = 0;
    public static byte EXPIRED = (byte)3;
    public static byte NOT_YET_VALID = (byte)6;
    public static byte UNRECOGNIZED_ISSUER = (byte)8;

    J2meTrustManager() throws NoSuchAlgorithmException, KeyStoreException {
        if (impl == null) {
            tmf = TrustManagerFactory.getInstance(this.TRUST_ALG);
            tmf.init((KeyStore)null);
            TrustManager[] trustManagerArray = tmf.getTrustManagers();
            impl = (X509TrustManager)trustManagerArray[0];
            this.trusted = ((X509TrustManager)trustManagerArray[0]).getAcceptedIssuers();
        }
    }

    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        try {
            this.errorType = 0;
            this.peerChain = x509CertificateArray;
            impl.checkClientTrusted(x509CertificateArray, string);
        }
        catch (CertificateExpiredException certificateExpiredException) {
            this.errorType = EXPIRED;
            throw certificateExpiredException;
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            this.errorType = NOT_YET_VALID;
            throw certificateNotYetValidException;
        }
        catch (CertificateException certificateException) {
            this.errorType = UNRECOGNIZED_ISSUER;
            throw certificateException;
        }
    }

    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        try {
            this.errorType = 0;
            this.peerChain = x509CertificateArray;
            impl.checkServerTrusted(x509CertificateArray, string);
        }
        catch (CertificateExpiredException certificateExpiredException) {
            this.errorType = EXPIRED;
            throw certificateExpiredException;
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            this.errorType = NOT_YET_VALID;
            throw certificateNotYetValidException;
        }
        catch (CertificateException certificateException) {
            this.errorType = UNRECOGNIZED_ISSUER;
            throw certificateException;
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        return this.trusted;
    }

    public Certificate[] getPeerChain() {
        if (this.peerChain != null) {
            return (Certificate[])this.peerChain.clone();
        }
        return null;
    }

    public byte getStatus() {
        return this.errorType;
    }
}

