/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.https;

import com.sun.net.ssl.internal.ssl.SSLSocketFactoryImpl;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.security.cert.X509Certificate;
import sun.misc.RegexpPool;
import sun.net.NetworkClient;
import sun.net.www.http.HttpClient;
import sun.security.action.GetPropertyAction;
import sun.security.util.HostnameChecker;

final class HttpsClient
extends HttpClient
implements HandshakeCompletedListener {
    private static final int a = 443;
    private HostnameVerifier b;
    private SSLSocketFactory c;
    private String d;
    private int e;
    private SSLSession f;

    protected int getDefaultPort() {
        return 443;
    }

    private String getProxyHost() {
        String string = AccessController.doPrivileged(new GetPropertyAction("https.proxyHost"));
        if (string != null && string.length() == 0) {
            string = null;
        }
        return string;
    }

    private int getProxyPort() {
        final int[] nArray = new int[]{0};
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (System.getProperty("https.proxyHost") != null) {
                    nArray[0] = Integer.getInteger("https.proxyPort", 80);
                }
                return null;
            }
        });
        return nArray[0] < 0 ? super.getDefaultPort() : nArray[0];
    }

    private String[] g() {
        String[] stringArray;
        String string = AccessController.doPrivileged(new GetPropertyAction("https.cipherSuites"));
        if (string == null || "".equals(string)) {
            stringArray = null;
        } else {
            Vector<Object> vector = new Vector<Object>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreElements()) {
                vector.addElement(stringTokenizer.nextElement());
            }
            stringArray = new String[vector.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = (String)vector.elementAt(i);
            }
        }
        return stringArray;
    }

    private String[] h() {
        String[] stringArray;
        String string = AccessController.doPrivileged(new GetPropertyAction("https.protocols"));
        if (string == null || "".equals(string)) {
            stringArray = null;
        } else {
            Vector<Object> vector = new Vector<Object>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreElements()) {
                vector.addElement(stringTokenizer.nextElement());
            }
            stringArray = new String[vector.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = (String)vector.elementAt(i);
            }
        }
        return stringArray;
    }

    private RegexpPool i() {
        RegexpPool regexpPool = new RegexpPool();
        String string = AccessController.doPrivileged(new GetPropertyAction("http.nonProxyHosts"));
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|", false);
            try {
                while (stringTokenizer.hasMoreTokens()) {
                    regexpPool.add(stringTokenizer.nextToken().toLowerCase(), (Object)new Boolean(true));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return regexpPool;
    }

    private String j() {
        String string = AccessController.doPrivileged(new GetPropertyAction("https.agent"));
        if (string == null || string.length() == 0) {
            string = "JSSE";
        }
        return string;
    }

    private HttpsClient(SSLSocketFactory sSLSocketFactory, URL uRL) throws IOException {
        this(sSLSocketFactory, uRL, null, -1);
    }

    HttpsClient(SSLSocketFactory sSLSocketFactory, URL uRL, String string, int n) throws IOException {
        this.a(sSLSocketFactory);
        if (string != null) {
            this.a(string, n);
        }
        this.proxyDisabled = true;
        this.host = uRL.getHost();
        this.url = uRL;
        this.port = uRL.getPort();
        if (this.port == -1) {
            this.port = this.getDefaultPort();
        }
        this.openServer();
    }

    static HttpClient a(SSLSocketFactory sSLSocketFactory, URL uRL, HostnameVerifier hostnameVerifier) throws IOException {
        return HttpsClient.a(sSLSocketFactory, uRL, hostnameVerifier, true);
    }

    static HttpClient a(SSLSocketFactory sSLSocketFactory, URL uRL, HostnameVerifier hostnameVerifier, boolean bl) throws IOException {
        return HttpsClient.a(sSLSocketFactory, uRL, hostnameVerifier, null, -1, bl);
    }

    static HttpClient a(SSLSocketFactory sSLSocketFactory, URL uRL, HostnameVerifier hostnameVerifier, String string, int n) throws IOException {
        return HttpsClient.a(sSLSocketFactory, uRL, hostnameVerifier, string, n, true);
    }

    static HttpClient a(SSLSocketFactory sSLSocketFactory, URL uRL, HostnameVerifier hostnameVerifier, String string, int n, boolean bl) throws IOException {
        HttpsClient httpsClient = null;
        if (bl && (httpsClient = (HttpsClient)HttpClient.kac.get(uRL, sSLSocketFactory)) != null) {
            httpsClient.cachedHttpClient = true;
        }
        if (httpsClient == null) {
            httpsClient = new HttpsClient(sSLSocketFactory, uRL, string, n);
        } else {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkConnect(uRL.getHost(), uRL.getPort());
            }
            httpsClient.url = uRL;
        }
        httpsClient.a(hostnameVerifier);
        return httpsClient;
    }

    void a(HostnameVerifier hostnameVerifier) {
        this.b = hostnameVerifier;
    }

    void a(SSLSocketFactory sSLSocketFactory) {
        this.c = sSLSocketFactory;
    }

    void a(String string, int n) {
        this.d = string;
        this.e = n < 0 ? this.getDefaultPort() : n;
    }

    SSLSocketFactory a() {
        return this.c;
    }

    private boolean k() {
        RegexpPool regexpPool = this.i();
        return regexpPool.match(this.url.getHost().toLowerCase()) != null;
    }

    public boolean needsTunneling() {
        return this.d != null && !this.k();
    }

    protected Socket doConnect(String string, int n) throws IOException, UnknownHostException {
        this.d = this.d != null ? this.d : this.getProxyHost();
        this.e = this.e != 0 ? this.e : this.getProxyPort();
        Socket socket = null;
        if (this.d == null || this.k()) {
            socket = new Socket();
            if (NetworkClient.defaultConnectTimeout > 0) {
                socket.connect(new InetSocketAddress(string, n), NetworkClient.defaultConnectTimeout);
            } else {
                socket.connect(new InetSocketAddress(string, n));
            }
        } else {
            try {
                socket = (Socket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        Socket socket = new Socket();
                        if (HttpsClient.e() > 0) {
                            socket.connect(new InetSocketAddress(HttpsClient.this.d, HttpsClient.this.e), HttpsClient.f());
                        } else {
                            socket.connect(new InetSocketAddress(HttpsClient.this.d, HttpsClient.this.e));
                        }
                        return socket;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (IOException)privilegedActionException.getException();
            }
            catch (IOException iOException) {
                try {
                    socket = new Socket();
                    if (NetworkClient.defaultConnectTimeout > 0) {
                        socket.connect(new InetSocketAddress(string, n), NetworkClient.defaultConnectTimeout);
                    } else {
                        socket.connect(new InetSocketAddress(string, n));
                    }
                }
                catch (IOException iOException2) {
                    throw iOException;
                }
            }
        }
        if (NetworkClient.defaultSoTimeout > 0) {
            socket.setSoTimeout(NetworkClient.defaultSoTimeout);
        }
        return socket;
    }

    public void afterConnect() throws IOException, UnknownHostException {
        if (!this.isCachedConnection()) {
            SSLSocket sSLSocket = null;
            SSLSocketFactory sSLSocketFactory = this.c;
            try {
                sSLSocket = !(this.serverSocket instanceof SSLSocket) ? (SSLSocket)sSLSocketFactory.createSocket(this.serverSocket, this.host, this.port, true) : (SSLSocket)this.serverSocket;
            }
            catch (IOException iOException) {
                try {
                    sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(this.host, this.port);
                }
                catch (IOException iOException2) {
                    throw iOException;
                }
            }
            SSLSocketFactoryImpl.checkCreate(sSLSocket);
            String[] stringArray = this.h();
            String[] stringArray2 = this.g();
            if (stringArray != null) {
                sSLSocket.setEnabledProtocols(stringArray);
            }
            if (stringArray2 != null) {
                sSLSocket.setEnabledCipherSuites(stringArray2);
            }
            sSLSocket.addHandshakeCompletedListener(this);
            sSLSocket.startHandshake();
            this.f = sSLSocket.getSession();
            this.serverSocket = sSLSocket;
            try {
                this.serverOutput = new PrintStream((OutputStream)new BufferedOutputStream(this.serverSocket.getOutputStream()), false, NetworkClient.encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new InternalError(NetworkClient.encoding + " encoding not found");
            }
            this.b(this.b);
        } else {
            this.f = ((SSLSocket)this.serverSocket).getSession();
        }
    }

    private void b(HostnameVerifier hostnameVerifier) throws IOException {
        boolean bl = false;
        String string = this.url.getHost();
        if (string != null && string.startsWith("[") && string.endsWith("]")) {
            string = string.substring(1, string.length() - 1);
        }
        Certificate[] certificateArray = null;
        try {
            certificateArray = this.f.getPeerCertificates();
            if (!(certificateArray[0] instanceof java.security.cert.X509Certificate)) {
                throw new SSLPeerUnverifiedException("");
            }
            java.security.cert.X509Certificate x509Certificate = (java.security.cert.X509Certificate)certificateArray[0];
            HostnameChecker hostnameChecker = HostnameChecker.getInstance((byte)1);
            hostnameChecker.match(string, x509Certificate);
            return;
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        String string2 = this.f.getCipherSuite();
        if (string2 != null && string2.indexOf("_anon_") != -1) {
            return;
        }
        if (hostnameVerifier != null && hostnameVerifier.verify(string, this.f)) {
            return;
        }
        this.serverSocket.close();
        this.f.invalidate();
        throw new IOException("HTTPS hostname wrong:  should be <" + this.url.getHost() + ">");
    }

    protected void putInKeepAliveCache() {
        HttpClient.kac.put(this.url, this.c, this);
    }

    String b() {
        return this.f.getCipherSuite();
    }

    public Certificate[] getLocalCertificates() {
        return this.f.getLocalCertificates();
    }

    Certificate[] c() throws SSLPeerUnverifiedException {
        return this.f.getPeerCertificates();
    }

    X509Certificate[] d() throws SSLPeerUnverifiedException {
        return this.f.getPeerCertificateChain();
    }

    public void handshakeCompleted(HandshakeCompletedEvent handshakeCompletedEvent) {
        this.f = handshakeCompletedEvent.getSession();
    }

    public String getProxyHostUsed() {
        if (!this.needsTunneling()) {
            return null;
        }
        return this.d;
    }

    public int getProxyPortUsed() {
        return this.e;
    }

    static /* synthetic */ int e() {
        return NetworkClient.defaultConnectTimeout;
    }

    static /* synthetic */ int f() {
        return NetworkClient.defaultConnectTimeout;
    }
}

