/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.BaseSSLSocketImpl;
import com.sun.net.ssl.internal.ssl.CipherSuite;
import com.sun.net.ssl.internal.ssl.CipherSuiteList;
import com.sun.net.ssl.internal.ssl.ClientDiffieHellmanPublic;
import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.ExtensionType;
import com.sun.net.ssl.internal.ssl.HandshakeMessage;
import com.sun.net.ssl.internal.ssl.HelloExtension;
import com.sun.net.ssl.internal.ssl.ProtocolList;
import com.sun.net.ssl.internal.ssl.ProtocolVersion;
import com.sun.net.ssl.internal.ssl.RenegotiationInfoExtension;
import com.sun.net.ssl.internal.ssl.SSLContextImpl;
import com.sun.net.ssl.internal.ssl.SSLSessionContextImpl;
import com.sun.net.ssl.internal.ssl.SSLSessionImpl;
import com.sun.net.ssl.internal.ssl.SSLSocketImpl;
import com.sun.net.ssl.internal.ssl.SunJSSE_a2;
import com.sun.net.ssl.internal.ssl.SunJSSE_a3;
import com.sun.net.ssl.internal.ssl.SunJSSE_a4;
import com.sun.net.ssl.internal.ssl.SunJSSE_a5;
import com.sun.net.ssl.internal.ssl.SunJSSE_a7;
import com.sun.net.ssl.internal.ssl.SunJSSE_a9;
import com.sun.net.ssl.internal.ssl.SunJSSE_ax;
import com.sun.net.ssl.internal.ssl.SunJSSE_ba;
import com.sun.net.ssl.internal.ssl.SunJSSE_bb;
import com.sun.net.ssl.internal.ssl.SunJSSE_bc;
import com.sun.net.ssl.internal.ssl.SunJSSE_bd;
import com.sun.net.ssl.internal.ssl.SunJSSE_be;
import com.sun.net.ssl.internal.ssl.SunJSSE_g;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.Iterator;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

final class SunJSSE_aw
extends SunJSSE_ax {
    private byte a;
    private X509Certificate[] b;
    private PrivateKey c;
    private boolean d = false;
    private PrivateKey e;
    private PublicKey f;
    private SunJSSE_bd g;
    private ProtocolVersion h;

    SunJSSE_aw(SSLSocketImpl sSLSocketImpl, SSLContextImpl sSLContextImpl, ProtocolList protocolList, byte by, ProtocolVersion protocolVersion, boolean bl, boolean bl2, byte[] byArray, byte[] byArray2) {
        super(sSLSocketImpl, sSLContextImpl, protocolList, by != 0, false, protocolVersion, bl, bl2, byArray, byArray2);
        this.a = by;
    }

    void a(byte by) {
        this.a = by;
    }

    private boolean b(boolean bl) {
        KeyPair keyPair = this.n.d().a(bl, this.n.a());
        if (keyPair == null) {
            return false;
        }
        this.f = (RSAPublicKey)keyPair.getPublic();
        this.e = keyPair.getPrivate();
        return true;
    }

    private void c(boolean bl) {
        boolean bl2 = !bl;
        this.g = new SunJSSE_bd(bl2);
        this.g.a(this.n.a(), bl2 ? 768 : 512);
    }

    void a(byte by, int n) throws IOException {
        if (this.m > by && this.m != 16 && by != 15) {
            throw new SSLProtocolException("Handshake message sequence violation, state = " + this.m + ", type = " + by);
        }
        switch (by) {
            case 1: {
                this.k.mark(n);
                SunJSSE_a4 sunJSSE_a4 = new SunJSSE_a4(this.k, n);
                this.k.reset();
                this.k.skip(n);
                this.a(sunJSSE_a4);
                break;
            }
            case 11: {
                if (this.a == 0) {
                    this.i.a((byte)10, "client sent unsolicited cert chain");
                }
                this.a(new HandshakeMessage.CertificateMsg(this.k));
                break;
            }
            case 16: {
                byte[] byArray;
                if (this.v == SunJSSE_g.K_RSA || this.v == SunJSSE_g.K_RSA_EXPORT) {
                    SunJSSE_be sunJSSE_be = new SunJSSE_be(((SunJSSE_ax)this).a, this.h, this.n.a(), this.k, n, this.c);
                    byArray = this.a(sunJSSE_be);
                } else {
                    byArray = this.a(new ClientDiffieHellmanPublic(this.k));
                }
                this.a(byArray);
                Arrays.fill(byArray, (byte)0);
                break;
            }
            case 15: {
                this.a(new SunJSSE_bb(this.k));
                break;
            }
            case 20: {
                this.b(new SunJSSE_bc(((SunJSSE_ax)this).a, this.k));
                break;
            }
            default: {
                throw new SSLProtocolException("Illegal server handshake msg, " + by);
            }
        }
        if (this.m < by && by != 15) {
            this.m = by;
        }
    }

    private void a(SunJSSE_a4 sunJSSE_a4) throws IOException {
        X509Certificate[] x509CertificateArray;
        Object object;
        Object object2;
        RenegotiationInfoExtension renegotiationInfoExtension;
        if (SunJSSE_ax.ae != null && Debug.isOn("handshake")) {
            sunJSSE_a4.a(System.out);
        }
        boolean bl = false;
        CipherSuiteList cipherSuiteList = sunJSSE_a4.a();
        if (cipherSuiteList.a(CipherSuite.p)) {
            bl = true;
            if (((SunJSSE_ax)this).f) {
                ((SunJSSE_ax)this).c = true;
            } else if (((SunJSSE_ax)this).c) {
                this.i.a((byte)40, "The SCSV is present in a secure renegotiation");
            } else {
                this.i.a((byte)40, "The SCSV is present in a insecure renegotiation");
            }
        }
        if ((renegotiationInfoExtension = (RenegotiationInfoExtension)sunJSSE_a4.f.a(ExtensionType.p)) != null) {
            bl = true;
            if (((SunJSSE_ax)this).f) {
                if (!renegotiationInfoExtension.b()) {
                    this.i.a((byte)40, "The renegotiation_info field is not empty");
                }
                ((SunJSSE_ax)this).c = true;
            } else {
                if (!((SunJSSE_ax)this).c) {
                    this.i.a((byte)40, "The renegotiation_info is present in a insecure renegotiation");
                }
                if (!Arrays.equals(((SunJSSE_ax)this).d, renegotiationInfoExtension.c())) {
                    this.i.a((byte)40, "Incorrect verify data in ClientHello renegotiation_info message");
                }
            }
        } else if (!((SunJSSE_ax)this).f && ((SunJSSE_ax)this).c) {
            this.i.a((byte)40, "Inconsistent secure renegotiation indication");
        }
        if (!bl || !((SunJSSE_ax)this).c) {
            if (((SunJSSE_ax)this).f) {
                if (!SunJSSE_ax.ag) {
                    this.i.a((byte)40, "Failed to negotiate the use of secure renegotiation");
                }
                if (SunJSSE_ax.ae != null && Debug.isOn("handshake")) {
                    System.out.println("Warning: No renegotiation indication in ClientHello, allow legacy ClientHello");
                }
            } else if (!SunJSSE_ax.af) {
                if (((SunJSSE_ax)this).b.i >= ProtocolVersion.d.i) {
                    this.i.a((byte)100);
                    this.ah = true;
                    if (this.k.available() > 0) {
                        this.i.a((byte)10, "ClientHello followed by an unexpected  handshake message");
                    }
                    return;
                }
                this.i.a((byte)40, "Renegotiation is not allowed");
            } else if (SunJSSE_ax.ae != null && Debug.isOn("handshake")) {
                System.out.println("Warning: continue with insecure renegotiation");
            }
        }
        this.k.a();
        SunJSSE_a5 sunJSSE_a5 = new SunJSSE_a5();
        this.h = sunJSSE_a4.a;
        if (this.h.i < ((SunJSSE_ax)this).g.d.i) {
            throw new SSLHandshakeException("Client requested protocol " + this.h + " not enabled or not supported");
        }
        ProtocolVersion protocolVersion = this.h.i <= ((SunJSSE_ax)this).g.e.i ? this.h : ((SunJSSE_ax)this).g.e;
        this.a(protocolVersion);
        sunJSSE_a5.a = ((SunJSSE_ax)this).a;
        this.o = sunJSSE_a4.b;
        sunJSSE_a5.b = this.p = new SunJSSE_a2(this.n.a());
        this.q = null;
        if (sunJSSE_a4.c.a() != 0 && (object2 = ((SSLSessionContextImpl)this.n.engineGetServerSessionContext()).a(sunJSSE_a4.c.b())) != null) {
            this.w = ((SSLSessionImpl)object2).b();
            if (this.w && (object = ((SSLSessionImpl)object2).f()) != ((SunJSSE_ax)this).a) {
                this.w = false;
            }
            if (this.w && this.a != 0) {
                try {
                    ((SSLSessionImpl)object2).getPeerCertificates();
                }
                catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                    this.w = false;
                }
            }
            if (this.w) {
                object = ((SSLSessionImpl)object2).e();
                x509CertificateArray = CipherSuite.a((CipherSuite)object);
                if (!this.c((CipherSuite)object) || !sunJSSE_a4.d.a((CipherSuite)object) && !sunJSSE_a4.d.a((CipherSuite)x509CertificateArray)) {
                    this.w = false;
                } else {
                    this.b((CipherSuite)object);
                }
            }
            if (this.w) {
                this.q = object2;
                if (SunJSSE_ax.ae != null && (Debug.isOn("handshake") || Debug.isOn("session"))) {
                    System.out.println("%% Resuming " + this.q);
                }
            }
        }
        if (this.q == null) {
            if (!this.x) {
                throw new SSLException("Client did not resume a session");
            }
            this.b(sunJSSE_a4);
            this.q = new SSLSessionImpl(((SunJSSE_ax)this).a, this.u, this.n.a(), this.i.getInetAddress().getHostAddress(), this.i.getPort());
        }
        sunJSSE_a5.d = this.u;
        sunJSSE_a5.c = this.q.d();
        sunJSSE_a5.e = this.q.g();
        if (((SunJSSE_ax)this).c) {
            object2 = new RenegotiationInfoExtension(((SunJSSE_ax)this).d, ((SunJSSE_ax)this).e);
            sunJSSE_a5.f.a((HelloExtension)object2);
        }
        if (SunJSSE_ax.ae != null && Debug.isOn("handshake")) {
            sunJSSE_a5.a(System.out);
            System.out.println("Cipher suite:  " + this.q.e());
        }
        sunJSSE_a5.write(this.l);
        if (this.w) {
            this.b(this.q.a());
            this.d(true);
            return;
        }
        if (this.v != SunJSSE_g.K_DH_ANON) {
            if (this.b == null) {
                throw new RuntimeException("no certificates");
            }
            object2 = new HandshakeMessage.CertificateMsg(this.b);
            this.q.b(this.b);
            if (SunJSSE_ax.ae != null && Debug.isOn("handshake")) {
                ((HandshakeMessage.CertificateMsg)object2).a(System.out);
            }
            ((HandshakeMessage)object2).write(this.l);
        } else if (this.b != null) {
            throw new RuntimeException("anonymous keyexchange with certs");
        }
        if (this.v == SunJSSE_g.K_RSA) {
            object2 = null;
        } else if (this.v == SunJSSE_g.K_RSA_EXPORT) {
            if (((RSAPrivateKey)this.c).getModulus().bitLength() > 512) {
                try {
                    object2 = new SunJSSE_a7(this.f, this.c, this.o, this.p, this.n.a());
                    this.c = this.e;
                }
                catch (GeneralSecurityException generalSecurityException) {
                    SunJSSE_ax.a("Error generating RSA server key exchange", generalSecurityException);
                    object2 = null;
                }
            } else {
                object2 = null;
            }
        } else if (this.v == SunJSSE_g.K_DHE_DSS || this.v == SunJSSE_g.K_DHE_RSA) {
            try {
                object2 = new HandshakeMessage.DH_ServerKeyExchange(this.g, this.c, this.o.a, this.p.a, this.n.a());
            }
            catch (GeneralSecurityException generalSecurityException) {
                SunJSSE_ax.a("Error generating DH server key exchange", generalSecurityException);
                object2 = null;
            }
        } else if (this.v == SunJSSE_g.K_DH_ANON) {
            object2 = new HandshakeMessage.DH_ServerKeyExchange(this.g);
        } else {
            throw new RuntimeException("internal error: " + this.v);
        }
        if (object2 != null) {
            if (SunJSSE_ax.ae != null && Debug.isOn("handshake")) {
                ((HandshakeMessage)object2).a(System.out);
            }
            ((HandshakeMessage)object2).write(this.l);
        }
        if (this.a != 0 && this.v != SunJSSE_g.K_DH_ANON) {
            x509CertificateArray = this.n.c().getAcceptedIssuers();
            object = new SunJSSE_a9(x509CertificateArray, this.v);
            if (SunJSSE_ax.ae != null && Debug.isOn("handshake")) {
                ((SunJSSE_a9)object).a(System.out);
            }
            ((HandshakeMessage)object).write(this.l);
        }
        object = new SunJSSE_ba();
        if (SunJSSE_ax.ae != null && Debug.isOn("handshake")) {
            ((SunJSSE_ba)object).a(System.out);
        }
        ((HandshakeMessage)object).write(this.l);
        this.l.flush();
    }

    private void b(SunJSSE_a4 sunJSSE_a4) throws IOException {
        Iterator iterator = sunJSSE_a4.d.a();
        while (iterator.hasNext()) {
            CipherSuite cipherSuite = (CipherSuite)iterator.next();
            if (!this.c(cipherSuite) || this.a == 2 && cipherSuite.k == SunJSSE_g.K_DH_ANON || !this.a(cipherSuite)) continue;
            return;
        }
        this.i.a((byte)40, "no cipher suites in common");
    }

    boolean a(CipherSuite cipherSuite) {
        if (this.w) {
            return true;
        }
        if (!cipherSuite.b()) {
            return false;
        }
        CipherSuite.KeyExchange keyExchange = cipherSuite.k;
        this.c = null;
        this.b = null;
        this.g = null;
        this.e = null;
        this.f = null;
        if (keyExchange == SunJSSE_g.K_RSA || keyExchange == SunJSSE_g.K_RSA_EXPORT || keyExchange == SunJSSE_g.K_DHE_RSA) {
            if (!this.a("RSA")) {
                return false;
            }
            if (keyExchange == SunJSSE_g.K_RSA_EXPORT) {
                PublicKey publicKey = this.b[0].getPublicKey();
                if (!(publicKey instanceof RSAPublicKey)) {
                    return false;
                }
                RSAPublicKey rSAPublicKey = (RSAPublicKey)publicKey;
                if (rSAPublicKey.getModulus().bitLength() > 512 && !this.b(cipherSuite.n)) {
                    return false;
                }
            } else if (keyExchange == SunJSSE_g.K_DHE_RSA) {
                this.c(cipherSuite.n);
            }
        } else if (keyExchange == SunJSSE_g.K_DHE_DSS) {
            if (!this.a("DSA")) {
                return false;
            }
            this.c(cipherSuite.n);
        } else if (keyExchange == SunJSSE_g.K_DH_ANON) {
            this.c(cipherSuite.n);
        } else {
            throw new RuntimeException("CipherSuite: " + cipherSuite);
        }
        this.b(cipherSuite);
        return true;
    }

    private boolean a(String string) {
        X509KeyManager x509KeyManager = this.n.b();
        String string2 = x509KeyManager.chooseServerAlias(string, null, this.i);
        if (string2 == null) {
            return false;
        }
        PrivateKey privateKey = x509KeyManager.getPrivateKey(string2);
        if (privateKey == null) {
            return false;
        }
        X509Certificate[] x509CertificateArray = x509KeyManager.getCertificateChain(string2);
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            return false;
        }
        PublicKey publicKey = x509CertificateArray[0].getPublicKey();
        if (!privateKey.getAlgorithm().equals(string) || !publicKey.getAlgorithm().equals(string)) {
            return false;
        }
        this.c = privateKey;
        this.b = x509CertificateArray;
        return true;
    }

    private byte[] a(ClientDiffieHellmanPublic clientDiffieHellmanPublic) throws IOException {
        if (SunJSSE_ax.ae != null && Debug.isOn("handshake")) {
            clientDiffieHellmanPublic.a(System.out);
        }
        return this.g.a(clientDiffieHellmanPublic.getClientPublicKey());
    }

    private void a(SunJSSE_bb sunJSSE_bb) throws IOException {
        if (SunJSSE_ax.ae != null && Debug.isOn("handshake")) {
            sunJSSE_bb.a(System.out);
        }
        try {
            PublicKey publicKey = this.q.getPeerCertificates()[0].getPublicKey();
            boolean bl = sunJSSE_bb.a(((SunJSSE_ax)this).a, this.j, publicKey, this.q.a());
            if (!bl) {
                this.i.a((byte)42, "certificate verify message signature error");
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            this.i.a((byte)42, "certificate verify format error", generalSecurityException);
        }
        this.d = false;
    }

    private void b(SunJSSE_bc sunJSSE_bc) throws IOException {
        boolean bl;
        if (SunJSSE_ax.ae != null && Debug.isOn("handshake")) {
            sunJSSE_bc.a(System.out);
        }
        if (this.a == 2) {
            this.q.getPeerCertificates();
        }
        if (this.d) {
            this.i.a((byte)40, "client did not send certificate verify message");
        }
        if (!(bl = sunJSSE_bc.a(((SunJSSE_ax)this).a, this.j, 1, this.q.a()))) {
            this.i.a((byte)40, "client 'finished' message doesn't verify");
        }
        if (((SunJSSE_ax)this).c) {
            ((SunJSSE_ax)this).d = sunJSSE_bc.a();
        }
        if (!this.w) {
            this.k.a();
            this.d(false);
        }
        this.q.a(System.currentTimeMillis());
        if (!this.w && this.q.b()) {
            ((SSLSessionContextImpl)this.n.engineGetServerSessionContext()).a(this.q);
            if (SunJSSE_ax.ae != null && Debug.isOn("session")) {
                System.out.println("%% Cached server session: " + this.q);
            }
        } else if (!this.w && SunJSSE_ax.ae != null && Debug.isOn("session")) {
            System.out.println("%% Didn't cache non-resumable server session: " + this.q);
        }
    }

    private void d(boolean bl) throws IOException {
        this.l.flush();
        SunJSSE_bc sunJSSE_bc = new SunJSSE_bc(((SunJSSE_ax)this).a, this.j, 2, this.q.a());
        this.a(sunJSSE_bc);
        if (((SunJSSE_ax)this).c) {
            ((SunJSSE_ax)this).e = sunJSSE_bc.a();
        }
        if (!bl || !this.w) {
            this.m = 20;
        }
    }

    HandshakeMessage a() {
        return new SunJSSE_a3();
    }

    void b(byte by) throws SSLProtocolException {
        String string = BaseSSLSocketImpl.b(by);
        if (SunJSSE_ax.ae != null && Debug.isOn("handshake")) {
            System.out.println("SSL -- handshake alert:  " + string);
        }
        if (by == 41 && this.a == 1) {
            return;
        }
        throw new SSLProtocolException("handshake alert: " + string);
    }

    private byte[] a(SunJSSE_be sunJSSE_be) throws IOException {
        if (SunJSSE_ax.ae != null && Debug.isOn("handshake")) {
            sunJSSE_be.a(System.out);
        }
        return sunJSSE_be.d;
    }

    private void a(HandshakeMessage.CertificateMsg certificateMsg) throws IOException {
        X509Certificate[] x509CertificateArray;
        if (SunJSSE_ax.ae != null && Debug.isOn("handshake")) {
            certificateMsg.a(System.out);
        }
        if ((x509CertificateArray = certificateMsg.getCertificateChain()).length == 0) {
            if (this.a == 1) {
                return;
            }
            this.i.a((byte)42, "null cert chain");
        }
        X509TrustManager x509TrustManager = this.n.c();
        try {
            PublicKey publicKey = x509CertificateArray[0].getPublicKey();
            String string = publicKey instanceof RSAPublicKey ? "RSA" : (publicKey instanceof DSAPublicKey ? "DSA" : "UNKNOWN");
            x509TrustManager.checkClientTrusted(x509CertificateArray, string);
        }
        catch (CertificateException certificateException) {
            this.i.a((byte)46, certificateException);
        }
        this.d = true;
        this.q.a(x509CertificateArray);
    }
}

