/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.util.logging;

import com.sun.util.logging.Level;
import com.sun.util.logging.Logger;
import java.util.ResourceBundle;
import oracle.adfmf.util.Utility;

public class Trace {
    private Trace() {
    }

    private static boolean loggerIsValid(Logger logger) {
        boolean bl = true;
        if (logger == null) {
            String string = Utility.getResourceString("oracle.adfmf.resource.SharedErrorBundle", "ADF-MF-10024");
            System.err.println(string);
            bl = false;
        }
        return bl;
    }

    private static void verifyBundleClass(Class clazz) {
        if (clazz == null) {
            String string = Utility.getResourceString("oracle.adfmf.resource.SharedErrorBundle", "ADF-MF-10025");
            throw new IllegalArgumentException(string);
        }
    }

    private static void verifyCallingClass(Class clazz) {
        if (clazz == null) {
            String string = Utility.getResourceString("oracle.adfmf.resource.SharedErrorBundle", "ADF-MF-10026");
            throw new IllegalArgumentException(string);
        }
    }

    public static final void log(String string, Level level, Class clazz, String string2, Object object) {
        Logger logger = Logger.getLogger((String)string);
        Trace.log(logger, level, clazz, string2, object);
    }

    public static final void log(Logger logger, Level level, Class clazz, String string, Object object) {
        if (object == null) {
            Trace.log(logger, level, clazz, string, (String)null, (Object[])null);
        } else {
            String string2 = object.toString();
            Trace.log(logger, level, clazz, string, string2, (Object[])null);
        }
    }

    public static final void log(String string, Level level, Class clazz, String string2, Throwable throwable) {
        Logger logger = Logger.getLogger((String)string);
        Trace.log(logger, level, clazz, string2, throwable);
    }

    public static final void log(Logger logger, Level level, Class clazz, String string, Throwable throwable) {
        Trace.log(logger, level, clazz, string, (Object)throwable);
        if (throwable != null) {
            throwable.printStackTrace();
        }
    }

    public static final void log(String string, Class clazz, String string2, Throwable throwable) {
        Logger logger = Logger.getLogger((String)string);
        Trace.log(logger, clazz, string2, throwable);
    }

    public static final void log(Logger logger, Class clazz, String string, Throwable throwable) {
        Trace.log(logger, Level.SEVERE, clazz, string, throwable);
    }

    public static final void log(String string, Level level, Class clazz, String string2, Class clazz2, String string3, Object[] objectArray) {
        Logger logger = Logger.getLogger((String)string);
        Trace.log(logger, level, clazz, string2, clazz2, string3, objectArray);
    }

    public static final void log(Logger logger, Level level, Class clazz, String string, Class clazz2, String string2, Object[] objectArray) {
        Trace.verifyBundleClass(clazz2);
        Trace.log(logger, level, clazz, string, clazz2.getName(), string2, objectArray);
    }

    public static final void log(String string, Level level, Class clazz, String string2, String string3, String string4) {
        Logger logger = Logger.getLogger((String)string);
        Trace.log(logger, level, clazz, string2, string3, string4);
    }

    public static final void log(Logger logger, Level level, Class clazz, String string, String string2, String string3) {
        Trace.log(logger, level, clazz, string, string2, string3, null);
    }

    public static final void log(String string, Level level, Class clazz, String string2, String string3, String string4, Object[] objectArray) {
        Logger logger = Logger.getLogger((String)string);
        Trace.log(logger, level, clazz, string2, string3, string4, objectArray);
    }

    public static final void log(Logger logger, Level level, Class clazz, String string, String string2, String string3, Object[] objectArray) {
        if (Trace.loggerIsValid(logger) && logger.isLoggable(level)) {
            String string4 = Utility.getResourceString(string2, string3, objectArray);
            Trace.logActual(logger, level, clazz, string, string4, null);
        }
    }

    public static final void log(String string, Level level, Class clazz, String string2, ResourceBundle resourceBundle, String string3, Object[] objectArray) {
        Logger logger = Logger.getLogger((String)string);
        Trace.log(logger, level, clazz, string2, resourceBundle, string3, objectArray);
    }

    public static final void log(Logger logger, Level level, Class clazz, String string, ResourceBundle resourceBundle, String string2, Object[] objectArray) {
        if (Trace.loggerIsValid(logger) && logger.isLoggable(level)) {
            String string3 = Utility.getResourceString(resourceBundle, string2, objectArray);
            Trace.logActual(logger, level, clazz, string, string3, null);
        }
    }

    public static final void log(String string, Level level, Class clazz, String string2, Class clazz2, String string3) {
        Logger logger = Logger.getLogger((String)string);
        Trace.log(logger, level, clazz, string2, clazz2, string3);
    }

    public static final void log(Logger logger, Level level, Class clazz, String string, Class clazz2, String string2) {
        Trace.log(logger, level, clazz, string, clazz2, string2, null);
    }

    public static final void log(String string, Level level, Class clazz, String string2, String string3, Object[] objectArray) {
        Logger logger = Logger.getLogger((String)string);
        Trace.log(logger, level, clazz, string2, string3, objectArray);
    }

    public static final void log(Logger logger, Level level, Class clazz, String string, String string2, Object[] objectArray) {
        if (Trace.loggerIsValid(logger) && logger.isLoggable(level)) {
            Trace.logActual(logger, level, clazz, string, string2, objectArray);
        }
    }

    private static final void logActual(Logger logger, Level level, Class clazz, String string, String string2, Object[] objectArray) {
        Trace.verifyCallingClass(clazz);
        String string3 = clazz.getName();
        if (Utility.isNotEmpty(objectArray)) {
            logger.logp(level, string3, string, string2, objectArray);
        } else {
            logger.logp(level, string3, string, string2);
        }
    }
}

