/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.util.logging;

import com.sun.util.logging.Formatter;
import com.sun.util.logging.Handler;
import com.sun.util.logging.Level;
import com.sun.util.logging.LogRecord;
import com.sun.util.logging.SimpleFormatter;
import java.io.StringWriter;
import oracle.adfmf.util.logging.LoggingUtility;

public class StringWriterHandler
extends Handler {
    private static final int DEFAULT_BUFFER_SIZE = 4000;
    private int bufferSize = 4000;
    private boolean isCircular = false;
    private StringWriter writer;

    public StringWriterHandler() {
        String string = ((Object)((Object)this)).getClass().getName();
        this.setLevel(LoggingUtility.getLevelProperty(string + ".level", Level.INFO));
        this.setFilter(LoggingUtility.getFilterProperty(string + ".filter", null));
        this.setFormatter(LoggingUtility.getFormatterProperty(string + ".formatter", (Formatter)new SimpleFormatter()));
        this.setBufferSize(LoggingUtility.getIntegerProperty(string + ".bufferSize", 4000));
        this.setIsCircular(LoggingUtility.getBooleanProperty(string + ".isCircular", false));
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int n) {
        this.bufferSize = n;
    }

    public boolean getIsCircular() {
        return this.isCircular;
    }

    public void setIsCircular(boolean bl) {
        this.isCircular = bl;
    }

    public void close() throws SecurityException {
    }

    public void flush() {
    }

    public void publish(LogRecord logRecord) {
        if (this.isLoggable(logRecord)) {
            Formatter formatter = this.getFormatter();
            String string = formatter.format(logRecord);
            this.write(string);
        }
    }

    public StringBuffer getBuffer() {
        if (this.writer != null) {
            return this.writer.getBuffer();
        }
        return null;
    }

    private void write(String string) {
        if (this.writer == null) {
            this.writer = new StringWriter(this.bufferSize);
        } else if (this.isCircular) {
            int n = string != null ? string.length() : 0;
            int n2 = this.writer.getBuffer().length();
            if (n2 + n >= this.bufferSize) {
                this.writer.getBuffer().delete(0, n2);
            }
        }
        this.writer.write(string);
    }
}

