/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.util.logging;

import com.sun.util.logging.Formatter;
import com.sun.util.logging.LogRecord;
import java.text.MessageFormat;
import java.util.Date;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.logging.LoggingUtility;

public class PatternFormatter
extends Formatter {
    public static final String DEFAULT_PATTERN = "[%LEVEL% - %LOGGER% - %CLASS% - %METHOD%] %MESSAGE%";
    public static final String LOGGER_TOKEN = "%LOGGER%";
    public static final String LEVEL_TOKEN = "%LEVEL%";
    public static final String TIME_TOKEN = "%TIME%";
    public static final String MESSAGE_TOKEN = "%MESSAGE%";
    public static final String CLASS_TOKEN = "%CLASS%";
    public static final String METHOD_TOKEN = "%METHOD%";
    private static final String NEWLINE = System.getProperty("line.separator", "\n");
    private String m_pattern = null;
    private final MessageFormat m_messageFormat = new MessageFormat("");

    public PatternFormatter() {
        String string = ((Object)((Object)this)).getClass().getName();
        this.setPattern(LoggingUtility.getStringProperty(string + ".pattern", DEFAULT_PATTERN));
    }

    public PatternFormatter(String string) {
        this.setPattern(string);
    }

    private String trimClassName(String string) {
        int n = string.lastIndexOf(46);
        return string.substring(++n);
    }

    public void setPattern(String string) {
        this.m_pattern = string;
        this.validatePattern();
    }

    public String getPattern() {
        return this.m_pattern;
    }

    private void validatePattern() {
        if (Utility.isEmpty(this.m_pattern)) {
            this.m_pattern = DEFAULT_PATTERN;
        }
        String string = this.m_pattern;
        string = Utility.replaceString(string, LOGGER_TOKEN, "{0}");
        string = Utility.replaceString(string, LEVEL_TOKEN, "{1}");
        string = Utility.replaceString(string, TIME_TOKEN, "{2}");
        string = Utility.replaceString(string, CLASS_TOKEN, "{3}");
        string = Utility.replaceString(string, METHOD_TOKEN, "{4}");
        string = Utility.replaceString(string, MESSAGE_TOKEN, "{5}");
        this.m_messageFormat.applyPattern(string);
    }

    public String format(LogRecord logRecord) {
        String string;
        if (null != logRecord && null != this.m_messageFormat) {
            string = logRecord.getMessage();
            Object[] objectArray = logRecord.getParameters();
            if (Utility.isNotEmpty(string) && Utility.isNotEmpty(objectArray)) {
                string = MessageFormat.format(string, logRecord.getParameters());
            }
            string = this.m_messageFormat.format(new Object[]{logRecord.getLoggerName(), logRecord.getLevel(), new Date(logRecord.getMillis()), this.trimClassName(logRecord.getSourceClassName()), logRecord.getSourceMethodName(), string}) + NEWLINE;
        } else {
            string = super.formatMessage(logRecord);
        }
        return string;
    }
}

