/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.util;

import com.sun.util.logging.Level;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import oracle.adfmf.framework.exception.AdfException;
import oracle.adfmf.util.KXmlUtil;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.logging.Trace;
import org.ksoap2.serialization.PropertyInfo;
import org.xmlpull.v1.XmlPullParser;

public class XmlAnyDefinition
implements KXmlUtil.KXmlParsableElement {
    public static final int DEBUG_XML_PARSING = Level.INFO.intValue();
    public static final String INDENT_STRING = "   ";
    public static final int MATCH_EQUALS_IGNORE_CASE = 0;
    public static final int MATCH_STARTS_WITH_IGNORE_CASE = 1;
    public static final int MATCH_EQUALS = 2;
    private static final String NEW_LINE = "\n";
    protected String namespace = null;
    protected String name = null;
    protected String text = null;
    protected HashMap attributes = new HashMap();
    protected List children = new ArrayList();
    protected String location;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XmlAnyDefinition loadXmlFromLocation(String string, String string2) {
        InputStream inputStream = Utility.getResourceAsStream(string);
        if (inputStream == null) {
            throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11135", new Object[]{string});
        }
        if (XmlAnyDefinition.shouldLog(Level.FINEST)) {
            XmlAnyDefinition.log(Level.FINEST, "InputStream for '" + string + "' is " + inputStream);
        }
        try {
            XmlAnyDefinition xmlAnyDefinition = XmlAnyDefinition.loadXmlFromStream(string, inputStream, string2);
            xmlAnyDefinition.location = string;
            XmlAnyDefinition xmlAnyDefinition2 = xmlAnyDefinition;
            return xmlAnyDefinition2;
        }
        finally {
            Utility.closeSilently(inputStream);
        }
    }

    public static XmlAnyDefinition loadXmlFromStream(String string, InputStream inputStream, String string2) {
        XmlAnyDefinition xmlAnyDefinition = null;
        try {
            xmlAnyDefinition = (XmlAnyDefinition)KXmlUtil.loadFromXml(inputStream, XmlAnyDefinition.class, string2);
            if (XmlAnyDefinition.shouldLog(Level.FINEST)) {
                XmlAnyDefinition.log(Level.FINEST, "Loaded: " + xmlAnyDefinition);
            }
        }
        catch (Exception exception) {
            if (XmlAnyDefinition.shouldLog(Level.FINEST)) {
                XmlAnyDefinition.log(Level.FINEST, "Error reading the XmlAnyDefinition at " + string);
            }
            throw new AdfException(exception);
        }
        catch (Error error) {
            if (XmlAnyDefinition.shouldLog(Level.FINEST)) {
                XmlAnyDefinition.log(Level.FINEST, "Error reading the XmlAnyDefinition at " + string);
            }
            throw new AdfException(error, "ERROR");
        }
        return xmlAnyDefinition;
    }

    static final XmlAnyDefinition loadFromXml(XmlPullParser xmlPullParser) {
        if (XmlAnyDefinition.shouldLog(Level.FINEST)) {
            XmlAnyDefinition.log(Level.FINEST, "Loading XML ....");
        }
        return (XmlAnyDefinition)KXmlUtil.loadFromXml(xmlPullParser, XmlAnyDefinition.class);
    }

    public XmlAnyDefinition() {
    }

    public XmlAnyDefinition(XmlAnyDefinition xmlAnyDefinition) {
        this(xmlAnyDefinition, null, null);
    }

    public XmlAnyDefinition(XmlAnyDefinition xmlAnyDefinition, String[] stringArray, String[] stringArray2) {
        if (xmlAnyDefinition != null) {
            String string = this.getClass().getName() + "Definition";
            if (string.equalsIgnoreCase(xmlAnyDefinition.name)) {
                throw new ClassCastException("Class: " + this.getClass().getName() + " is not equal to " + xmlAnyDefinition.name);
            }
            if (stringArray != null) {
                this.validateAttributes(stringArray);
            }
            if (stringArray2 != null) {
                this.validateChildren(stringArray2);
            }
            this.namespace = xmlAnyDefinition.namespace;
            this.name = xmlAnyDefinition.name;
            this.attributes = xmlAnyDefinition.attributes;
            this.children = xmlAnyDefinition.children;
            this.location = xmlAnyDefinition.location;
            this.text = xmlAnyDefinition.text;
        }
    }

    public void parseAttributes(XmlPullParser xmlPullParser) {
        this.namespace = xmlPullParser.getNamespace();
        this.name = xmlPullParser.getName();
        if (XmlAnyDefinition.shouldLog(Level.FINEST)) {
            XmlAnyDefinition.log(Level.FINEST, "Parsing attributes for " + this.namespace + "." + this.name);
        }
        for (int i = 0; i < xmlPullParser.getAttributeCount(); ++i) {
            PropertyInfo propertyInfo = new PropertyInfo();
            propertyInfo.namespace = xmlPullParser.getAttributeNamespace(i);
            propertyInfo.name = xmlPullParser.getAttributeName(i);
            propertyInfo.type = xmlPullParser.getAttributeType(i);
            this.attributes.put(propertyInfo, xmlPullParser.getAttributeValue(i));
        }
    }

    public void parseText(XmlPullParser xmlPullParser) {
        this.text = xmlPullParser.getText();
    }

    public void parseChild(XmlPullParser xmlPullParser) {
        if (XmlAnyDefinition.shouldLog(Level.FINEST)) {
            XmlAnyDefinition.log(Level.FINEST, "Parsing children for " + this.namespace + "." + this.name);
        }
        XmlAnyDefinition xmlAnyDefinition = XmlAnyDefinition.loadFromXml(xmlPullParser);
        this.children.add(xmlAnyDefinition);
    }

    public String getElementName() {
        return this.name;
    }

    public List getChildren() {
        return this.children;
    }

    public String getLocation() {
        return this.location;
    }

    public PropertyInfo getAttributeDetailInformation(String string) {
        Set set = this.attributes.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            PropertyInfo propertyInfo = (PropertyInfo)iterator.next();
            if (!propertyInfo.name.equalsIgnoreCase(string)) continue;
            return propertyInfo;
        }
        return null;
    }

    public Object getAttributeValue(String string) {
        PropertyInfo propertyInfo = this.getAttributeDetailInformation(string);
        return propertyInfo != null ? this.attributes.get(propertyInfo) : null;
    }

    public boolean getAttributeBooleanValue(String string) {
        PropertyInfo propertyInfo = this.getAttributeDetailInformation(string);
        String string2 = propertyInfo != null ? this.attributes.get(propertyInfo) : "false";
        return Utility.stringToBool(string2);
    }

    public int getAttributeIntegerValue(String string) {
        PropertyInfo propertyInfo = this.getAttributeDetailInformation(string);
        if (propertyInfo == null) {
            throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11106", new Object[]{string});
        }
        return Integer.parseInt((String)this.attributes.get(propertyInfo), 10);
    }

    public XmlAnyDefinition getChildDefinition(String string) {
        for (int i = 0; this.children != null && i < this.children.size(); ++i) {
            XmlAnyDefinition xmlAnyDefinition = (XmlAnyDefinition)this.children.get(i);
            if (!string.equalsIgnoreCase(xmlAnyDefinition.name)) continue;
            return xmlAnyDefinition;
        }
        return null;
    }

    public XmlAnyDefinition getChildDefinition(int n) {
        return this.children != null && n < this.children.size() ? (XmlAnyDefinition)this.children.get(n) : null;
    }

    public int getChildDefinitionCount(String string, String string2, String string3) {
        int n = 0;
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            XmlAnyDefinition xmlAnyDefinition = (XmlAnyDefinition)iterator.next();
            if (!string.equalsIgnoreCase(xmlAnyDefinition.name)) continue;
            String string4 = (String)xmlAnyDefinition.getAttributeValue(string2);
            if (string3 == null || !string3.equals(string4)) continue;
            ++n;
        }
        return n;
    }

    public XmlAnyDefinition getChildDefinition(String string, String string2, String string3) {
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            XmlAnyDefinition xmlAnyDefinition = (XmlAnyDefinition)iterator.next();
            if (!string.equalsIgnoreCase(xmlAnyDefinition.name)) continue;
            String string4 = (String)xmlAnyDefinition.getAttributeValue(string2);
            if (string3 == null || !string3.equals(string4)) continue;
            return xmlAnyDefinition;
        }
        return null;
    }

    public XmlAnyDefinition getChildDefinition(String string, Map map) {
        String[] stringArray = (String[])map.keySet().toArray();
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            XmlAnyDefinition xmlAnyDefinition = (XmlAnyDefinition)iterator.next();
            if (!string.equalsIgnoreCase(xmlAnyDefinition.name)) continue;
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = (String)xmlAnyDefinition.getAttributeValue(stringArray[i]);
                String string3 = (String)map.get(stringArray[i]);
                if (string3 == null || !string3.equals(string2)) continue;
                return xmlAnyDefinition;
            }
        }
        return null;
    }

    public List getChildDefinitions(String string) {
        return this.getChildDefinitions(string, 0);
    }

    public List getChildDefinitions(String string, int n) {
        ArrayList<XmlAnyDefinition> arrayList = new ArrayList<XmlAnyDefinition>();
        Iterator iterator = this.children.iterator();
        block4: while (iterator.hasNext()) {
            XmlAnyDefinition xmlAnyDefinition = (XmlAnyDefinition)iterator.next();
            switch (n) {
                case 1: {
                    if (xmlAnyDefinition.name.toLowerCase().startsWith(string.toLowerCase())) {
                        arrayList.add(xmlAnyDefinition);
                        continue block4;
                    }
                }
                case 2: {
                    if (!string.equals(xmlAnyDefinition.name)) break;
                    arrayList.add(xmlAnyDefinition);
                    continue block4;
                }
            }
            if (!string.equalsIgnoreCase(xmlAnyDefinition.name)) continue;
            arrayList.add(xmlAnyDefinition);
        }
        return arrayList;
    }

    public List getChildDefinitions(String string, Map map) {
        ArrayList<XmlAnyDefinition> arrayList = new ArrayList<XmlAnyDefinition>();
        String[] stringArray = (String[])map.keySet().toArray();
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            XmlAnyDefinition xmlAnyDefinition = (XmlAnyDefinition)iterator.next();
            if (!string.equalsIgnoreCase(xmlAnyDefinition.name)) continue;
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = (String)xmlAnyDefinition.getAttributeValue(stringArray[i]);
                String string3 = (String)map.get(stringArray[i]);
                if (string3 == null || !string3.equals(string2)) continue;
                arrayList.add(xmlAnyDefinition);
            }
        }
        return arrayList;
    }

    public String getText() {
        return this.text;
    }

    public void mergeChildren(XmlAnyDefinition xmlAnyDefinition) {
        if (this.children == xmlAnyDefinition.children) {
            return;
        }
        Iterator iterator = xmlAnyDefinition.children.iterator();
        while (iterator.hasNext()) {
            this.children.add(iterator.next());
        }
    }

    public String toString() {
        return this.dumpXmlAnyDefinition(INDENT_STRING);
    }

    public String prettyPrint() {
        return this.dumpXmlAnyDefinition(true, INDENT_STRING);
    }

    public String dumpXmlAnyDefinition(String string) {
        return this.dumpXmlAnyDefinition(false, string);
    }

    private String dumpXmlAnyDefinition(boolean bl, String string) {
        String string2 = "";
        String string3 = string + INDENT_STRING;
        string2 = string2 + NEW_LINE;
        string2 = string2 + string + (this.namespace != null ? this.namespace + "." : "") + this.name + "{";
        string2 = string2 + this.dumpAttributes(bl, string3);
        string2 = string2 + this.dumpText(bl, string3);
        string2 = string2 + this.dumpChildren(bl, string3);
        string2 = string2 + string + "}" + NEW_LINE;
        return string2;
    }

    public Set getAttributeNames() {
        return this.attributes.keySet();
    }

    protected boolean validateAttributes(String[] stringArray) {
        Vector vector = new Vector(this.attributes.keySet());
        for (int i = 0; i < stringArray.length; ++i) {
            vector.remove(stringArray[i]);
        }
        if (vector.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer("Unrecongnized attributes: ");
            for (int i = 0; i < vector.size(); ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(vector.get(i));
            }
            if (XmlAnyDefinition.shouldLog(Level.SEVERE)) {
                XmlAnyDefinition.log(Level.SEVERE, stringBuffer.toString());
            }
        }
        return vector.size() == 0;
    }

    protected boolean validateChildren(String[] stringArray) {
        Vector<String> vector = new Vector<String>(stringArray.length);
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            XmlAnyDefinition xmlAnyDefinition = (XmlAnyDefinition)iterator.next();
            if (vector.contains(xmlAnyDefinition.name)) continue;
            vector.add(xmlAnyDefinition.name);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            vector.remove(stringArray[i]);
        }
        if (vector.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer("Unrecongnized children: ");
            for (int i = 0; i < vector.size(); ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(vector.get(i));
            }
            if (XmlAnyDefinition.shouldLog(Level.SEVERE)) {
                XmlAnyDefinition.log(Level.SEVERE, stringBuffer.toString());
            }
        }
        return vector.size() == 0;
    }

    private String dumpAttributes(boolean bl, String string) {
        String string2 = "";
        Set set = this.attributes.keySet();
        ArrayList arrayList = new ArrayList(set);
        if (bl) {
            Collections.sort(arrayList, new PropertyInfoComparator());
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            PropertyInfo propertyInfo = (PropertyInfo)iterator.next();
            string2 = string2 + NEW_LINE;
            string2 = string2 + string;
            string2 = string2 + "Attribute: " + propertyInfo.namespace + "." + propertyInfo.name + " = " + this.attributes.get(propertyInfo);
        }
        string2 = string2 + (string2.length() > 1 ? NEW_LINE : NEW_LINE + string + "** no attributes defined **" + NEW_LINE);
        return string2;
    }

    private String dumpText(boolean bl, String string) {
        return NEW_LINE + string + "Text: " + this.text + NEW_LINE;
    }

    private String dumpChildren(boolean bl, String string) {
        String string2 = "";
        ArrayList arrayList = new ArrayList(this.children);
        if (bl) {
            Collections.sort(arrayList, new XmlAnyDefinitionComparator());
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            XmlAnyDefinition xmlAnyDefinition = (XmlAnyDefinition)iterator.next();
            string2 = string2 + xmlAnyDefinition.dumpXmlAnyDefinition(bl, string);
        }
        return string2;
    }

    private static boolean shouldLog(Level level) {
        return level.intValue() >= DEBUG_XML_PARSING;
    }

    private static void log(Level level, String string) {
        if (XmlAnyDefinition.shouldLog(level)) {
            Trace.log(Utility.FrameworkLogger, level, XmlAnyDefinition.class, string, null);
        }
    }

    static class XmlAnyDefinitionComparator
    implements Comparator {
        XmlAnyDefinitionComparator() {
        }

        private String getName(Object object) {
            XmlAnyDefinition xmlAnyDefinition;
            if (object != null && (xmlAnyDefinition = (XmlAnyDefinition)object) != null) {
                String string = (String)xmlAnyDefinition.getAttributeValue("id");
                if (string == null) {
                    string = (String)xmlAnyDefinition.getAttributeValue("name");
                }
                if (string != null) {
                    return string;
                }
            }
            return "";
        }

        public int compare(Object object, Object object2) {
            String string = this.getName(object);
            String string2 = this.getName(object2);
            return string.compareTo(string2);
        }
    }

    static class PropertyInfoComparator
    implements Comparator {
        PropertyInfoComparator() {
        }

        private String getName(Object object) {
            PropertyInfo propertyInfo;
            if (object != null && (propertyInfo = (PropertyInfo)object) != null && propertyInfo.name != null) {
                return propertyInfo.name;
            }
            return "";
        }

        public int compare(Object object, Object object2) {
            String string = this.getName(object);
            String string2 = this.getName(object2);
            return string.compareTo(string2);
        }
    }
}

