/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.util;

import com.sun.util.logging.Level;
import com.sun.util.logging.LogManager;
import com.sun.util.logging.Logger;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.zip.ZipFile;
import oracle.adfmf.framework.api.DateUtility;
import oracle.adfmf.framework.api.JSONBeanSerializationHelper;
import oracle.adfmf.framework.exception.AdfException;
import oracle.adfmf.framework.exception.MalformedMessageException;
import oracle.adfmf.json.JSONArray;
import oracle.adfmf.json.JSONException;
import oracle.adfmf.json.JSONObject;
import oracle.adfmf.misc.Converter;
import oracle.adfmf.util.PlatformUtility;
import oracle.adfmf.util.TeeOutputStream;
import oracle.adfmf.util.XmlAnyDefinition;
import oracle.adfmf.util.logging.Trace;
import oracle.adfmf.util.regex.Matcher;
import oracle.adfmf.util.regex.Pattern;

public class Utility {
    public static final String FRAMEWORK_LOGNAME = "oracle.adfmf.framework";
    public static final String APP_LOGNAME = "oracle.adfmf.application";
    public static final String PERFORMANCE_LOGNAME = "oracle.adfmf.performance";
    public static Logger FrameworkLogger;
    public static Logger ApplicationLogger;
    public static Logger PerformanceLogger;
    public static final byte OSFAMILY_TBD = -2;
    public static final byte OSFAMILY_UNKNOWN = -1;
    public static final byte OSFAMILY_IOS = 0;
    public static final byte OSFAMILY_ANDROID = 1;
    public static final byte OSFAMILY_MACOS = 2;
    public static final byte OSFAMILY_WINDOWS = 3;
    public static final byte OSFAMILY_LINUX = 4;
    private static byte osFamily;
    public static final byte CHANNELSIDE_TBD = -2;
    public static final byte CHANNELSIDE_UNKNOWN = -1;
    public static final byte CHANNELSIDE_EMBEDDED = 0;
    public static final byte CHANNELSIDE_CONTAINER = 1;
    private static byte channelSide;
    private static final String DOT_ADF_META_INF = ".adf/META-INF";
    private static final String CONNECTIONS_DOT_RESOURCENAME = ".adf/META-INF/connections.xml";
    private static final String ADF_CONFIG_RESOURCENAME = ".adf/META-INF/adf-config.xml";
    private static final String ADFMF_CONFIG_RESOURCENAME = ".adf/META-INF/adfmf-config.xml";
    private static XmlAnyDefinition s_references;
    private static XmlAnyDefinition s_adfConfigXml;
    private static XmlAnyDefinition s_adfmfConfigXml;
    private static final String LOGGING_PROPERTIES_NAME = "logging.properties";
    private static final String IOS_EMBEDDED_LOGGING_PROPERTIES = "lib/logging.properties";
    private static final String ANDROID_LOGGING_PROPERTIES = "storage/jvm/lib/logging.properties";
    private static final String ANDROID_RESOURCE_LOGGING_PROPERTIES = "assets/storage/jvm/lib/logging.properties";
    public static final String DATA_DIR_PROPERTY = "data.dir";
    public static final String EXCEPTION_KEY = "exception";
    protected static final Class BYTE_ARRAY_CLASS;
    private static Boolean runningInTestMode;

    private static InputStream getLoggingInputStreamRaw() throws IOException {
        byte by = Utility.getOSFamily();
        if (by == 0) {
            return Utility.getResourceAsStream(IOS_EMBEDDED_LOGGING_PROPERTIES);
        }
        if (osFamily == 1) {
            try {
                String string;
                File file;
                String string2 = Utility.getDataDir();
                if (!Utility.isEmpty(string2) && (file = new File(string = string2 + "/" + ANDROID_LOGGING_PROPERTIES)).exists()) {
                    return new FileInputStream(file);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return Utility.getResourceAsStream(ANDROID_RESOURCE_LOGGING_PROPERTIES);
        }
        File file = new File(LOGGING_PROPERTIES_NAME);
        if (file.exists()) {
            return new FileInputStream(file);
        }
        return Utility.getResourceAsStream(LOGGING_PROPERTIES_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InputStream getLoggingInputStream() throws IOException {
        ByteArrayInputStream byteArrayInputStream = null;
        InputStream inputStream = null;
        InputStreamReader inputStreamReader = null;
        try {
            int n;
            inputStream = Utility.getLoggingInputStreamRaw();
            StringBuffer stringBuffer = new StringBuffer(".level=SEVERE\n");
            inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
            char[] cArray = new char[1024];
            while ((n = inputStreamReader.read(cArray)) > 0) {
                stringBuffer.append(cArray, 0, n);
            }
            byteArrayInputStream = new ByteArrayInputStream(stringBuffer.toString().getBytes("UTF-8"));
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            Utility.closeSilently(inputStream);
            Utility.closeSilently(inputStreamReader);
            throw throwable;
        }
        Utility.closeSilently(inputStream);
        Utility.closeSilently(inputStreamReader);
        return byteArrayInputStream;
    }

    public static String ensureTrailingForwardSlash(String string) {
        if (!string.endsWith("/")) {
            return string + "/";
        }
        return string;
    }

    public static String getDataDir() {
        return PlatformUtility.getDataDir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readLoggerConfig() {
        if (FrameworkLogger != null) {
            return;
        }
        Logger logger = null;
        Logger logger2 = null;
        Logger logger3 = null;
        InputStream inputStream = null;
        try {
            inputStream = Utility.getLoggingInputStream();
            LogManager.getLogManager().readConfiguration(inputStream);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            Utility.closeSilently(inputStream);
            try {
                logger = Logger.getLogger((String)FRAMEWORK_LOGNAME);
                logger2 = Logger.getLogger((String)APP_LOGNAME);
                logger3 = Logger.getLogger((String)PERFORMANCE_LOGNAME);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            FrameworkLogger = logger;
            ApplicationLogger = logger2;
            PerformanceLogger = logger3;
            throw throwable;
        }
    }

    public static void redirectLogging(String string, boolean bl) {
        try {
            File file = new File(string);
            if (!bl && file.exists()) {
                file.renameTo(new File(string + ".bak"));
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file, true);
            TeeOutputStream teeOutputStream = new TeeOutputStream(string, System.out, fileOutputStream);
            TeeOutputStream teeOutputStream2 = new TeeOutputStream(string, System.err, fileOutputStream);
            System.setOut(new PrintStream(teeOutputStream));
            System.setErr(new PrintStream(teeOutputStream2));
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    public static final boolean isNotEmpty(Object[] objectArray) {
        return null != objectArray && objectArray.length > 0;
    }

    public static final boolean isEmpty(String string) {
        return string == null || string.length() < 1;
    }

    public static final boolean isNotEmpty(String string) {
        return !Utility.isEmpty(string);
    }

    public static final boolean stringToBool(String string) {
        return Utility.stringToBool(string, false);
    }

    public static final boolean stringToBool(String string, boolean bl) {
        if (string == null) {
            return bl;
        }
        if ((string = string.toLowerCase()).equalsIgnoreCase("true")) {
            return true;
        }
        if (string.equalsIgnoreCase("false")) {
            return false;
        }
        throw new IllegalArgumentException(Utility.getResourceString("oracle.adfmf.resource.SharedErrorBundle", "ADF-MF-10013", new Object[]{string}));
    }

    public static final InputStream closeSilently(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static final OutputStream closeSilently(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static final ZipFile closeSilently(ZipFile zipFile) {
        if (zipFile != null) {
            try {
                zipFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static InputStream getResourceAsStream(String string) {
        return PlatformUtility.getResourceAsStream(string);
    }

    public static InputStream getResourceAsStreamFromDisk(String string) throws FileNotFoundException {
        return PlatformUtility.getResourceAsStreamFromDisk(string);
    }

    public static String getResourceString(String string, String string2) {
        return Utility.getResourceString(string, string2, null);
    }

    public static String getResourceString(String string, String string2, Object[] objectArray) {
        String string3 = "";
        if (Utility.isEmpty(string)) {
            throw new IllegalArgumentException("Null/ Empty resource bundle name specified");
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle(string);
        string3 = Utility.getResourceString(resourceBundle, string2, objectArray);
        return string3;
    }

    public static String getResourceString(ResourceBundle resourceBundle, String string, Object[] objectArray) {
        String string2 = "";
        if (null == resourceBundle) {
            throw new IllegalArgumentException("Null resource bundle specified");
        }
        string2 = resourceBundle.getString(string);
        string2 = Utility.formatMessage(string2, objectArray);
        return string2;
    }

    public static boolean isRunningOnEmbeddedSide() {
        return Utility.getChannelSide() == 0;
    }

    public static boolean isRunningOnContainerSide() {
        return Utility.getChannelSide() == 1;
    }

    public static byte getChannelSide() {
        if (channelSide == -2) {
            switch (Utility.getOSFamily()) {
                case 0: {
                    channelSide = 0;
                    break;
                }
                case 1: {
                    String string = System.getProperty("java.vendor");
                    if (Utility.isEmpty(string)) {
                        channelSide = (byte)-1;
                        break;
                    }
                    if (string.indexOf("Android") >= 0) {
                        channelSide = 1;
                        break;
                    }
                    if (string.indexOf("Sun") >= 0) {
                        channelSide = 0;
                        break;
                    }
                    channelSide = (byte)-1;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    channelSide = 0;
                    break;
                }
                default: {
                    channelSide = (byte)-1;
                }
            }
        }
        return channelSide;
    }

    public static byte getOSFamily() {
        if (osFamily == -2) {
            String string = System.getProperty("os.name");
            if (Utility.isEmpty(string)) {
                osFamily = (byte)-1;
            }
            osFamily = (string = string.toLowerCase()).indexOf("windows") >= 0 ? (byte)3 : (string.indexOf("mac") >= 0 ? (byte)2 : (string.indexOf("darwin") >= 0 ? (byte)0 : (string.indexOf("linux") >= 0 ? (Boolean.getBoolean("desktopLinux") ? (byte)4 : (byte)1) : (byte)-1)));
        }
        return osFamily;
    }

    public static final XmlAnyDefinition getConnection(String string) {
        return Utility.getConnections().getChildDefinition("Reference", "name", string);
    }

    public static XmlAnyDefinition getConnections() {
        if (s_references == null) {
            s_references = XmlAnyDefinition.loadXmlFromLocation(CONNECTIONS_DOT_RESOURCENAME, "References");
        }
        return s_references;
    }

    public static XmlAnyDefinition getAdfConfigXml() {
        if (s_adfConfigXml == null) {
            s_adfConfigXml = XmlAnyDefinition.loadXmlFromLocation(ADF_CONFIG_RESOURCENAME, "adf-config");
        }
        return s_adfConfigXml;
    }

    public static XmlAnyDefinition getAdfmfConfigXml() {
        if (null == s_adfmfConfigXml) {
            s_adfmfConfigXml = XmlAnyDefinition.loadXmlFromLocation(ADFMF_CONFIG_RESOURCENAME, "adfmf-config");
        }
        return s_adfmfConfigXml;
    }

    public static final String formatMessage(String string, Object[] objectArray) {
        try {
            Pattern pattern = Pattern.compile((String)"\\{([ \t]*[0-9]+[ \t]*)\\}");
            Matcher matcher = pattern.matcher((CharSequence)string);
            StringBuffer stringBuffer = new StringBuffer();
            while (matcher.find()) {
                int n = Integer.parseInt(matcher.group(1).trim());
                if (n >= objectArray.length) continue;
                matcher.appendReplacement(stringBuffer, "" + objectArray[n]);
            }
            matcher.appendTail(stringBuffer);
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            if (FrameworkLogger.isLoggable(Level.WARNING)) {
                Trace.log(FrameworkLogger, Level.WARNING, Utility.class, "formatMessage", (Object)("Cannot format message: " + string));
            }
            return string;
        }
    }

    public static final String replaceString(String string, String string2, String string3) {
        if (string == null || string2 == null) {
            return string;
        }
        String string4 = string;
        int n = 0;
        int n2 = string3 != null ? string3.length() : 0;
        while ((n = string4.indexOf(string2, n)) > -1) {
            string4 = string4.substring(0, n) + string3 + string4.substring(n + string2.length());
            n += n2;
        }
        return string4;
    }

    public static final Reader closeSilently(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static final Writer closeSilently(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static final boolean resourceExists(String string) {
        InputStream inputStream = PlatformUtility.getResourceAsStream(string);
        if (inputStream == null) {
            return false;
        }
        Utility.closeSilently(inputStream);
        return true;
    }

    public static final Class loadClass(String string) throws ClassNotFoundException {
        return PlatformUtility.loadClass(string);
    }

    public static final String[] tokenize(String string, String string2) {
        return Utility.tokenize(string, string2, 2000);
    }

    public static final String[] tokenize(String string, String string2, int n) {
        if (string == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>(n);
        int n2 = 0;
        int n3 = 0;
        while ((n3 = string.indexOf(string2, n2)) > -1 && vector.size() < n - 1) {
            vector.addElement(string.substring(n2, n3));
            n2 = n3 + string2.length();
        }
        vector.addElement(string.substring(n2, string.length()));
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static final String[] toStringArray(Object[] objectArray, boolean bl) {
        if (objectArray == null) {
            return null;
        }
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = objectArray[i] == null && bl ? null : objectArray[i].toString();
        }
        return stringArray;
    }

    public static final Method getReadAccessorFromPropertyName(Object object, String string) {
        String string2 = null;
        Method method = null;
        if (null != string && (method = Utility.getMethod(object, string2 = "get" + string.substring(0, 1).toUpperCase() + (string.length() > 1 ? string.substring(1) : ""), new Class[0])) == null) {
            string2 = "is" + string2.substring(3);
            method = Utility.getMethod(object, string2, new Class[0]);
        }
        if (method == null) {
            throw new AdfException("ERROR", "oracle.adfmf.resource.SharedErrorBundle", "ADF-MF-10016", new Object[]{string, object.getClass().getName()});
        }
        return method;
    }

    public static final Method getWriteAccessorFromPropertyName(Object object, String string, Class clazz) {
        String string2 = "set" + string.substring(0, 1).toUpperCase() + (string.length() > 1 ? string.substring(1) : "");
        Method method = Utility.getMethod(object, string2, new Class[]{clazz});
        if (method == null) {
            throw new AdfException("ERROR", "oracle.adfmf.resource.SharedErrorBundle", "ADF-MF-10048", new Object[]{string, object.getClass().getName()});
        }
        return method;
    }

    public static final Object attemptToGetPropertyValue(Object object, String string) {
        Object object2 = null;
        try {
            Method method = Utility.getReadAccessorFromPropertyName(object, string);
            object2 = method.invoke(object, (Object[])null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return object2;
    }

    public static Object invoke(String string, String string2, JSONArray jSONArray) throws Throwable {
        Class clazz = null;
        Method[] methodArray = null;
        Object object = null;
        boolean bl = false;
        try {
            clazz = Utility.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AdfException("ERROR", "oracle.adfmf.resource.SharedErrorBundle", "ADF-MF-10001", new Object[]{classNotFoundException.getMessage()});
        }
        methodArray = clazz.getMethods();
        if (FrameworkLogger.isLoggable(Level.FINE)) {
            Trace.log(FrameworkLogger, Level.FINE, Utility.class, "invoke", "Utility({0}, {1}, ...)", new Object[]{string, string2});
        }
        for (int i = 0; !bl && i < methodArray.length; ++i) {
            if (!string2.equals(methodArray[i].getName()) || methodArray[i].getParameterTypes().length != jSONArray.length()) continue;
            try {
                bl = true;
                object = Utility.invoke(clazz, methodArray[i], jSONArray);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (FrameworkLogger.isLoggable(Level.FINE)) {
                    Trace.log(FrameworkLogger, Level.FINE, class$oracle$adfmf$util$Utility == null ? Utility.class$("oracle.adfmf.util.Utility") : class$oracle$adfmf$util$Utility, "invoke", "oracle.adfmf.resource.SharedErrorBundle", "ADF-MF-10009", new Object[]{"InstantiationException", illegalArgumentException});
                }
                bl = false;
                continue;
            }
            catch (InstantiationException instantiationException) {
                if (FrameworkLogger.isLoggable(Level.SEVERE)) {
                    Trace.log(FrameworkLogger, Level.SEVERE, class$oracle$adfmf$util$Utility == null ? Utility.class$("oracle.adfmf.util.Utility") : class$oracle$adfmf$util$Utility, "invoke", "oracle.adfmf.resource.SharedErrorBundle", "ADF-MF-10009", new Object[]{"InstantiationException", instantiationException});
                }
                bl = false;
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                if (FrameworkLogger.isLoggable(Level.SEVERE)) {
                    Trace.log(FrameworkLogger, Level.SEVERE, Utility.class, "invoke", "oracle.adfmf.resource.SharedErrorBundle", "ADF-MF-10009", new Object[]{"InvocationTargetException", invocationTargetException.getTargetException()});
                }
                throw invocationTargetException.getTargetException();
            }
        }
        if (!bl) {
            if (FrameworkLogger.isLoggable(Level.SEVERE)) {
                Trace.log(FrameworkLogger, Level.SEVERE, Utility.class, "invoke", "oracle.adfmf.resource.SharedErrorBundle", "ADF-MF-10004", new Object[]{string, string2});
            }
            throw new AdfException("ERROR", "oracle.adfmf.resource.SharedErrorBundle", "ADF-MF-10003", new Object[]{string2});
        }
        if (FrameworkLogger.isLoggable(Level.INFO)) {
            Trace.log(FrameworkLogger, Level.INFO, Utility.class, "invoke", "oracle.adfmf.resource.SharedInfoBundle", "ADF-MF-40014", new Object[]{string, string2, object});
        }
        return object;
    }

    public static Object invoke(Class clazz, Method method, JSONArray jSONArray) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Class<?>[] classArray = method.getParameterTypes();
        Object[] objectArray = new Object[classArray.length];
        Object var5_5 = null;
        for (int i = 0; i < classArray.length; ++i) {
            try {
                if (FrameworkLogger.isLoggable(Level.FINE)) {
                    Trace.log(FrameworkLogger, Level.FINE, class$oracle$adfmf$util$Utility == null ? Utility.class$("oracle.adfmf.util.Utility") : class$oracle$adfmf$util$Utility, "invoke", "oracle.adfmf.resource.SharedInfoBundle", "ADF-MF-40003", new Object[]{classArray[i], jSONArray.get(i)});
                }
                objectArray[i] = JSONBeanSerializationHelper.fromJSON(classArray[i], jSONArray.get(i));
                continue;
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(Utility.getResourceString("oracle.adfmf.resource.SharedErrorBundle", "ADF-MF-10010", new Object[]{new Integer(i)}));
            }
        }
        var5_5 = clazz.newInstance();
        if (FrameworkLogger.isLoggable(Level.FINE)) {
            Trace.log(FrameworkLogger, Level.FINE, Utility.class, "invoke", "Invoking the method : {0}", new Object[]{method.getName()});
        }
        return method.invoke(var5_5, objectArray);
    }

    public static final Object invokeIfPossible(Object object, String string, Class[] classArray, Object[] objectArray) {
        block3: {
            try {
                if (object != null) {
                    Method method = Utility.getMethod(object, string, classArray);
                    return method != null ? method.invoke(object, objectArray) : null;
                }
            }
            catch (Throwable throwable) {
                if (!FrameworkLogger.isLoggable(Level.WARNING)) break block3;
                Trace.log(FrameworkLogger, Level.WARNING, Utility.class, "invokeIfPossible", "oracle.adfmf.resource.SharedInfoBundle", "ADF-MF-10003", new Object[]{string});
            }
        }
        return null;
    }

    public static final Method getMethod(Object object, String string, Class[] classArray) {
        Method method;
        block2: {
            Class<?> clazz = null;
            method = null;
            try {
                clazz = object.getClass();
                method = clazz.getMethod(string, classArray);
            }
            catch (Throwable throwable) {
                if (!FrameworkLogger.isLoggable(Level.INFO)) break block2;
                Trace.log(FrameworkLogger, Level.INFO, Utility.class, "getMethod", "oracle.adfmf.resource.SharedInfoBundle", "ADF-MF-40013", new Object[]{string});
            }
        }
        return method;
    }

    public static final String joinStrings(String[] stringArray, String string) {
        if (stringArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    public static Object convert(String string, Class clazz) {
        try {
            if (Object.class.equals(clazz)) {
                return string;
            }
            if (DateUtility.isDateType(clazz)) {
                return DateUtility.convert(string, clazz);
            }
            if (BYTE_ARRAY_CLASS.equals(clazz)) {
                int n = string == null ? 0 : string.length() / 2;
                byte[] byArray = new byte[n];
                boolean bl = true;
                for (int i = 0; i < n; ++i) {
                    int n2 = i * 2;
                    int n3 = n2 + 2;
                    String string2 = string.substring(n2, n3);
                    int n4 = bl ? i + 1 : i - 1;
                    byArray[n4] = Byte.parseByte(string2, 16);
                    bl = !bl;
                }
                return byArray;
            }
            Constructor constructor = clazz.getConstructor(String.class);
            Object t = constructor.newInstance(string);
            return t;
        }
        catch (Exception exception) {
            if (FrameworkLogger.isLoggable(Level.FINE)) {
                Trace.log(FrameworkLogger, Level.FINE, Utility.class, "convert", "Unable to coerce {0} to {1}; returning {0} as a java.lang.String. This is not necessarily a problem.", new Object[]{string, clazz.getName()});
            }
            return string;
        }
    }

    public static void printCurrentStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        if (FrameworkLogger.isLoggable(Level.SEVERE)) {
            Trace.log(FrameworkLogger, Level.SEVERE, Utility.class, "printCurrentStackTrace", (Object)(throwable.getMessage() + "\n" + stringWriter.toString() + "\n\n"));
        }
    }

    public static AdfException findAdfException(Throwable throwable) {
        if (throwable instanceof AdfException) {
            return (AdfException)throwable;
        }
        Throwable throwable2 = throwable.getCause();
        if (throwable2 != null) {
            return Utility.findAdfException(throwable2);
        }
        return null;
    }

    public static Throwable getCoreThrowableCause(Throwable throwable) {
        Throwable throwable2 = throwable;
        if (null != throwable && null == (throwable2 = Utility.getCoreThrowableCause(throwable.getCause()))) {
            throwable2 = throwable;
        }
        return throwable2;
    }

    public static boolean isRunningInTestMode() {
        if (runningInTestMode == null) {
            String string = System.getProperty("testMode");
            runningInTestMode = string == null ? Boolean.FALSE : Boolean.valueOf(string);
        }
        return runningInTestMode;
    }

    public static String getGetterVariable(Method method) {
        String string = "";
        if (null != method) {
            String string2 = method.getName();
            if (string2.startsWith("get") && !string2.equals("getClass") && !string2.equals("getDeclaringClass")) {
                string = string2.substring(3);
            } else if (string2.startsWith("is")) {
                string = string2.substring(2);
            }
            string = string.length() > 0 && Character.isUpperCase(string.charAt(0)) && method.getParameterTypes().length == 0 ? (string.length() == 1 ? string.toLowerCase() : string.substring(0, 1).toLowerCase() + string.substring(1)) : "";
        }
        return string;
    }

    public static String getSetterVariable(Method method) {
        String string = "";
        if (null != method) {
            String string2 = method.getName();
            if (string2.startsWith("set")) {
                string = string2.substring(3);
            }
            string = string.length() > 0 && Character.isUpperCase(string.charAt(0)) && method.getParameterTypes().length == 1 ? (string.length() == 1 ? string.toLowerCase() : string.substring(0, 1).toLowerCase() + string.substring(1)) : "";
        }
        return string;
    }

    public static Object getCaseInsenstiveVariableValueFromJSON(JSONObject jSONObject, String string) throws JSONException {
        int n = 0;
        String string2 = null;
        try {
            return jSONObject.get(string);
        }
        catch (JSONException jSONException) {
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                if (string3.compareToIgnoreCase(string) != 0 || ++n != 1) continue;
                string2 = string3;
            }
            if (n == 1) {
                return jSONObject.get(string2);
            }
            throw jSONException;
        }
    }

    public static boolean isVariableTransient(Class clazz, String string) {
        boolean bl = false;
        if (null != clazz && Utility.isNotEmpty(string)) {
            try {
                Field field = Utility.getCaseInsensitiveDeclaredFieldinClass(clazz, string);
                if (null != field && Modifier.isTransient(field.getModifiers())) {
                    bl = true;
                }
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        return bl;
    }

    public static Field getCaseInsensitiveDeclaredFieldinClass(Class clazz, String string) throws SecurityException, NoSuchFieldException {
        int n = 0;
        Field field = null;
        try {
            field = clazz.getDeclaredField(string);
            return field;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Field[] fieldArray = clazz.getDeclaredFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                if (fieldArray[i].getName().compareToIgnoreCase(string) != 0 || ++n != 1) continue;
                field = fieldArray[i];
            }
            if (n == 1) {
                return field;
            }
            throw noSuchFieldException;
        }
    }

    public static boolean isUrlRemote(String string) {
        if (Utility.isEmpty(string)) {
            return false;
        }
        String string2 = string.toLowerCase();
        return !string2.startsWith("file://") && string2.indexOf("://") >= 0;
    }

    public static boolean isStandardType(Class clazz) {
        return clazz == Boolean.TYPE || clazz == Byte.TYPE || clazz == Double.TYPE || clazz == Float.TYPE || clazz == Integer.TYPE || clazz == Long.TYPE || clazz == Short.TYPE || clazz == Character.TYPE || clazz == Boolean.class || clazz == Byte.class || clazz == Double.class || clazz == Float.class || clazz == Integer.class || clazz == BigInteger.class || clazz == BigDecimal.class || clazz == Long.class || clazz == Short.class || clazz == Character.class || clazz == String.class;
    }

    public static Object createArray(Class clazz, int n) {
        Object object = null;
        try {
            object = Array.newInstance(clazz, n);
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            // empty catch block
        }
        if (object == null) {
            throw new AdfException("ERROR", "oracle.adfmf.resource.SharedErrorBundle", "ADF-MF-10020", new Object[]{clazz, new Integer(n)});
        }
        return object;
    }

    public static Object coerceToType(Object object, Class clazz) {
        Class<?> clazz2;
        if (object != null && (clazz2 = object.getClass()) != clazz && !clazz.isAssignableFrom(clazz2)) {
            object = Converter.coerceToType((Object)object, (Class)clazz);
        }
        return object;
    }

    public static byte[] stringToBytes(String string) {
        byte[] byArray = null;
        try {
            if (string != null) {
                byArray = string.getBytes("UTF-8");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AdfException("ERROR", "oracle.adfmf.resource.SharedErrorBundle", "ADF-MF-10027", null);
        }
        return byArray;
    }

    public static String bytesToString(byte[] byArray) {
        String string = null;
        try {
            if (byArray != null) {
                string = new String(byArray, "UTF-8");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AdfException("ERROR", "oracle.adfmf.resource.SharedErrorBundle", "ADF-MF-10027", null);
        }
        return string;
    }

    public static char[] obfuscate(char[] cArray) {
        if (cArray == null) {
            return null;
        }
        try {
            byte[] byArray = String.valueOf(cArray).getBytes("UTF-8");
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] >= 97 && byArray[i] <= 109) {
                    int n = i;
                    byArray[n] = (byte)(byArray[n] + 13);
                    continue;
                }
                if (byArray[i] >= 65 && byArray[i] <= 77) {
                    int n = i;
                    byArray[n] = (byte)(byArray[n] + 13);
                    continue;
                }
                if (byArray[i] >= 110 && byArray[i] <= 122) {
                    int n = i;
                    byArray[n] = (byte)(byArray[n] - 13);
                    continue;
                }
                if (byArray[i] < 78 || byArray[i] > 90) continue;
                int n = i;
                byArray[n] = (byte)(byArray[n] - 13);
            }
            return new String(byArray, "UTF-8").toCharArray();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AdfException("ERROR", "oracle.adfmf.resource.SharedErrorBundle", "ADF-MF-10027", null);
        }
    }

    public static char[] unobfuscate(char[] cArray) {
        return Utility.obfuscate(cArray);
    }

    public static AdfException getException(JSONObject jSONObject) {
        AdfException adfException = null;
        if (null != jSONObject) {
            Object object = null;
            try {
                object = jSONObject.get(EXCEPTION_KEY);
            }
            catch (JSONException jSONException) {
                return new MalformedMessageException(Utility.getResourceString("oracle.adfmf.resource.SharedErrorBundle", "ADF-MF-10046"));
            }
            Object object2 = null;
            if (null != object) {
                if (object instanceof JSONObject) {
                    JSONObject jSONObject2 = (JSONObject)object;
                    try {
                        object2 = JSONBeanSerializationHelper.fromJSON(Object.class, jSONObject2);
                    }
                    catch (Exception exception) {
                        try {
                            object2 = JSONBeanSerializationHelper.fromJSON(AdfException.class, jSONObject2);
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                    }
                }
                if (null == object2) {
                    adfException = new AdfException(object.toString(), "ERROR");
                } else if (object2 instanceof AdfException) {
                    adfException = (AdfException)object2;
                } else if (!(object2 instanceof AdfException)) {
                    adfException = new AdfException((Throwable)object2, "ERROR");
                }
            }
        }
        return adfException;
    }

    public static String removeQuotes(String string) {
        if (string.charAt(0) == '\"') {
            string = string.substring(1);
        }
        if (string.charAt(string.length() - 1) == '\"') {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    static {
        osFamily = (byte)-2;
        channelSide = (byte)-2;
        s_references = null;
        BYTE_ARRAY_CLASS = new Byte[0].getClass();
    }
}

