/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.share.security;

import java.util.ArrayList;
import java.util.HashMap;
import oracle.adfmf.framework.Scope;
import oracle.adfmf.framework.api.AdfmfContainerUtilities;
import oracle.adfmf.framework.api.JSONBeanSerializationHelper;
import oracle.adfmf.framework.api.JSONSerializable;
import oracle.adfmf.framework.exception.AdfException;
import oracle.adfmf.share.security.UserObjects;
import oracle.adfmf.share.security.WSsimulator.UserObjectTestData;
import oracle.adfmf.share.security.securityContext;
import oracle.adfmf.util.CredentialStoreUtil;

public class securityContextImpl
extends Scope
implements securityContext,
JSONSerializable {
    public static final String AUTHENTICATED_PROP = "authenticated";
    public static final String USERGRANTEDPRIVILEGE_PROP = "userGrantedPrivilege";
    public static final String USERINROLE_PROP = "userInRole";
    public static final String USERNAME_PROP = "userName";
    protected boolean serializing = false;

    public securityContextImpl() {
        super("securityContext");
        super.put(USERGRANTEDPRIVILEGE_PROP, new userGrantedPrivilege_Thunk(), false);
        super.put(USERINROLE_PROP, new userInRole_Thunk(), false);
    }

    public Object get(Object object) {
        if (this.isSerializing() && this.containsKey(object)) {
            return super.get(object);
        }
        if (AUTHENTICATED_PROP.equals(object)) {
            String string = this.isAuthenticated();
            super.put(AUTHENTICATED_PROP, string, false);
            return string;
        }
        if (USERNAME_PROP.equals(object)) {
            String string = this.getUserName();
            super.put(USERNAME_PROP, string, false);
            return string;
        }
        return super.get(object);
    }

    public Object put(Object object, Object object2) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object toJSON() throws Exception {
        securityContextImpl securityContextImpl2 = this;
        synchronized (securityContextImpl2) {
            this.serializing = true;
            String[] stringArray = new String[]{AUTHENTICATED_PROP, USERGRANTEDPRIVILEGE_PROP, USERINROLE_PROP, USERNAME_PROP};
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (int i = 0; i < stringArray.length; ++i) {
                Object object = this.get(stringArray[i]);
                hashMap.put(stringArray[i], object);
            }
            Object object = JSONBeanSerializationHelper.toJSON(hashMap);
            this.serializing = false;
            return object;
        }
    }

    protected synchronized boolean isSerializing() {
        return this.serializing;
    }

    public String getUserName() throws AdfException {
        try {
            return CredentialStoreUtil.getCurrentUsername();
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    public String isUserInRole(String string) throws AdfException {
        try {
            Object[] objectArray = new Object[]{string};
            return (String)AdfmfContainerUtilities.invokeContainerMethod("oracle.adfmf.util.CredentialStoreHandler", "isUserInRole", objectArray);
        }
        catch (Throwable throwable) {
            return "false";
        }
    }

    public String hasPrivilege(String string) throws AdfException {
        try {
            Object[] objectArray = new Object[]{string};
            return (String)AdfmfContainerUtilities.invokeContainerMethod("oracle.adfmf.util.CredentialStoreHandler", "hasPrivilege", objectArray);
        }
        catch (Throwable throwable) {
            return "false";
        }
    }

    public String isAuthenticated() throws AdfException {
        try {
            return CredentialStoreUtil.isAuthenticated();
        }
        catch (Throwable throwable) {
            return "false";
        }
    }

    public void initializeUserObjects(String string, String string2, String string3, ArrayList arrayList) throws AdfException {
        UserObjects userObjects = null;
        UserObjectTestData userObjectTestData = new UserObjectTestData();
        userObjects = userObjectTestData.getUserObjectsForUser(string2);
        this.populateCredentialStore(userObjects);
    }

    public void initializeUserObjects(String string) throws AdfException {
        UserObjects userObjects = null;
        UserObjectTestData userObjectTestData = new UserObjectTestData();
        userObjects = userObjectTestData.getUserObjectsForUser("testuser1");
        this.populateCredentialStore(userObjects);
    }

    private void populateCredentialStore(UserObjects userObjects) {
        Object[] objectArray = new Object[]{userObjects.toString()};
        AdfmfContainerUtilities.invokeContainerMethod("oracle.adfmf.util.CredentialStoreHandler", "storeUserObjects", objectArray);
    }

    private final class userInRole_Thunk
    extends HashMap {
        private userInRole_Thunk() {
        }

        public Object get(Object object) {
            if (securityContextImpl.this.isSerializing()) {
                return super.get(object);
            }
            String string = securityContextImpl.this.isUserInRole((String)object);
            super.put(object, string);
            return string;
        }
    }

    private final class userGrantedPrivilege_Thunk
    extends HashMap {
        private userGrantedPrivilege_Thunk() {
        }

        public Object get(Object object) {
            if (securityContextImpl.this.isSerializing()) {
                return super.get(object);
            }
            String string = securityContextImpl.this.hasPrivilege((String)object);
            super.put(object, string);
            return string;
        }
    }
}

