/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.metadata.bean.transform;

import java.util.Iterator;
import java.util.List;
import oracle.adfmf.metadata.bean.JavaBeanDefinition;
import oracle.adfmf.metadata.bean.transform.JavaBeanTransform;
import oracle.adfmf.metadata.bean.transform.OperationMethod;
import oracle.adfmf.metadata.bean.transform.OperationMethodTransform;
import oracle.adfmf.metadata.bean.transform.TransformCacheProvider;
import oracle.adfmf.metadata.bean.transform.TransformUtil;
import oracle.adfmf.metadata.dcx.DefinitionDefinition;
import oracle.adfmf.metadata.dcx.soap.SoapDefinitionDefinition;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.XmlAnyDefinition;

public class XmlAnyTransform {
    private String m_id;
    private String m_package;
    private XmlAnyDefinition m_modelTypes;
    private XmlAnyDefinition m_service;
    private final TransformCacheProvider m_cacheProvider;

    private XmlAnyTransform(TransformCacheProvider transformCacheProvider, String string, DefinitionDefinition definitionDefinition) {
        this.m_cacheProvider = transformCacheProvider;
        this.m_package = string;
        this.m_id = definitionDefinition.getName();
        XmlAnyDefinition xmlAnyDefinition = XmlAnyTransform.getModel(this.m_id);
        if (xmlAnyDefinition != null) {
            this.m_modelTypes = xmlAnyDefinition.getChildDefinition("types");
            this.m_service = xmlAnyDefinition.getChildDefinition("service");
        }
    }

    private static XmlAnyDefinition getModel(String string) {
        XmlAnyDefinition xmlAnyDefinition = Utility.getConnection(string);
        if (xmlAnyDefinition == null) {
            return null;
        }
        XmlAnyDefinition xmlAnyDefinition2 = xmlAnyDefinition.getChildDefinition("RefAddresses");
        if (xmlAnyDefinition2 != null) {
            List list = xmlAnyDefinition2.getChildren();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string2;
                XmlAnyDefinition xmlAnyDefinition3 = (XmlAnyDefinition)iterator.next();
                if (!"XmlRefAddr".equals(xmlAnyDefinition3.getElementName()) || !"WebServiceConnection".equals(string2 = TransformUtil.getAttributeValue(xmlAnyDefinition3, "addrType"))) continue;
                xmlAnyDefinition3 = xmlAnyDefinition3.getChildDefinition("Contents");
                xmlAnyDefinition3 = xmlAnyDefinition3.getChildDefinition("wsconnection");
                xmlAnyDefinition3 = xmlAnyDefinition3.getChildDefinition("model");
                return xmlAnyDefinition3;
            }
        }
        return null;
    }

    public static JavaBeanDefinition transform(TransformCacheProvider transformCacheProvider, String string, SoapDefinitionDefinition soapDefinitionDefinition) {
        XmlAnyTransform xmlAnyTransform = new XmlAnyTransform(transformCacheProvider, string, soapDefinitionDefinition);
        OperationMethod[] operationMethodArray = OperationMethodTransform.buildMethodList(xmlAnyTransform, soapDefinitionDefinition);
        return JavaBeanTransform.transform(xmlAnyTransform, operationMethodArray);
    }

    protected String getId() {
        return this.m_id;
    }

    protected String getPackage() {
        return this.m_package;
    }

    protected String getBeanClass() {
        return this.m_package + "." + this.m_id;
    }

    protected XmlAnyDefinition getServicePort(String string) {
        return this.m_service.getChildDefinition("port", "name", string);
    }

    protected XmlAnyDefinition getModelTypes() {
        return this.m_modelTypes;
    }

    protected TransformCacheProvider getCacheProvider() {
        return this.m_cacheProvider;
    }

    protected static String makeFirstLetterUpper(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        char c = string.charAt(0);
        c = Character.toUpperCase(c);
        return c + string.substring(1);
    }
}

