/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.java.beans;

import java.util.ArrayList;
import java.util.Vector;
import oracle.adfmf.java.beans.PropertyChangeEvent;
import oracle.adfmf.java.beans.PropertyChangeListener;

public class PropertyChangeSupport {
    protected transient Vector listeners;
    protected Object source = null;

    public PropertyChangeSupport(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        this.source = object;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(propertyChangeListener);
    }

    public void firePropertyChange(String string, boolean bl, boolean bl2) {
        this.firePropertyChange(new PropertyChangeEvent(this.source, string, bl, bl2));
    }

    public void firePropertyChange(String string, byte by, byte by2) {
        this.firePropertyChange(new PropertyChangeEvent(this.source, string, by, by2));
    }

    public void firePropertyChange(String string, char c, char c2) {
        this.firePropertyChange(new PropertyChangeEvent(this.source, string, c, c2));
    }

    public void firePropertyChange(String string, double d, double d2) {
        this.firePropertyChange(new PropertyChangeEvent(this.source, string, d, d2));
    }

    public void firePropertyChange(String string, float f, float f2) {
        this.firePropertyChange(new PropertyChangeEvent(this.source, string, f, f2));
    }

    public void firePropertyChange(String string, long l, long l2) {
        this.firePropertyChange(new PropertyChangeEvent(this.source, string, l, l2));
    }

    public void firePropertyChange(String string, short s, short s2) {
        this.firePropertyChange(new PropertyChangeEvent(this.source, string, s, s2));
    }

    public void firePropertyChange(String string, int n, int n2) {
        this.firePropertyChange(new PropertyChangeEvent(this.source, string, n, n2));
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        this.firePropertyChange(new PropertyChangeEvent(this.source, string, object, object2));
    }

    public void firePropertyChange(String string, Object object, Object object2, long l) {
        this.firePropertyChange(new PropertyChangeEvent(this, string, object, object2, l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getOldValue();
        Object object2 = propertyChangeEvent.getNewValue();
        if (object != null && object2 != null && object.equals(object2)) {
            return;
        }
        Vector vector = null;
        PropertyChangeSupport propertyChangeSupport = this;
        synchronized (propertyChangeSupport) {
            if (this.listeners != null) {
                vector = (Vector)this.listeners.clone();
            }
        }
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                PropertyChangeListener propertyChangeListener = (PropertyChangeListener)vector.elementAt(i);
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
        }
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        ArrayList arrayList = new ArrayList();
        if (this.listeners != null) {
            arrayList.addAll(this.listeners);
        }
        return arrayList.toArray(new PropertyChangeListener[0]);
    }
}

