/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.message.adf;

import oracle.adfmf.framework.api.JSONBeanSerializationHelper;
import oracle.adfmf.framework.exception.AdfException;
import oracle.adfmf.framework.exception.MalformedMessageException;
import oracle.adfmf.framework.message.AdfType;
import oracle.adfmf.framework.message.adf.AdfHeader;
import oracle.adfmf.framework.message.adf.AdfMessage;
import oracle.adfmf.json.JSONArray;
import oracle.adfmf.json.JSONException;
import oracle.adfmf.json.JSONObject;
import oracle.adfmf.util.Utility;

public class AdfMessageImpl
implements AdfMessage {
    private static final int MAX_SEQUENCE_ID = 99999;
    private static final Object sSequenceIdLock = new Object();
    private static int sLastMessageSequenceId = -1;
    protected AdfHeader adfHeader = null;
    protected AdfType adfBody = new AdfType();
    protected boolean responseReadyFlag = false;

    public AdfMessageImpl(AdfHeader adfHeader) {
        this.adfHeader = adfHeader.copy();
        if (this.adfHeader.getReferenceId() == 0) {
            this.adfHeader.setReferenceId(this.getNextVMSequenceId());
        }
    }

    public AdfMessageImpl(AdfHeader adfHeader, String string) {
        this(adfHeader);
        this.setBody(string);
    }

    public static AdfMessageImpl parse(String string) {
        return new AdfMessageImpl(AdfHeader.parse(string), string.substring(AdfHeader.ADF_HEADER_SIZE));
    }

    public AdfException getException() {
        AdfException adfException = null;
        if (this.isError()) {
            adfException = Utility.getException(this.getBody());
        }
        return adfException;
    }

    public AdfHeader getHeader() {
        return this.adfHeader;
    }

    public JSONObject getBody() {
        return this.adfBody;
    }

    public boolean isResponseReady() {
        return this.responseReadyFlag;
    }

    public void setResponseReady(boolean bl) {
        this.responseReadyFlag = bl;
    }

    public boolean isRequestMessage() {
        return this.adfHeader.isAdfRequestMessage();
    }

    public boolean isResponseMessage() {
        return this.adfHeader.isAdfResponseMessage();
    }

    public boolean isSystemRequest() {
        return false;
    }

    public boolean isError() {
        return "ADFERR".equalsIgnoreCase(this.adfHeader.headerTag);
    }

    private void setError() {
        this.adfHeader.headerTag = "ADFERR";
    }

    public void setBody(JSONObject jSONObject) {
        this.adfBody = new AdfType(jSONObject);
        this.adfHeader.setBodySize(jSONObject.toString().length());
    }

    public void setBody(String string) {
        try {
            this.adfBody = new AdfType(string);
        }
        catch (JSONException jSONException) {
            throw new AdfException(jSONException);
        }
    }

    public void setException(AdfException adfException) {
        if (adfException == null) {
            throw new IllegalArgumentException(Utility.getResourceString("oracle.adfmf.resource.SharedErrorBundle", "ADF-MF-10012"));
        }
        this.setError();
        try {
            this.setValue("exception", JSONBeanSerializationHelper.toJSON(adfException));
        }
        catch (Exception exception) {
            throw new AdfException(exception.getMessage(), "ERROR");
        }
        this.responseReadyFlag = true;
    }

    public String toString() {
        String string = this.adfBody == null ? "" : this.adfBody.toString();
        this.adfHeader.setBodySize(string.length());
        return this.adfHeader.toString() + string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextVMSequenceId() {
        Object object = sSequenceIdLock;
        synchronized (object) {
            if (++sLastMessageSequenceId % 99999 == 0) {
                sLastMessageSequenceId = 1;
            }
            return sLastMessageSequenceId;
        }
    }

    public Object get(String string) throws JSONException {
        return this.adfBody.get(string);
    }

    public JSONObject put(String string, Object object) throws JSONException {
        return this.adfBody.put(string, object);
    }

    public void setValue(String string, Object object) throws MalformedMessageException {
        this.adfBody.setValue(string, object);
    }

    public JSONArray getJSONArray(String string) throws JSONException {
        return this.adfBody.getJSONArray(string);
    }
}

