/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.event;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.adfmf.framework.event.EventSource;
import oracle.adfmf.framework.openurl.OpenURLEventSource;
import oracle.adfmf.framework.pushnotification.NativePushNotificationEventSource;

public class EventSourceFactory {
    private static Map nameToEventSource = new HashMap();
    public static final String OPEN_URL_EVENT_SOURCE_NAME = "OpenURL";
    public static final String NATIVE_PUSH_NOTIFICATION_REMOTE_EVENT_SOURCE_NAME = "NativePushNotification";

    public static EventSource getEventSource(String string) {
        Object v = nameToEventSource.get(string);
        if (v instanceof EventSource) {
            return (EventSource)v;
        }
        throw new IllegalArgumentException();
    }

    public static void registerEventSource(String string, EventSource eventSource) {
        nameToEventSource.put(string, eventSource);
    }

    public static void registerEventSource(String string, Class clazz) {
        if (clazz.isAssignableFrom(EventSource.class)) {
            try {
                EventSource eventSource = (EventSource)clazz.newInstance();
                EventSourceFactory.registerEventSource(string, eventSource);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException();
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public static List getEventSourceNames() {
        return Arrays.asList((String[])nameToEventSource.keySet().toArray());
    }

    static {
        EventSourceFactory.registerEventSource(NATIVE_PUSH_NOTIFICATION_REMOTE_EVENT_SOURCE_NAME, new NativePushNotificationEventSource());
        EventSourceFactory.registerEventSource(OPEN_URL_EVENT_SOURCE_NAME, new OpenURLEventSource());
    }
}

