/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.contract.adf;

import java.lang.reflect.Method;
import oracle.adfmf.framework.contract.adf.ManagedPropertyDefinition;
import oracle.adfmf.framework.exception.AdfException;
import oracle.adfmf.util.Utility;

public class ManagedBeanDefinition {
    private String beanName = null;
    private String fqnClassname = null;
    private String scope = null;
    private ManagedPropertyDefinition[] props = null;

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String string) {
        this.beanName = string;
    }

    public String getFqnClassname() {
        return this.fqnClassname;
    }

    public void setFqnClassname(String string) {
        this.fqnClassname = string;
    }

    public String getScope() {
        return this.scope;
    }

    public String getFullyQualifiedBeanName() {
        if (this.scope == null || this.scope.length() == 0) {
            return this.beanName;
        }
        if (this.scope.endsWith("Scope")) {
            return this.scope + "." + this.beanName;
        }
        return this.scope + "Scope" + "." + this.beanName;
    }

    public void setScope(String string) {
        this.scope = string;
    }

    public ManagedPropertyDefinition[] getProps() {
        return this.props;
    }

    public void setProps(ManagedPropertyDefinition[] managedPropertyDefinitionArray) {
        this.props = managedPropertyDefinitionArray;
    }

    public Object createBeanInstance() {
        try {
            Class clazz = Utility.loadClass(this.fqnClassname);
            Object t = clazz.newInstance();
            for (int i = 0; this.props != null && i < this.props.length; ++i) {
                ManagedPropertyDefinition managedPropertyDefinition = this.props[i];
                String string = managedPropertyDefinition.getName();
                try {
                    Class<?> clazz2 = Class.forName(managedPropertyDefinition.getType());
                    Method method = Utility.getWriteAccessorFromPropertyName(t, string, clazz2);
                    method.invoke(t, managedPropertyDefinition.getValue());
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new AdfException("ERROR", "oracle.adfmf.resource.SharedErrorBundle", "ADF-MF-10002", new Object[]{managedPropertyDefinition.getName(), managedPropertyDefinition.getType()});
                }
                catch (Exception exception) {
                    throw new AdfException("ERROR", "oracle.adfmf.resource.SharedErrorBundle", "ADF-MF-10005", new Object[]{managedPropertyDefinition.getName(), exception.getMessage()});
                }
            }
            return t;
        }
        catch (AdfException adfException) {
            throw adfException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AdfException("ERROR", "oracle.adfmf.resource.SharedErrorBundle", "ADF-MF-10001", new Object[]{classNotFoundException.getMessage()});
        }
        catch (Exception exception) {
            throw new AdfException("ERROR", "oracle.adfmf.resource.SharedErrorBundle", "ADF-MF-10006", new Object[]{exception.getMessage()});
        }
    }
}

