/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.api;

import com.sun.util.logging.Level;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.el.MethodInfo;
import javax.el.MethodNotFoundException;
import javax.el.ValueExpression;
import oracle.adfmf.bindings.dbf.AmxBindingContainer;
import oracle.adfmf.bindings.dbf.AmxBindingContext;
import oracle.adfmf.bindings.dbf.ContainerContext;
import oracle.adfmf.dc.rules.ValidationContext;
import oracle.adfmf.dc.ws.rest.RestServiceAdapter;
import oracle.adfmf.dc.ws.rest.RestServiceAdapterImpl;
import oracle.adfmf.framework.CountDown;
import oracle.adfmf.framework.EmbeddedFeatureContext;
import oracle.adfmf.framework.FeatureContext;
import oracle.adfmf.framework.Scope;
import oracle.adfmf.framework.api.AdfmfJavaUtilities;
import oracle.adfmf.framework.api.JSONBeanSerializationHelper;
import oracle.adfmf.framework.contract.adf.ManagedBeanDefinition;
import oracle.adfmf.framework.contract.adf.NameValuePair;
import oracle.adfmf.framework.event.DataChangeManager;
import oracle.adfmf.framework.exception.AdfException;
import oracle.adfmf.framework.exception.ResolutionException;
import oracle.adfmf.framework.model.AdfELContext;
import oracle.adfmf.java.beans.PropertyChangeEvent;
import oracle.adfmf.json.JSONArray;
import oracle.adfmf.json.JSONObject;
import oracle.adfmf.performance.StopWatch;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.XliffResourceBundle;
import oracle.adfmf.util.logging.Trace;

public class Model {
    private static final Map primitiveClasses = new HashMap();
    private static final CountDown _deviceIsReady = new CountDown(1);
    private static final long DEVICE_READY_TIMEOUT = 60000L;

    public static Class loadClassObj(String string) throws ClassNotFoundException {
        if (primitiveClasses.containsKey(string)) {
            return (Class)primitiveClasses.get(string);
        }
        return Utility.loadClass(string);
    }

    public String ping() {
        if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
            Trace.log(Utility.FrameworkLogger, Level.FINE, Model.class, "ping", (Object)"Returning pong.");
        }
        return "pong";
    }

    public void pushPageFlowScope() {
        if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
            Trace.log(Utility.FrameworkLogger, Level.FINE, Model.class, "pushPageFlowScope", (Object)"NOOP");
        }
    }

    public void popPageFlowScope() {
        if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
            Trace.log(Utility.FrameworkLogger, Level.FINE, Model.class, "popPageFlowScope", (Object)"NOOP");
        }
    }

    public String[] getModelInventory() {
        Method[] methodArray = this.getClass().getMethods();
        String[] stringArray = new String[methodArray != null ? methodArray.length : 0];
        for (int i = 0; i < methodArray.length; ++i) {
            StringBuffer stringBuffer = new StringBuffer();
            Method method = methodArray[i];
            Class<?>[] classArray = method.getParameterTypes();
            if (!Modifier.isPublic(method.getModifiers())) continue;
            stringBuffer.append("  public ");
            stringBuffer.append(method.getReturnType().getName());
            stringBuffer.append(" ");
            stringBuffer.append(method.getName());
            stringBuffer.append("(");
            for (int j = 0; j < classArray.length; ++j) {
                if (j > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(classArray[j].getName());
            }
            stringBuffer.append(");");
            stringArray[i] = stringBuffer.toString();
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object[] processBatchRequests(Boolean bl, JSONObject[] jSONObjectArray) {
        boolean bl2 = false;
        int n = jSONObjectArray.length;
        Object[] objectArray = new Object[jSONObjectArray.length];
        if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
            Trace.log(Utility.FrameworkLogger, Level.FINE, Model.class, "processBatchRequests", (Object)("Batch request consists of " + n + " requests that " + (bl != false ? "should" : "should not") + " be treated as a single request."));
        }
        for (int i = 0; !bl2 && i < n; ++i) {
            int n2;
            Object var12_13;
            try {
                try {
                    JSONObject jSONObject = jSONObjectArray[i];
                    String string = (String)jSONObject.get("classname");
                    String string2 = (String)jSONObject.get("method");
                    JSONArray jSONArray = (JSONArray)jSONObject.get("params");
                    if (Utility.FrameworkLogger.isLoggable(Level.WARNING)) {
                        Trace.log(Utility.FrameworkLogger, Level.WARNING, class$oracle$adfmf$framework$api$Model == null ? Model.class$("oracle.adfmf.framework.api.Model") : class$oracle$adfmf$framework$api$Model, "processBatchRequests", (Object)("invoking " + string + ":" + string2 + " with " + jSONArray.length() + " parameters."));
                    }
                    objectArray[i] = Utility.invoke(string, string2, jSONArray);
                    if (objectArray[i] instanceof Throwable) {
                        throw (Throwable)objectArray[i];
                    }
                    var12_13 = null;
                }
                catch (AdfException adfException) {
                    objectArray[i] = adfException;
                    var12_13 = null;
                    if (!bl.booleanValue() || !(objectArray[i] instanceof AdfException)) continue;
                    for (n2 = i + 1; n2 < n; ++n2) {
                        objectArray[n2] = new AdfException(new IllegalStateException("batch request aborted"));
                    }
                    bl2 = true;
                    continue;
                }
                catch (Throwable throwable) {
                    objectArray[i] = new AdfException(throwable, "ERROR");
                    var12_13 = null;
                    if (!bl.booleanValue() || !(objectArray[i] instanceof AdfException)) continue;
                    for (n2 = i + 1; n2 < n; ++n2) {
                        objectArray[n2] = new AdfException(new IllegalStateException("batch request aborted"));
                    }
                    bl2 = true;
                    continue;
                }
                if (!bl.booleanValue()) continue;
            }
            catch (Throwable throwable) {
                var12_13 = null;
                if (bl.booleanValue() && objectArray[i] instanceof AdfException) {
                    for (n2 = i + 1; n2 < n; ++n2) {
                        objectArray[n2] = new AdfException(new IllegalStateException("batch request aborted"));
                    }
                    bl2 = true;
                }
                throw throwable;
            }
            if (!(objectArray[i] instanceof AdfException)) continue;
            for (n2 = i + 1; n2 < n; ++n2) {
                objectArray[n2] = new AdfException(new IllegalStateException("batch request aborted"));
            }
            bl2 = true;
        }
        return objectArray;
    }

    public void resetFeature() throws AdfException {
        if (Utility.FrameworkLogger.isLoggable(Level.WARNING)) {
            FeatureContext featureContext = AdfmfJavaUtilities.getFeatureContext();
            if (Utility.FrameworkLogger.isLoggable(Level.INFO)) {
                Trace.log(Utility.FrameworkLogger, Level.INFO, Model.class, "resetFeature", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40031", new Object[]{featureContext.getName()});
            }
        }
        this.setBeanDefinitions(new ManagedBeanDefinition[0]);
        this.setContext(null);
    }

    private static AdfException getOrCreateAdfException(Throwable throwable) {
        AdfException adfException = Utility.findAdfException(throwable);
        if (adfException == null) {
            adfException = throwable instanceof Exception ? new AdfException((Exception)throwable, "ERROR") : new AdfException(throwable, "ERROR");
        }
        return adfException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NameValuePair[] getValue(String[] stringArray) throws AdfException {
        AdfELContext adfELContext = this.getAdfELContext();
        NameValuePair[] nameValuePairArray = new NameValuePair[stringArray.length];
        double d = 0.0;
        StopWatch stopWatch = new StopWatch();
        for (int i = 0; i < stringArray.length; ++i) {
            Object object = null;
            boolean bl = false;
            try {
                ValueExpression valueExpression = adfELContext.getExpressionFactory().createValueExpression((ELContext)adfELContext, stringArray[i], class$java$lang$Object == null ? Model.class$("java.lang.Object") : class$java$lang$Object);
                if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
                    Trace.log(Utility.FrameworkLogger, Level.FINE, class$oracle$adfmf$framework$api$Model == null ? Model.class$("oracle.adfmf.framework.api.Model") : class$oracle$adfmf$framework$api$Model, "getValue", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40032", new Object[]{stringArray[i]});
                }
                AdfELContext adfELContext2 = adfELContext;
                synchronized (adfELContext2) {
                    adfELContext.setCurrentExpression(stringArray[i]);
                    object = valueExpression.getValue((ELContext)adfELContext);
                    bl = adfELContext.isCurrentExpressionVolatile();
                    adfELContext.setCurrentExpression(null);
                    ValidationContext.getInstance().addToUnsetList(stringArray[i]);
                }
                nameValuePairArray[i] = new NameValuePair();
                nameValuePairArray[i].setName(stringArray[i]);
                nameValuePairArray[i].setValue(object);
                nameValuePairArray[i].setTransient(bl);
                continue;
            }
            catch (Exception exception) {
                if (Utility.FrameworkLogger.isLoggable(Level.WARNING)) {
                    Trace.log(Utility.FrameworkLogger, Level.WARNING, class$oracle$adfmf$framework$api$Model == null ? Model.class$("oracle.adfmf.framework.api.Model") : class$oracle$adfmf$framework$api$Model, "getValue", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11026", new Object[]{stringArray[i], exception.getMessage()});
                }
                nameValuePairArray[i] = new NameValuePair();
                nameValuePairArray[i].setName(stringArray[i]);
                nameValuePairArray[i].setValue(null);
                nameValuePairArray[i].setException(Model.getOrCreateAdfException(exception));
            }
        }
        d = stopWatch.stop();
        if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
            Trace.log(Utility.PerformanceLogger, Level.FINE, Model.class, "getValue", (Object)("get variables took " + d));
        }
        return nameValuePairArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NameValuePair[] setValue(NameValuePair[] nameValuePairArray) throws AdfException {
        AdfELContext adfELContext = this.getAdfELContext();
        NameValuePair[] nameValuePairArray2 = new NameValuePair[nameValuePairArray.length];
        for (int i = 0; i < nameValuePairArray.length; ++i) {
            try {
                AdfELContext adfELContext2;
                Object object = nameValuePairArray[i].getValue();
                ValueExpression valueExpression = adfELContext.getExpressionFactory().createValueExpression((ELContext)adfELContext, nameValuePairArray[i].getName(), class$java$lang$Object == null ? Model.class$("java.lang.Object") : class$java$lang$Object);
                if (nameValuePairArray[i].isValueReference()) {
                    adfELContext2 = adfELContext.getExpressionFactory().createValueExpression((ELContext)adfELContext, (String)object, class$java$lang$Object == null ? Model.class$("java.lang.Object") : class$java$lang$Object);
                    AdfELContext adfELContext3 = adfELContext;
                    synchronized (adfELContext3) {
                        adfELContext.setCurrentExpression((String)object);
                        object = adfELContext2.getValue(adfELContext);
                    }
                }
                adfELContext2 = adfELContext;
                synchronized (adfELContext2) {
                    Object var11_10;
                    try {
                        adfELContext.setResolvingSetValue(true);
                        valueExpression.setValue((ELContext)adfELContext, object);
                        var11_10 = null;
                        adfELContext.setResolvingSetValue(false);
                    }
                    catch (Throwable throwable) {
                        var11_10 = null;
                        adfELContext.setResolvingSetValue(false);
                        throw throwable;
                    }
                }
                nameValuePairArray2[i] = new NameValuePair();
                nameValuePairArray2[i].setName(nameValuePairArray[i].getName());
                nameValuePairArray2[i].setValue(null);
                continue;
            }
            catch (Exception exception) {
                if (Utility.FrameworkLogger.isLoggable(Level.WARNING)) {
                    Trace.log(Utility.FrameworkLogger, Level.WARNING, class$oracle$adfmf$framework$api$Model == null ? Model.class$("oracle.adfmf.framework.api.Model") : class$oracle$adfmf$framework$api$Model, "setValue", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40049", new Object[]{nameValuePairArray[i].getName(), exception.getMessage()});
                }
                nameValuePairArray2[i] = new NameValuePair();
                nameValuePairArray2[i].setName(nameValuePairArray[i].getName());
                nameValuePairArray2[i].setValue(null);
                nameValuePairArray2[i].setException(Model.getOrCreateAdfException(exception));
                ValidationContext.getInstance().addToInvalidList(nameValuePairArray[i].getName(), exception);
            }
        }
        return nameValuePairArray2;
    }

    public Object evaluateMethodExpression(String string, JSONArray jSONArray, String string2, String[] stringArray) throws AdfException {
        AdfELContext adfELContext = this.getAdfELContext();
        try {
            Class clazz = Utility.isEmpty(string2) ? null : Model.loadClassObj(string2);
            Class[] classArray = new Class[stringArray.length];
            Object[] objectArray = new Object[jSONArray.length()];
            for (int i = 0; i < jSONArray.length(); ++i) {
                classArray[i] = Model.loadClassObj(stringArray[i]);
                objectArray[i] = JSONBeanSerializationHelper.fromJSON(classArray[i], jSONArray.get(i));
            }
            MethodExpression methodExpression = adfELContext.getExpressionFactory().createMethodExpression((ELContext)adfELContext, string, clazz, classArray);
            Object object = methodExpression.invoke((ELContext)adfELContext, objectArray);
            return object;
        }
        catch (MethodNotFoundException methodNotFoundException) {
            Class clazz = Object.class;
            Class[] classArray = new Class[]{};
            Object[] objectArray = new Object[]{};
            MethodExpression methodExpression = adfELContext.getExpressionFactory().createMethodExpression((ELContext)adfELContext, string, clazz, classArray);
            try {
                MethodInfo methodInfo = methodExpression.getMethodInfo((ELContext)adfELContext);
                if (methodInfo.getName().equals("execute")) {
                    Object object = methodExpression.invoke((ELContext)adfELContext, objectArray);
                    return object;
                }
            }
            catch (MethodNotFoundException methodNotFoundException2) {
            }
            catch (Exception exception) {
                throw Model.getOrCreateAdfException(exception);
            }
            throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11087", new Object[]{string});
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11088", new Object[]{Model.class.getName(), classNotFoundException.getMessage()});
        }
        catch (AdfException adfException) {
            throw adfException;
        }
        catch (Exception exception) {
            throw Model.getOrCreateAdfException(exception);
        }
    }

    public String getContextId() throws AdfException {
        try {
            AdfELContext adfELContext = this.getAdfELContext();
            String string = (String)adfELContext.evaluateVariable("bindings_contextKey");
            return string != null ? string : "";
        }
        catch (Exception exception) {
            throw Model.getOrCreateAdfException(exception);
        }
    }

    public String getContextPageDef() throws AdfException {
        try {
            AmxBindingContainer amxBindingContainer;
            AdfELContext adfELContext = this.getAdfELContext();
            ContainerContext containerContext = (ContainerContext)adfELContext.evaluateVariable("bindings_cctx");
            if (containerContext != null && (amxBindingContainer = containerContext.getContainer()) != null) {
                return amxBindingContainer.getName();
            }
            return null;
        }
        catch (Exception exception) {
            throw Model.getOrCreateAdfException(exception);
        }
    }

    public String getContextInstanceId() throws AdfException {
        try {
            AdfELContext adfELContext = this.getAdfELContext();
            ContainerContext containerContext = (ContainerContext)adfELContext.evaluateVariable("bindings_cctx");
            return containerContext.getInstanceId();
        }
        catch (Exception exception) {
            throw Model.getOrCreateAdfException(exception);
        }
    }

    public void removeContext(String string, String string2) throws AdfException {
        this.removeContextInstance(string, string2);
    }

    public void removeContextInstance(String string, String string2) throws AdfException {
        try {
            AmxBindingContext amxBindingContext;
            ValueExpression valueExpression = null;
            AdfELContext adfELContext = this.getAdfELContext();
            if (string != null) {
                valueExpression = adfELContext.getExpressionFactory().createValueExpression((ELContext)adfELContext, string, Object.class);
                string = (String)valueExpression.getValue((ELContext)adfELContext);
            }
            if (!Utility.isEmpty(string) && (amxBindingContext = (AmxBindingContext)adfELContext.evaluateVariable("data")) != null) {
                amxBindingContext.removeContainerContext(string, string2);
            }
        }
        catch (AdfException adfException) {
            throw adfException;
        }
        catch (Exception exception) {
            throw Model.getOrCreateAdfException(exception);
        }
    }

    public String[] setContext(String string) throws AdfException {
        return this.setContextInstance(string, null, true, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] setContextInstance(String string, String string2, boolean bl, boolean bl2) throws AdfException {
        StopWatch stopWatch;
        block24: {
            double d;
            String[] stringArray;
            stopWatch = new StopWatch();
            try {
                block25: {
                    try {
                        ContainerContext containerContext;
                        Object object;
                        ValueExpression valueExpression = null;
                        AdfELContext adfELContext = this.getAdfELContext();
                        if (string != null) {
                            valueExpression = adfELContext.getExpressionFactory().createValueExpression((ELContext)adfELContext, string, Object.class);
                            string = (String)valueExpression.getValue((ELContext)adfELContext);
                        }
                        if (bl && adfELContext.containsVariable("viewScope")) {
                            object = (Scope)adfELContext.evaluateVariable("viewScope");
                            ((Scope)object).clear();
                        }
                        if (string == null || string.length() == 0) {
                            if (Utility.FrameworkLogger.isLoggable(Level.INFO)) {
                                Trace.log(Utility.FrameworkLogger, Level.INFO, Model.class, "setContext", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40034");
                            }
                            if ((object = (ContainerContext)adfELContext.evaluateVariable("bindings_cctx")) != null) {
                                if (Utility.FrameworkLogger.isLoggable(Level.INFO)) {
                                    Trace.log(Utility.FrameworkLogger, Level.INFO, Model.class, "setContext", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40035");
                                }
                                this.setAdfELContext(adfELContext.getParent());
                                String[] stringArray2 = adfELContext.getVariableNames();
                                for (int i = 0; i < stringArray2.length; ++i) {
                                    PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent((Object)"Model", stringArray2[i], null, null);
                                    ((EmbeddedFeatureContext)AdfmfJavaUtilities.getFeatureContext()).getDataChangeManager().enqueue(AdfmfJavaUtilities.getActiveContextId(), propertyChangeEvent);
                                }
                            }
                            break block24;
                        }
                        if (Utility.FrameworkLogger.isLoggable(Level.INFO)) {
                            Trace.log(Utility.FrameworkLogger, Level.INFO, Model.class, "setContext", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40037", new Object[]{string});
                        }
                        if ((object = (AmxBindingContext)adfELContext.evaluateVariable("data")) == null) {
                            if (Utility.FrameworkLogger.isLoggable(Level.WARNING)) {
                                Trace.log(Utility.FrameworkLogger, Level.WARNING, Model.class, "setContext", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11042");
                            }
                            stringArray = new String[]{};
                            Object var17_19 = null;
                            break block25;
                        }
                        if (bl) {
                            ((AmxBindingContext)object).removeContainerContext(string, string2);
                        }
                        if ((containerContext = ((AmxBindingContext)object).getContainerContext(string, string2)) == null) {
                            if (!Utility.FrameworkLogger.isLoggable(Level.WARNING)) throw new ResolutionException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11029", new Object[]{string});
                            Trace.log(Utility.FrameworkLogger, Level.WARNING, Model.class, "setContext", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11029", new Object[]{string});
                            throw new ResolutionException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11029", new Object[]{string});
                        }
                        if (Utility.FrameworkLogger.isLoggable(Level.INFO)) {
                            Trace.log(Utility.FrameworkLogger, Level.INFO, Model.class, "setContext", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40038", new Object[]{string});
                        }
                        this.setAdfELContext(containerContext.getElContext());
                        if (containerContext.getContainer() != null) {
                            int n = bl ? 0 : 1;
                            containerContext.getContainer().processExecutables(n);
                            if (bl2) {
                                this.addBindingDefsToDataChangeEvent(((EmbeddedFeatureContext)AdfmfJavaUtilities.getFeatureContext()).getDataChangeManager(), containerContext.getContainer());
                            }
                        }
                        EmbeddedFeatureContext embeddedFeatureContext = EmbeddedFeatureContext.getInstance();
                        Map map = embeddedFeatureContext.getBeanDefinitionRegistry();
                        Iterator iterator = map.values().iterator();
                        while (iterator.hasNext()) {
                            List list = (List)iterator.next();
                            Iterator iterator2 = list.iterator();
                            while (iterator2.hasNext()) {
                                ManagedBeanDefinition managedBeanDefinition = (ManagedBeanDefinition)iterator2.next();
                                if (Utility.isEmpty(managedBeanDefinition.getScope()) || !"viewScope".startsWith(managedBeanDefinition.getScope())) continue;
                                this.addManagedBeanChangeEvent("viewScope", managedBeanDefinition.getBeanName());
                            }
                        }
                        break block24;
                    }
                    catch (AdfException adfException) {
                        throw adfException;
                    }
                    catch (Exception exception) {
                        throw Model.getOrCreateAdfException(exception);
                    }
                }
                d = stopWatch.stop();
            }
            catch (Throwable throwable) {
                Object var17_21 = null;
                double d2 = stopWatch.stop();
                if (!Utility.FrameworkLogger.isLoggable(Level.FINE)) throw throwable;
                Trace.log(Utility.PerformanceLogger, Level.FINE, Model.class, "setContextInstance", (Object)("setContextInstance took " + d2 + " ms."));
                throw throwable;
            }
            if (!Utility.FrameworkLogger.isLoggable(Level.FINE)) return stringArray;
            Trace.log(Utility.PerformanceLogger, Level.FINE, Model.class, "setContextInstance", (Object)("setContextInstance took " + d + " ms."));
            return stringArray;
        }
        Object var17_20 = null;
        double d = stopWatch.stop();
        if (!Utility.FrameworkLogger.isLoggable(Level.FINE)) return new String[0];
        Trace.log(Utility.PerformanceLogger, Level.FINE, Model.class, "setContextInstance", (Object)("setContextInstance took " + d + " ms."));
        return new String[0];
    }

    private void addBindingDefsToDataChangeEvent(DataChangeManager dataChangeManager, AmxBindingContainer amxBindingContainer) {
        Object object;
        Map map = amxBindingContainer.getTreeDefinitions("bindings");
        HashMap hashMap = new HashMap();
        Object object2 = map.entrySet().iterator();
        while (object2.hasNext()) {
            object = object2.next();
            hashMap.put(object.getKey(), object.getValue());
        }
        object2 = amxBindingContainer.getAttrBindingIds();
        object = object2.iterator();
        while (object.hasNext()) {
            HashMap<String, Boolean> hashMap2 = new HashMap<String, Boolean>();
            hashMap2.put(".null", new Boolean(true));
            hashMap.put(object.next(), hashMap2);
        }
        dataChangeManager.enqueue(AdfmfJavaUtilities.getActiveContextId(), new PropertyChangeEvent((Object)"Model", "bindings", null, hashMap));
    }

    public void setBeanDefinitions(ManagedBeanDefinition[] managedBeanDefinitionArray) throws AdfException {
        Map map = ((EmbeddedFeatureContext)AdfmfJavaUtilities.getFeatureContext()).getBeanDefinitionRegistry();
        if (Utility.FrameworkLogger.isLoggable(Level.INFO)) {
            Trace.log(Utility.FrameworkLogger, Level.INFO, Model.class, "setBeanDefinitions", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40036", new Object[]{map.keySet().toString()});
        }
        map.clear();
        AdfELContext adfELContext = AdfmfJavaUtilities.getAdfELContext();
        for (int i = 0; i < managedBeanDefinitionArray.length; ++i) {
            Scope scope;
            ManagedBeanDefinition managedBeanDefinition = managedBeanDefinitionArray[i];
            if (managedBeanDefinition == null || Utility.isEmpty(managedBeanDefinition.getBeanName()) || Utility.isEmpty(managedBeanDefinition.getFqnClassname())) continue;
            try {
                Utility.loadClass(managedBeanDefinition.getFqnClassname());
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!Utility.FrameworkLogger.isLoggable(Level.SEVERE)) continue;
                Trace.log(Utility.FrameworkLogger, Level.SEVERE, class$oracle$adfmf$framework$api$Model == null ? Model.class$("oracle.adfmf.framework.api.Model") : class$oracle$adfmf$framework$api$Model, "setBeanDefinitions", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11070", new Object[]{managedBeanDefinition.getFqnClassname(), managedBeanDefinition.getBeanName(), managedBeanDefinition.getFqnClassname(), managedBeanDefinition.getScope()});
                continue;
            }
            List<ManagedBeanDefinition> list = null;
            if (map.containsKey(managedBeanDefinition.getBeanName())) {
                list = (List)map.get(managedBeanDefinition.getBeanName());
            } else {
                list = new ArrayList();
                map.put(managedBeanDefinition.getBeanName(), list);
            }
            list.add(managedBeanDefinition);
            if (Utility.FrameworkLogger.isLoggable(Level.INFO)) {
                Trace.log(Utility.FrameworkLogger, Level.INFO, class$oracle$adfmf$framework$api$Model == null ? Model.class$("oracle.adfmf.framework.api.Model") : class$oracle$adfmf$framework$api$Model, "setBeanDefinitions", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40027", new Object[]{managedBeanDefinition.getBeanName(), managedBeanDefinition.getFqnClassname(), managedBeanDefinition.getScope()});
            }
            if (Utility.isEmpty(managedBeanDefinition.getScope()) || (scope = (Scope)adfELContext.evaluateVariable(managedBeanDefinition.getScope() + "Scope")) == null || scope.containsKey(managedBeanDefinition.getBeanName())) continue;
            this.addManagedBeanChangeEvent(managedBeanDefinition.getScope(), managedBeanDefinition.getBeanName());
        }
    }

    private void setManagedBean(String string, String string2, String string3) throws AdfException {
        try {
            AdfELContext adfELContext = this.getAdfELContext();
            if (string3 == null || string3.length() == 0) {
                Object object = adfELContext.evaluateVariable(string);
                if (object == null) {
                    Class clazz = Model.loadClassObj(string2);
                    Object t = clazz.newInstance();
                    adfELContext.setVariable(string, t, clazz);
                }
            } else {
                Map map = (Map)adfELContext.evaluateVariable(string3);
                Object v = map.get(string);
                if (v == null) {
                    Class clazz = Model.loadClassObj(string2);
                    Object t = clazz.newInstance();
                    map.put(string, t);
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11088", new Object[]{Model.class.getName(), classNotFoundException.getMessage()});
        }
        catch (InstantiationException instantiationException) {
            throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11088", new Object[]{Model.class.getName(), instantiationException.toString()});
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11088", new Object[]{Model.class.getName(), illegalAccessException.toString()});
        }
    }

    public void loadBundle(String string, String string2) throws AdfException {
        try {
            XliffResourceBundle xliffResourceBundle = XliffResourceBundle.getXliffResourceBundle(string);
            if (xliffResourceBundle == null) {
                throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11134", new Object[]{string});
            }
            EmbeddedFeatureContext embeddedFeatureContext = EmbeddedFeatureContext.getInstance();
            AdfELContext adfELContext = embeddedFeatureContext.getAdfELContext();
            adfELContext.setVariable(string2, xliffResourceBundle, XliffResourceBundle.class);
        }
        catch (Exception exception) {
            throw Model.getOrCreateAdfException(exception);
        }
    }

    public static RestServiceAdapter createRestServiceAdapter() {
        RestServiceAdapterImpl restServiceAdapterImpl = new RestServiceAdapterImpl("", "", "");
        return restServiceAdapterImpl;
    }

    public static void deviceIsReady() {
        _deviceIsReady.release();
    }

    public static void waitForDeviceReady() {
        boolean bl = false;
        try {
            bl = _deviceIsReady.attempt(60000L);
        }
        catch (InterruptedException interruptedException) {
            Trace.log(Utility.FrameworkLogger, Level.SEVERE, Model.class, "waitForDeviceReady", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11147");
            bl = false;
        }
        if (!bl) {
            throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11146", null);
        }
    }

    private void addManagedBeanChangeEvent(String string, String string2) {
        if (!Utility.isEmpty(string2) && !Utility.isEmpty(string)) {
            DataChangeManager dataChangeManager = ((EmbeddedFeatureContext)AdfmfJavaUtilities.getFeatureContext()).getDataChangeManager();
            String string3 = string.endsWith("Scope") ? string : string + "Scope";
            String string4 = string3 + "." + string2;
            dataChangeManager.enqueue(AdfmfJavaUtilities.getActiveContextId(), new PropertyChangeEvent((Object)this, string4, null, null));
        }
    }

    private final AdfELContext getAdfELContext() {
        return ((EmbeddedFeatureContext)AdfmfJavaUtilities.getFeatureContext()).getAdfELContext();
    }

    private final void setAdfELContext(AdfELContext adfELContext) {
        ((EmbeddedFeatureContext)AdfmfJavaUtilities.getFeatureContext()).setAdfELContext(adfELContext);
    }

    private String[] toStringArray(Iterator iterator, int n) {
        return this.toStringArray(iterator, n, "");
    }

    private String[] toStringArray(Iterator iterator, int n, String string) {
        String[] stringArray = new String[n];
        int n2 = 0;
        while (iterator.hasNext()) {
            stringArray[n2++] = string + (String)iterator.next();
        }
        return stringArray;
    }

    private NameValuePair[] toNvpArray(Iterator iterator, int n) {
        NameValuePair[] nameValuePairArray = new NameValuePair[n];
        int n2 = 0;
        while (iterator.hasNext()) {
            nameValuePairArray[n2++] = (NameValuePair)iterator.next();
        }
        return nameValuePairArray;
    }

    static {
        primitiveClasses.put("boolean", Boolean.TYPE);
        primitiveClasses.put("byte", Byte.TYPE);
        primitiveClasses.put("short", Short.TYPE);
        primitiveClasses.put("char", Character.TYPE);
        primitiveClasses.put("int", Integer.TYPE);
        primitiveClasses.put("long", Long.TYPE);
        primitiveClasses.put("float", Float.TYPE);
        primitiveClasses.put("double", Double.TYPE);
        primitiveClasses.put("void", Void.TYPE);
    }
}

