/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.api;

import [Ljava.lang.Object;;
import com.sun.util.logging.Level;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import oracle.adfmf.framework.api.JSONDeserializable;
import oracle.adfmf.framework.api.JSONSerializable;
import oracle.adfmf.framework.api.PostJSONDeserializable;
import oracle.adfmf.framework.api.PostJSONSerializable;
import oracle.adfmf.framework.api.TransitiveObject;
import oracle.adfmf.framework.exception.AdfException;
import oracle.adfmf.json.JSONArray;
import oracle.adfmf.json.JSONException;
import oracle.adfmf.json.JSONObject;
import oracle.adfmf.misc.Converter;
import oracle.adfmf.misc.ISO8601DateTimeUtil;
import oracle.adfmf.util.GenericType;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.logging.Trace;

public class JSONBeanSerializationHelper {
    private ArrayList objectsToBeConverted = null;

    public static Object fromJSON(Class clazz, String string) throws Exception {
        JSONObject jSONObject = null;
        if (string != null) {
            jSONObject = new JSONObject(string);
        }
        return JSONBeanSerializationHelper.fromJSON(clazz, jSONObject);
    }

    public static Object fromJSON(Class clazz, Object object) throws Exception {
        Object object2;
        if (clazz == JSONArray.class || clazz == JSONObject.class || object == null) {
            return object;
        }
        if (JSONObject.NULL.equals(object)) {
            return null;
        }
        if (object instanceof JSONObject && ((JSONObject)object).has(".null") && Boolean.valueOf((String)(object2 = ((JSONObject)object).getString(".null"))).booleanValue()) {
            return null;
        }
        if (clazz == Object.class) {
            if (object instanceof JSONObject) {
                if (((JSONObject)object).has(".type")) {
                    object2 = ((JSONObject)object).getString(".type");
                    if (object2 != null) {
                        clazz = Utility.loadClass((String)object2);
                    }
                } else if (Utility.FrameworkLogger.isLoggable(Level.WARNING)) {
                    Trace.log(Utility.FrameworkLogger, Level.WARNING, JSONBeanSerializationHelper.class, "fromJSON", "oracle.adfmf.resource.SharedInfoBundle", "ADF-MF-40001", new Object[]{object.toString()});
                }
            } else {
                if (object instanceof JSONArray) {
                    return JSONBeanSerializationHelper.fromJSON(Object;.class, object);
                }
                if (object instanceof Vector) {
                    return JSONBeanSerializationHelper.fromJSON(Vector.class, object);
                }
                if (object != null && (Utility.isStandardType(object.getClass()) || ISO8601DateTimeUtil.isDateType(object.getClass()))) {
                    return JSONBeanSerializationHelper.resolveFromJSON(object.getClass(), object);
                }
                if (Utility.FrameworkLogger.isLoggable(Level.WARNING)) {
                    Trace.log(Utility.FrameworkLogger, Level.WARNING, JSONBeanSerializationHelper.class, "fromJSON", "oracle.adfmf.resource.SharedInfoBundle", "ADF-MF-40001", new Object[]{object != null ? object.toString() : "null"});
                }
            }
        }
        if (clazz.isArray()) {
            if (object instanceof JSONObject) {
                boolean bl;
                if (((JSONObject)object).has(".null") && (bl = ((JSONObject)object).getBoolean(".null"))) {
                    return null;
                }
                return null;
            }
            object2 = (JSONArray)object;
            int n = object == null ? 0 : ((JSONArray)object2).length();
            Object object3 = Array.newInstance(clazz.getComponentType(), n);
            for (int i = 0; i < n; ++i) {
                Object object4 = ((JSONArray)object2).get(i);
                Array.set(object3, i, JSONBeanSerializationHelper.fromJSON(clazz.getComponentType(), object4));
            }
            return object3;
        }
        if (Utility.isStandardType(clazz) || ISO8601DateTimeUtil.isDateType((Class)clazz)) {
            return JSONBeanSerializationHelper.resolveFromJSON(clazz, object);
        }
        object2 = clazz.newInstance();
        if (object2 instanceof JSONDeserializable) {
            return ((JSONDeserializable)object2).fromJSON(object);
        }
        if (object2 instanceof Map) {
            JSONObject jSONObject = (JSONObject)object;
            Map map = (Map)object2;
            if (jSONObject != null) {
                Iterator iterator = jSONObject.keys();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    Object object5 = jSONObject.get(string);
                    Class<Object> clazz2 = null;
                    if (object5 == null) continue;
                    if (object5 instanceof JSONObject) {
                        clazz2 = object5.getClass();
                        try {
                            String string2 = ((JSONObject)object5).getString(".type");
                            clazz2 = Utility.loadClass(string2);
                        }
                        catch (JSONException jSONException) {
                            // empty catch block
                        }
                    }
                    if (clazz2 == null && Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                        Trace.log(Utility.FrameworkLogger, Level.FINEST, class$oracle$adfmf$framework$api$JSONBeanSerializationHelper == null ? JSONBeanSerializationHelper.class$("oracle.adfmf.framework.api.JSONBeanSerializationHelper") : class$oracle$adfmf$framework$api$JSONBeanSerializationHelper, "fromJSON", (Object)" ");
                    }
                    map.put(string, JSONBeanSerializationHelper.fromJSON(clazz2 == null ? object5.getClass() : clazz2, object5));
                }
            }
            return map;
        }
        if (object2 instanceof List) {
            JSONArray jSONArray;
            List list = (List)object2;
            Object object6 = null;
            Object object7 = null;
            if (object instanceof Vector) {
                Vector vector = (Vector)object;
                if (null != vector) {
                    for (int i = 0; i < vector.size(); ++i) {
                        object6 = vector.get(i);
                        object7 = JSONBeanSerializationHelper.fromJSON(class$java$lang$Object == null ? JSONBeanSerializationHelper.class$("java.lang.Object") : class$java$lang$Object, object6);
                        list.add(object7);
                    }
                }
            } else if (object instanceof JSONArray && null != (jSONArray = (JSONArray)object)) {
                for (int i = 0; i < jSONArray.length(); ++i) {
                    object6 = jSONArray.get(i);
                    object7 = JSONBeanSerializationHelper.fromJSON(class$java$lang$Object == null ? JSONBeanSerializationHelper.class$("java.lang.Object") : class$java$lang$Object, object6);
                    list.add(object7);
                }
            }
            return list;
        }
        if (object instanceof JSONArray) {
            throw new IllegalArgumentException();
        }
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            try {
                String string;
                Method method = methodArray[i];
                if (!Modifier.isPublic(method.getModifiers()) || Utility.isEmpty(string = Utility.getSetterVariable(method))) continue;
                try {
                    Class<?> clazz3 = method.getParameterTypes()[0];
                    Object[] objectArray = new Object[1];
                    Object object8 = Utility.getCaseInsenstiveVariableValueFromJSON((JSONObject)object, string);
                    objectArray[0] = JSONBeanSerializationHelper.fromJSON(clazz3, object8);
                    if (ISO8601DateTimeUtil.isDateType(clazz3)) {
                        try {
                            if (objectArray[0] instanceof String) {
                                objectArray[0] = ISO8601DateTimeUtil.coerceToDate(clazz3, (String)((String)objectArray[0]));
                            } else if (objectArray[0] instanceof Long) {
                                objectArray[0] = new Date(JSONBeanSerializationHelper.getLong((Long)objectArray[0]));
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    method.invoke(object2, objectArray);
                }
                catch (JSONException jSONException) {}
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (object2 instanceof PostJSONDeserializable) {
            object2 = ((PostJSONDeserializable)object2).modifyObject((JSONObject)object);
        }
        return object2;
    }

    public static Object toJSON(Object object) throws Exception {
        Object object2 = null;
        if (object instanceof JSONObject && JSONBeanSerializationHelper.isObjectNull(object)) {
            if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
                String string = "Not serializing null object and just returning null as JS and Objective-C layers are not ready to handle all serialized null cases (Refer Bug 16472347, 16472356)";
                Trace.log(Utility.FrameworkLogger, Level.FINE, JSONBeanSerializationHelper.class, "toJSON", (Object)string);
            }
            return null;
        }
        if (object instanceof JSONObject || object instanceof JSONArray) {
            return object;
        }
        JSONBeanSerializationHelper jSONBeanSerializationHelper = new JSONBeanSerializationHelper();
        if (null == jSONBeanSerializationHelper.objectsToBeConverted) {
            jSONBeanSerializationHelper.objectsToBeConverted = new ArrayList();
        }
        object2 = jSONBeanSerializationHelper.toJSONActual(object, "root", jSONBeanSerializationHelper.objectsToBeConverted);
        if (null != jSONBeanSerializationHelper.objectsToBeConverted) {
            if (Utility.FrameworkLogger.isLoggable(Level.FINE) && !jSONBeanSerializationHelper.objectsToBeConverted.isEmpty()) {
                String string = "ArrayList used for Cycle detection wasn't empty after processing, thus there is some error!";
                Trace.log(Utility.FrameworkLogger, Level.FINE, JSONBeanSerializationHelper.class, "toJSON", (Object)string);
            }
            jSONBeanSerializationHelper.objectsToBeConverted.clear();
            jSONBeanSerializationHelper.objectsToBeConverted = null;
        }
        return object2;
    }

    public static JSONObject getNullJSONObj() throws Exception {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put(".null", true);
        return jSONObject;
    }

    private Object toJSONActual(Object object, String string, ArrayList arrayList) throws Exception {
        if (object == null) {
            return JSONBeanSerializationHelper.getNullJSONObj();
        }
        if (arrayList.contains(object) || !arrayList.add(object)) {
            String string2 = Utility.getResourceString("oracle.adfmf.resource.SharedErrorBundle", "ADF-MF-10015", new Object[]{object.getClass().getName(), string});
            Throwable throwable = new Throwable(string2);
            Utility.printCurrentStackTrace(throwable);
            throw new AdfException(new IllegalStateException(string2));
        }
        if (object instanceof JSONSerializable) {
            arrayList.remove(object);
            return ((JSONSerializable)object).toJSON();
        }
        Class<?> clazz = object.getClass();
        if (Utility.isStandardType(clazz)) {
            arrayList.remove(object);
            return JSONBeanSerializationHelper.resolveToJSON(clazz, object);
        }
        if (ISO8601DateTimeUtil.isDateType(clazz)) {
            arrayList.remove(object);
            return JSONBeanSerializationHelper.dateToJSON(clazz, object);
        }
        if (object instanceof Map) {
            Set set;
            Map map = (Map)object;
            JSONObject jSONObject = new JSONObject();
            if (map != null && !map.isEmpty() && null != (set = map.entrySet())) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Class<?> clazz2;
                    Map.Entry entry = iterator.next();
                    String string3 = "" + entry.getKey();
                    Object v = entry.getValue();
                    Object object2 = null;
                    object2 = v != null ? (Utility.isStandardType(clazz2 = v.getClass()) ? JSONBeanSerializationHelper.resolveToJSON(clazz2, v) : this.toJSONActual(v, "map entry - " + string3, arrayList)) : JSONBeanSerializationHelper.getNullJSONObj();
                    jSONObject.put(string3, object2);
                }
            }
            arrayList.remove(object);
            return jSONObject;
        }
        if (object.getClass().isArray()) {
            int n = object == null ? 0 : Array.getLength(object);
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < n; ++i) {
                Class<?> clazz3;
                Object object3 = Array.get(object, i);
                Object object4 = null;
                object4 = object3 != null ? (Utility.isStandardType(clazz3 = object3.getClass()) ? JSONBeanSerializationHelper.resolveToJSON(clazz3, object3) : this.toJSONActual(object3, "array entry - " + i, arrayList)) : JSONBeanSerializationHelper.getNullJSONObj();
                jSONArray.put(object4);
            }
            arrayList.remove(object);
            return jSONArray;
        }
        if (object instanceof List) {
            List list = (List)object;
            int n = list.size();
            Vector<JSONObject> vector = new Vector<JSONObject>();
            for (int i = 0; i < n; ++i) {
                Class<?> clazz4;
                Object e = list.get(i);
                Object object5 = null;
                object5 = e != null ? (Utility.isStandardType(clazz4 = e.getClass()) ? JSONBeanSerializationHelper.resolveToJSON(clazz4, e) : this.toJSONActual(e, "list entry - " + i, arrayList)) : JSONBeanSerializationHelper.getNullJSONObj();
                vector.add((JSONObject)object5);
            }
            arrayList.remove(object);
            return vector;
        }
        if (object instanceof GenericType) {
            int n;
            GenericType genericType = (GenericType)object;
            JSONObject jSONObject = new JSONObject();
            int n2 = genericType.getAttributeCount();
            int n3 = n2 < (n = genericType.getAttributeInfoCount()) ? n2 : n;
            for (int i = 0; i < n3; ++i) {
                Object object6 = genericType.getAttribute(i, "JSON");
                if (object6 instanceof GenericType) {
                    object6 = this.toJSONActual(object6, "generic type attribute " + i, arrayList);
                } else if (object6 != null) {
                    Class<?> clazz5 = object6.getClass();
                    if (Utility.isStandardType(clazz5)) {
                        object6 = JSONBeanSerializationHelper.resolveToJSON(clazz5, object6);
                    } else if (ISO8601DateTimeUtil.isDateType(clazz5)) {
                        object6 = JSONBeanSerializationHelper.dateToJSON(clazz5, object6);
                    }
                } else {
                    object6 = JSONBeanSerializationHelper.getNullJSONObj();
                }
                jSONObject.put(genericType.getAttributeInfo((int)i).name, object6);
            }
            jSONObject.put(".type", genericType.getType());
            arrayList.remove(object);
            return jSONObject;
        }
        JSONObject jSONObject = new JSONObject();
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            String string4;
            Method method = methodArray[i];
            if (!Modifier.isPublic(method.getModifiers()) || (string4 = Utility.getGetterVariable(method)) == null || string4.length() <= 0 || Utility.isVariableTransient(clazz, string4)) continue;
            Object object7 = null;
            Object object8 = null;
            try {
                object8 = method.invoke(object, (Object[])null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            object7 = object8 instanceof JSONObject ? object8 : this.toJSONActual(object8, "object getter method - " + string4, arrayList);
            jSONObject.put(string4, object7);
        }
        if (object instanceof JSONObject && (((JSONObject)object).has(".transient") || object instanceof TransitiveObject)) {
            jSONObject.put(".transient", true);
        }
        jSONObject.put(".type", clazz.getName());
        if (object instanceof PostJSONSerializable) {
            jSONObject = ((PostJSONSerializable)object).modifyJSON(jSONObject);
        }
        arrayList.remove(object);
        return jSONObject;
    }

    protected static Object dateToJSON(Class clazz, Object object) throws Exception {
        Date date = (Date)object;
        return ISO8601DateTimeUtil.format((Date)date);
    }

    protected static Object resolve(Class clazz, Object object) throws Exception {
        if (clazz == null) {
            return object;
        }
        Object object2 = null;
        if (clazz.isPrimitive() || object instanceof String) {
            if (clazz == String.class) {
                return object;
            }
            String string = clazz.getName();
            object2 = string.endsWith("oolean") ? new Boolean(JSONBeanSerializationHelper.getBoolean(object)) : (string.endsWith("yte") ? new Byte(JSONBeanSerializationHelper.getByte(object)) : (string.endsWith("ouble") ? new Double(JSONBeanSerializationHelper.getDouble(object)) : (string.endsWith("loat") ? new Float(JSONBeanSerializationHelper.getFloat(object)) : (clazz == Integer.TYPE || clazz == Integer.class ? new Integer(JSONBeanSerializationHelper.getInteger(object)) : (string.endsWith("ong") ? new Long(JSONBeanSerializationHelper.getLong(object)) : (string.endsWith("hort") ? new Short(JSONBeanSerializationHelper.getShort(object)) : (clazz == Character.TYPE || clazz == Character.class ? new Character(JSONBeanSerializationHelper.getCharacter(object)) : object)))))));
        } else {
            object2 = object;
        }
        return object2;
    }

    protected static Object resolveToJSON(Class clazz, Object object) throws Exception {
        if (clazz == BigInteger.class) {
            long l = JSONBeanSerializationHelper.getLong(object);
            if (l > Long.MAX_VALUE || l < Long.MIN_VALUE) {
                throw new IllegalArgumentException(Utility.getResourceString("oracle.adfmf.resource.SharedErrorBundle", "ADF-MF-10017"));
            }
            return new Long(l);
        }
        if (clazz == BigDecimal.class) {
            double d = JSONBeanSerializationHelper.getDouble(object);
            if (d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
                throw new IllegalArgumentException(Utility.getResourceString("oracle.adfmf.resource.SharedErrorBundle", "ADF-MF-10018"));
            }
            if (d == Double.NaN) {
                throw new IllegalArgumentException(Utility.getResourceString("oracle.adfmf.resource.SharedErrorBundle", "ADF-MF-10019"));
            }
            return new Double(d);
        }
        return JSONBeanSerializationHelper.resolve(clazz, object);
    }

    protected static Object resolveFromJSON(Class clazz, Object object) throws Exception {
        if (clazz == BigInteger.class) {
            return new Long(JSONBeanSerializationHelper.getLong(object));
        }
        if (clazz == BigDecimal.class) {
            return new BigDecimal(JSONBeanSerializationHelper.getDouble(object));
        }
        return JSONBeanSerializationHelper.resolve(clazz, object);
    }

    public static boolean isObjectNull(Object object) {
        boolean bl = false;
        if (null == object || JSONObject.NULL.equals(object)) {
            bl = true;
        } else if (object instanceof JSONObject && ((JSONObject)object).has(".null")) {
            try {
                boolean bl2 = JSONBeanSerializationHelper.getBoolean(((JSONObject)object).get(".null"));
                if (bl2) {
                    bl = true;
                }
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return bl;
    }

    public static void removeNullsFromJSON(JSONObject jSONObject, String[] stringArray) {
        if (null != jSONObject) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string = stringArray[i];
                try {
                    if (!JSONBeanSerializationHelper.isObjectNull(jSONObject.get(string))) continue;
                    jSONObject.remove(string);
                    continue;
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
            }
        }
    }

    public static void removeNegativesFromJSON(JSONObject jSONObject, String[] stringArray) {
        if (null != jSONObject) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string = stringArray[i];
                try {
                    if (-1 != JSONBeanSerializationHelper.getInteger(jSONObject.get(string))) continue;
                    jSONObject.remove(string);
                    continue;
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
            }
        }
    }

    public static void removeBooleanFromJSON(JSONObject jSONObject, boolean bl, String[] stringArray) {
        if (null != jSONObject) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string = stringArray[i];
                try {
                    if (bl != JSONBeanSerializationHelper.getBoolean(jSONObject.get(string))) continue;
                    jSONObject.remove(string);
                    continue;
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public static int getIdFromJSONObject(JSONObject jSONObject) throws JSONException {
        int n = -1;
        if (null != jSONObject) {
            n = JSONBeanSerializationHelper.getInteger(jSONObject.get("id"));
        }
        return n;
    }

    public static boolean getBoolean(Object object) throws Exception {
        return object instanceof Boolean ? ((Boolean)object).booleanValue() : Boolean.valueOf((String)object).booleanValue();
    }

    public static byte getByte(Object object) {
        return object instanceof Number ? ((Number)object).byteValue() : Byte.parseByte((String)object);
    }

    public static char getCharacter(Object object) {
        return ((Character)Converter.coerceToType((Object)object, (Class)Character.class)).charValue();
    }

    public static double getDouble(Object object) {
        return object instanceof Number ? ((Number)object).doubleValue() : Double.parseDouble((String)object);
    }

    public static float getFloat(Object object) {
        return object instanceof Number ? ((Number)object).floatValue() : Float.parseFloat((String)object);
    }

    public static int getInteger(Object object) {
        return object instanceof Number ? ((Number)object).intValue() : Integer.parseInt((String)object);
    }

    public static long getLong(Object object) {
        long l = 0L;
        l = object instanceof Number ? ((Number)object).longValue() : (object instanceof Date ? ((Date)object).getTime() : Long.parseLong((String)object));
        return l;
    }

    public static short getShort(Object object) {
        return object instanceof Number ? ((Number)object).shortValue() : Short.parseShort((String)object);
    }

    public static String getString(Object object) {
        return (String)object;
    }
}

