/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.api;

import java.lang.reflect.Constructor;
import java.text.ParseException;
import java.util.Date;
import oracle.adfmf.misc.ISO8601DateTimeUtil;
import oracle.adfmf.util.DateParser;

public class DateUtility {
    private DateUtility() {
    }

    public static boolean isDateType(Class clazz) {
        return ISO8601DateTimeUtil.isDateType((Class)clazz);
    }

    public static Date convert(String string, Class clazz) {
        Date date = DateUtility._getISO8601Date(string);
        if (date == null) {
            date = DateUtility._getJavaDate(string);
        }
        if (date == null) {
            return null;
        }
        return DateUtility._coerce(date, clazz);
    }

    private static Date _getISO8601Date(String string) {
        try {
            return ISO8601DateTimeUtil.parse((String)string);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    private static Date _getJavaDate(String string) {
        return DateParser.parseDate(string);
    }

    private static Date _coerce(Date date, Class clazz) {
        if (Date.class.equals(clazz)) {
            return date;
        }
        try {
            Constructor constructor = clazz.getConstructor(Long.TYPE);
            return (Date)constructor.newInstance(new Long(date.getTime()));
        }
        catch (Exception exception) {
            return date;
        }
    }
}

