/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework;

import [Ljava.lang.String;;
import com.sun.util.logging.Level;
import java.lang.reflect.Constructor;
import oracle.adfmf.framework.FeatureContextManager;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.logging.Trace;

public class FeatureContextManagerFactory {
    protected static FeatureContextManager sFeatureContextManager = null;

    private static FeatureContextManager createFeatureContextManager(String[] stringArray) {
        String string;
        switch (Utility.getChannelSide()) {
            case 1: {
                string = "oracle.adfmf.framework.NativeFeatureContextManager";
                break;
            }
            case 0: {
                string = "oracle.adfmf.framework.EmbeddedFeatureContextManager";
                break;
            }
            default: {
                string = null;
            }
        }
        if (!Utility.isEmpty(string)) {
            try {
                Constructor<?> constructor = Class.forName(string).getDeclaredConstructor(String;.class);
                return (FeatureContextManager)constructor.newInstance(new Object[]{stringArray});
            }
            catch (Exception exception) {
                if (Utility.FrameworkLogger.isLoggable(Level.WARNING)) {
                    Trace.log(Utility.FrameworkLogger, Level.WARNING, FeatureContextManagerFactory.class, "createFeatureContextManager", "oracle.adfmf.resource.SharedInfoBundle", "ADF-MF-40012", new Object[]{exception.toString()});
                }
                exception.printStackTrace();
            }
        }
        return null;
    }

    public static synchronized FeatureContextManager getInstance(String[] stringArray) {
        if (sFeatureContextManager == null) {
            if (stringArray == null) {
                return null;
            }
            sFeatureContextManager = FeatureContextManagerFactory.createFeatureContextManager(stringArray);
        }
        return sFeatureContextManager;
    }

    public static FeatureContextManager getInstance() {
        return FeatureContextManagerFactory.getInstance(null);
    }
}

