/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework;

import com.oracle.cvm.channel.VMMessageHandler;
import com.sun.util.logging.Level;
import oracle.adfmf.framework.AdfChannel;
import oracle.adfmf.framework.AdfControlChannel;
import oracle.adfmf.framework.FeatureContextAccessor;
import oracle.adfmf.framework.FeatureContextManager;
import oracle.adfmf.framework.contract.adf.AdfMessageHandlerFactory;
import oracle.adfmf.framework.exception.AdfException;
import oracle.adfmf.framework.message.ApplicationRequestHandler;
import oracle.adfmf.framework.message.adf.AdfApplicationRequest;
import oracle.adfmf.framework.message.adf.AdfRequestHandler;
import oracle.adfmf.framework.message.adf.AdfResponse;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.logging.Trace;

public class FeatureContext
implements ApplicationRequestHandler {
    public static final String NATIVE_FC_TYPE = "oracle.adfmf.framework.NativeFeatureContext";
    public static final String EMBEDDED_FC_TYPE = "oracle.adfmf.framework.EmbeddedFeatureContext";
    protected static ThreadLocal threadLocalFCA = new InheritableThreadLocal();
    private static ThreadLocal threadLocalPrimaryThread = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new Boolean(false);
        }
    };
    protected static final String DATABINDING_REGISTRY_FILE = "META-INF/adfm.xml";
    protected boolean initialized = false;
    protected int id = -1;
    protected String name = null;
    protected AdfChannel channel = null;
    protected FeatureContextManager fcm = null;

    FeatureContext() {
    }

    FeatureContext(FeatureContextManager featureContextManager, Integer n, String string) {
        int n2;
        this.id = n2 = n.intValue();
        this.name = string;
        this.fcm = featureContextManager;
    }

    protected void createChannel() {
        this.channel = this.id == 0 ? new AdfControlChannel(this.id, this.fcm, this) : new AdfChannel(this.id, this.fcm, this);
    }

    public AdfResponse handle(AdfApplicationRequest adfApplicationRequest) {
        AdfResponse adfResponse = null;
        if (Utility.FrameworkLogger.isLoggable(Level.INFO)) {
            Trace.log(Utility.FrameworkLogger, Level.INFO, FeatureContext.class, "handle", "oracle.adfmf.resource.SharedInfoBundle", "ADF-MF-40007");
        }
        if (!this.initialized) {
            if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                Trace.log(Utility.FrameworkLogger, Level.FINEST, FeatureContext.class, "handle", "oracle.adfmf.resource.SharedInfoBundle", "ADF-MF-40008", new Object[]{this.name});
            }
            this.performLazyInitialization();
            if (Utility.FrameworkLogger.isLoggable(Level.INFO)) {
                Trace.log(Utility.FrameworkLogger, Level.INFO, FeatureContext.class, "handle", "oracle.adfmf.resource.SharedInfoBundle", "ADF-MF-40009", new Object[]{this.name});
            }
            this.initialized = true;
        }
        try {
            AdfRequestHandler adfRequestHandler = AdfMessageHandlerFactory.getAdfRequestHandler(adfApplicationRequest, this.getClass());
            if (Utility.FrameworkLogger.isLoggable(Level.INFO)) {
                Trace.log(Utility.FrameworkLogger, Level.INFO, FeatureContext.class, "handle", "oracle.adfmf.resource.SharedInfoBundle", "ADF-MF-40010", new Object[]{adfRequestHandler.getClass().getName()});
            }
            threadLocalPrimaryThread.set(new Boolean(true));
            adfResponse = adfRequestHandler.process((FeatureContextAccessor)((Object)this));
            if (Utility.FrameworkLogger.isLoggable(Level.INFO)) {
                Trace.log(Utility.FrameworkLogger, Level.INFO, FeatureContext.class, "handle", "oracle.adfmf.resource.SharedInfoBundle", "ADF-MF-40011", new Object[]{adfResponse});
            }
        }
        catch (AdfException adfException) {
            adfResponse = AdfMessageHandlerFactory.getErrorResponse(adfApplicationRequest, adfException);
        }
        catch (Exception exception) {
            adfResponse = AdfMessageHandlerFactory.getErrorResponse(adfApplicationRequest, new AdfException(exception));
        }
        return adfResponse;
    }

    protected void performLazyInitialization() {
        threadLocalFCA.set(this);
    }

    public boolean isPrimaryRequestThread() {
        Boolean bl = (Boolean)threadLocalPrimaryThread.get();
        return bl != null && bl != false;
    }

    public boolean isBackgroundThread() {
        return !this.isPrimaryRequestThread();
    }

    public AdfChannel getAdfChannel() {
        return this.channel;
    }

    public VMMessageHandler getMessageHandler() {
        return null;
    }

    public String getName() {
        return this.name;
    }
}

