/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework;

import com.sun.util.logging.Level;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import oracle.adfmf.bindings.OperationDelegateManager;
import oracle.adfmf.bindings.dbf.AmxBindingContext;
import oracle.adfmf.framework.EmbeddedFeatureContextAccessor;
import oracle.adfmf.framework.EmbeddedFeatureContextManager;
import oracle.adfmf.framework.FeatureContext;
import oracle.adfmf.framework.JavaFramework;
import oracle.adfmf.framework.ManagedBeanAwareScope;
import oracle.adfmf.framework.event.DataChangeManager;
import oracle.adfmf.framework.model.AdfELContext;
import oracle.adfmf.metadata.cache.MetaDataFrameworkManager;
import oracle.adfmf.metadata.cpx.ApplicationDefinition;
import oracle.adfmf.share.security.securityContext;
import oracle.adfmf.share.security.securityContextImpl;
import oracle.adfmf.util.AdfBundle;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.XmlAnyDefinition;
import oracle.adfmf.util.logging.Trace;

public class EmbeddedFeatureContext
extends FeatureContext
implements EmbeddedFeatureContextAccessor {
    protected AdfELContext adfElContext = null;
    protected DataChangeManager dcm = new DataChangeManager();
    protected OperationDelegateManager odm = new OperationDelegateManager();
    private MetaDataFrameworkManager mdfm = null;
    private final Map defaultValues = new HashMap();
    private final Map keyAttributes = new HashMap();
    private final Map classValidators = new HashMap();
    private final Map beanDefRegistry = new HashMap();
    protected String cpxPath = null;
    protected String applicationDcxPath = null;
    protected String featureDcxPath = null;
    protected URL[] featurePathURLs = null;

    public static EmbeddedFeatureContext getInstance() {
        EmbeddedFeatureContext embeddedFeatureContext = (EmbeddedFeatureContext)threadLocalFCA.get();
        if (embeddedFeatureContext == null) {
            throw new NullPointerException("The feature context has not been set on this thread");
        }
        return embeddedFeatureContext;
    }

    EmbeddedFeatureContext(EmbeddedFeatureContextManager embeddedFeatureContextManager, Integer n, String string) {
        super(embeddedFeatureContextManager, n, string);
        if (Utility.FrameworkLogger.isLoggable(Level.INFO)) {
            Trace.log(Utility.FrameworkLogger, Level.INFO, EmbeddedFeatureContext.class, "EmbeddedFeatureContext", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40117", new Object[]{n, string});
        }
        this.adfElContext = new AdfELContext(embeddedFeatureContextManager.getAdfELContext());
        this.registerAdfSpecificScopes(this.adfElContext);
        this.createChannel();
    }

    public MetaDataFrameworkManager getMetaDataFrameworkManager() {
        return this.mdfm;
    }

    public void setMetaDataFrameworkManager(MetaDataFrameworkManager metaDataFrameworkManager) {
        this.mdfm = metaDataFrameworkManager;
    }

    public Map getDefaultValuesMap() {
        return this.defaultValues;
    }

    public Map getKeyAttributesMap() {
        return this.keyAttributes;
    }

    public Map getClassValidatorsMap() {
        return this.classValidators;
    }

    public String getCpxPath() {
        return this.cpxPath;
    }

    public String getApplicationDcxPath() {
        return this.applicationDcxPath;
    }

    public String getFeatureDcxPath() {
        return this.featureDcxPath;
    }

    public URL[] getFeaturePathURLs() {
        if (this.featurePathURLs == null) {
            if (this.id == 0) {
                this.featurePathURLs = ((URLClassLoader)this.fcm.applicationClassLoader).getURLs();
            } else {
                String[] stringArray = JavaFramework.getClassPaths(this.getName());
                this.featurePathURLs = EmbeddedFeatureContextManager.getPathURLsFromPathNames(stringArray);
            }
        }
        return this.featurePathURLs;
    }

    protected void performLazyInitialization() {
        block24: {
            Object object;
            block23: {
                block22: {
                    super.performLazyInitialization();
                    try {
                        Thread.currentThread().setContextClassLoader(this.fcm.applicationClassLoader);
                        object = null;
                        try {
                            object = XmlAnyDefinition.loadXmlFromLocation("META-INF/adfm.xml", "MetadataDirectory");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (object == null) {
                            if (this.id == 0 && Utility.FrameworkLogger.isLoggable(Level.WARNING)) {
                                Trace.log(Utility.FrameworkLogger, Level.WARNING, EmbeddedFeatureContext.class, "performLazyInitialization", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40053", new Object[]{"META-INF/adfm.xml"});
                            }
                        } else {
                            this.applicationDcxPath = this.getDcxPath((XmlAnyDefinition)object, true);
                        }
                    }
                    catch (Throwable throwable) {
                        if (!Utility.FrameworkLogger.isLoggable(Level.WARNING)) break block22;
                        Trace.log(Utility.FrameworkLogger, Level.WARNING, EmbeddedFeatureContext.class, "performLazyInitialization", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40054");
                    }
                }
                try {
                    object = URLClassLoader.newInstance(this.getFeaturePathURLs(), ClassLoader.getSystemClassLoader());
                    Thread.currentThread().setContextClassLoader((ClassLoader)object);
                    XmlAnyDefinition xmlAnyDefinition = null;
                    try {
                        xmlAnyDefinition = XmlAnyDefinition.loadXmlFromLocation("META-INF/adfm.xml", "MetadataDirectory");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (xmlAnyDefinition == null) {
                        if (Utility.FrameworkLogger.isLoggable(Level.WARNING)) {
                            Trace.log(Utility.FrameworkLogger, Level.WARNING, EmbeddedFeatureContext.class, "performLazyInitialization", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40055", new Object[]{"META-INF/adfm.xml"});
                        }
                    } else {
                        if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
                            Trace.log(Utility.FrameworkLogger, Level.FINE, EmbeddedFeatureContext.class, "performLazyInitialization", "Load data binding registry: {0}", new Object[]{"META-INF/adfm.xml"});
                        }
                        this.cpxPath = this.getCpxPath(xmlAnyDefinition, false);
                        if (this.cpxPath != null && Utility.FrameworkLogger.isLoggable(Level.FINE)) {
                            Trace.log(Utility.FrameworkLogger, Level.FINE, EmbeddedFeatureContext.class, "performLazyInitialization", "CPX Path: {0}", new Object[]{this.cpxPath});
                        }
                        this.featureDcxPath = this.getDcxPath(xmlAnyDefinition, false);
                        if (this.featureDcxPath != null && Utility.FrameworkLogger.isLoggable(Level.FINE)) {
                            Trace.log(Utility.FrameworkLogger, Level.FINE, EmbeddedFeatureContext.class, "performLazyInitialization", "DCX Path: {0}", new Object[]{this.featureDcxPath});
                        }
                    }
                    if (this.cpxPath != null) {
                        ApplicationDefinition applicationDefinition = MetaDataFrameworkManager.getInstance().getDataBindings(this.cpxPath);
                        AmxBindingContext amxBindingContext = AmxBindingContext.getBindingContext(applicationDefinition, this);
                    }
                    this.getAdfELContext().setVariable("adfBundle", new AdfBundle(), Object.class);
                }
                catch (Throwable throwable) {
                    if (!Utility.FrameworkLogger.isLoggable(Level.WARNING)) break block23;
                    Trace.log(Utility.FrameworkLogger, Level.WARNING, EmbeddedFeatureContext.class, "performLazyInitialization", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40056");
                }
            }
            try {
                if (this.id == 0) {
                    Thread.currentThread().setContextClassLoader(this.fcm.applicationClassLoader);
                } else {
                    object = URLClassLoader.newInstance(this.getFeaturePathURLs(), this.fcm.applicationClassLoader);
                    Thread.currentThread().setContextClassLoader((ClassLoader)object);
                }
            }
            catch (Throwable throwable) {
                if (!Utility.FrameworkLogger.isLoggable(Level.WARNING)) break block24;
                Trace.log(Utility.FrameworkLogger, Level.WARNING, EmbeddedFeatureContext.class, "performLazyInitialization", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40057", new Object[]{throwable.toString()});
            }
        }
    }

    private void registerAdfSpecificScopes(AdfELContext adfELContext) {
        adfELContext.setVariable("viewScope", new ManagedBeanAwareScope("viewScope"), Map.class);
        adfELContext.setVariable("pageFlowScope", new ManagedBeanAwareScope("pageFlowScope"), Map.class);
        adfELContext.setVariable("securityContext", new securityContextImpl(), securityContext.class);
    }

    public AdfELContext getAdfELContext() {
        return this.adfElContext;
    }

    public void setAdfELContext(AdfELContext adfELContext) {
        this.adfElContext = adfELContext;
    }

    public Map getBeanDefinitionRegistry() {
        return this.beanDefRegistry;
    }

    private String getCpxPath(XmlAnyDefinition xmlAnyDefinition, boolean bl) {
        XmlAnyDefinition xmlAnyDefinition2 = xmlAnyDefinition.getChildDefinition("DataBindingRegistry");
        String string = null;
        if (xmlAnyDefinition2 != null) {
            string = (String)xmlAnyDefinition2.getAttributeValue("path");
        } else if (!bl && Utility.FrameworkLogger.isLoggable(Level.WARNING)) {
            Trace.log(Utility.FrameworkLogger, Level.WARNING, EmbeddedFeatureContext.class, "getCpxPath", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40058");
        }
        return string;
    }

    private String getDcxPath(XmlAnyDefinition xmlAnyDefinition, boolean bl) {
        XmlAnyDefinition xmlAnyDefinition2 = xmlAnyDefinition.getChildDefinition("DataControlRegistry");
        String string = null;
        if (xmlAnyDefinition2 != null) {
            string = (String)xmlAnyDefinition2.getAttributeValue("path");
        } else if (!bl && Utility.FrameworkLogger.isLoggable(Level.WARNING)) {
            Trace.log(Utility.FrameworkLogger, Level.WARNING, EmbeddedFeatureContext.class, "getDcxPath", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40059");
        }
        return string;
    }

    public DataChangeManager getDataChangeManager() {
        return this.dcm;
    }

    public void setDataChangeManager(DataChangeManager dataChangeManager) {
        this.dcm = dataChangeManager;
    }

    public OperationDelegateManager getOperationDelegateManager() {
        return this.odm;
    }
}

