/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.dc.ws.marshaller;

import java.io.IOException;
import java.math.BigInteger;
import oracle.adfmf.framework.exception.AdfException;
import org.ksoap2.serialization.Marshal;
import org.ksoap2.serialization.PropertyInfo;
import org.ksoap2.serialization.SoapSerializationEnvelope;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class MarshalInteger
implements Marshal {
    public Object readInstance(XmlPullParser xmlPullParser, String string, String string2, PropertyInfo propertyInfo) throws IOException, XmlPullParserException {
        String string3 = xmlPullParser.nextText();
        if (string2.equalsIgnoreCase("int")) {
            return Integer.valueOf(string3);
        }
        if (string2.equalsIgnoreCase("integer")) {
            return new BigInteger(string3);
        }
        if (string2.equalsIgnoreCase("short")) {
            return new Short(Short.parseShort(string3, 10));
        }
        if (string2.equalsIgnoreCase("long")) {
            return new Long(Long.parseLong(string3, 10));
        }
        throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11053", new Object[]{"integer", "name"});
    }

    public void writeInstance(XmlSerializer xmlSerializer, Object object) throws IOException {
        xmlSerializer.text(object.toString());
    }

    public void register(SoapSerializationEnvelope soapSerializationEnvelope) {
        soapSerializationEnvelope.addMapping(soapSerializationEnvelope.xsd, "int", Integer.class, (Marshal)this);
        soapSerializationEnvelope.addMapping(soapSerializationEnvelope.xsd, "short", Short.class, (Marshal)this);
        soapSerializationEnvelope.addMapping(soapSerializationEnvelope.xsd, "long", Long.class, (Marshal)this);
        soapSerializationEnvelope.addMapping(soapSerializationEnvelope.xsd, "integer", BigInteger.class, (Marshal)this);
    }
}

