/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.dc.rules;

import oracle.adfmf.dc.rules.Validator;
import oracle.adfmf.dc.rules.ValidatorFactory;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.XmlAnyDefinition;

public class LengthValidator
extends Validator {
    public static final Class CLASS_INSTANCE = LengthValidator.class;
    protected static String validatorID = "validation:LengthValidationBean";
    public static final String PNAME_CompareType = "CompareType";
    public static final String PNAME_DataType = "DataType";
    public static final String PNAME_CompareLength = "CompareLength";
    public static final String PNAME_MinValue = "MinValue";
    public static final String PNAME_MaxValue = "MaxValue";
    public static final int EQUALTO = 0;
    public static final int LESSTHAN = 1;
    public static final int GREATERTHAN = 2;
    public static final int LESSTHANEQUALTO = 3;
    public static final int GREATERTHANEQUALTO = 4;
    public static final int BETWEEN = 5;
    public static final String[] operTypeVals = new String[]{"EQUALTO", "LESSTHAN", "GREATERTHAN", "LESSTHANEQUALTO", "GREATERTHANEQUALTO", "BETWEEN"};
    public static final String[] dataTypeVals = new String[]{"CHARACTER", "BYTE"};
    public static final int CHARACTER = 0;
    public static final int BYTE = 1;
    protected int mOperType;
    protected int mDataType;
    protected Object rhsValue;
    protected int mMinLength = -1;
    protected int mMaxLength = -1;

    public static final void registerValidator() {
        ValidatorFactory.registerValidator(validatorID, LengthValidator.class);
    }

    public LengthValidator() {
        this.initUninitializedValidator();
    }

    public LengthValidator(boolean bl, int n, int n2, Object object) {
        this.mbInverse = bl;
        this.setOperType(n);
        this.setDataType(n2);
        this.setRhsValue(object);
    }

    public LengthValidator(XmlAnyDefinition xmlAnyDefinition) {
        this.initUninitializedValidator();
        this.initValidatorProperties(xmlAnyDefinition);
    }

    private void initUninitializedValidator() {
        this.mbInverse = false;
        this.setOperType(0);
        this.setDataType(0);
    }

    public boolean validateValue(Object object) {
        int n = -1;
        int n2 = -1;
        if (object == null) {
            return true;
        }
        String string = object.toString();
        switch (this.mDataType) {
            case 0: {
                n = string.length();
                break;
            }
            case 1: {
                n = Utility.stringToBytes(string).length;
                break;
            }
        }
        if (this.getRhsValue() != null) {
            n2 = Integer.parseInt(this.getRhsValue().toString());
        }
        if (n != -1) {
            switch (this.mOperType) {
                case 0: {
                    return n == n2;
                }
                case 1: {
                    return n < n2;
                }
                case 2: {
                    return n > n2;
                }
                case 3: {
                    return n <= n2;
                }
                case 4: {
                    return n >= n2;
                }
                case 5: {
                    return n >= this.getMinLength() && n <= this.getMaxLength();
                }
            }
        }
        return false;
    }

    public void setOperType(int n) {
        this.mOperType = n;
    }

    public int getOperType() {
        return this.mOperType;
    }

    public void setDataType(int n) {
        this.mDataType = n;
    }

    public int getDataType() {
        return this.mDataType;
    }

    public void setRhsValue(Object object) {
        this.rhsValue = object;
    }

    public Object getRhsValue() {
        return this.rhsValue;
    }

    public int getMinLength() {
        return this.mMinLength;
    }

    public void setMinLength(int n) {
        this.mMinLength = n;
    }

    public int getMaxLength() {
        return this.mMaxLength;
    }

    public void setMaxLength(int n) {
        this.mMaxLength = n;
    }

    public String toString() {
        return this.getDataTypeString() + " Length Compare( " + this.getOperatorTypeString() + this.rhsValue.toString() + ")";
    }

    public static int parseOperatorTypeStr(String string) {
        for (int i = 0; i < operTypeVals.length; ++i) {
            if (!operTypeVals[i].equals(string)) continue;
            return i;
        }
        return 0;
    }

    public static int parseDataTypeStr(String string) {
        for (int i = 0; i < dataTypeVals.length; ++i) {
            if (!dataTypeVals[i].equals(string)) continue;
            return i;
        }
        return 1;
    }

    public String getOperatorTypeString() {
        String string = "";
        switch (this.mOperType) {
            case 0: {
                string = " = ";
                break;
            }
            case 1: {
                string = " < ";
                break;
            }
            case 2: {
                string = " > ";
                break;
            }
            case 3: {
                string = " <= ";
                break;
            }
            case 4: {
                string = " >= ";
                break;
            }
        }
        return string;
    }

    private String getDataTypeString() {
        String string = "";
        switch (this.mDataType) {
            case 1: {
                string = " Byte ";
                break;
            }
            case 0: {
                string = " Character ";
                break;
            }
        }
        return string;
    }

    public void initValidatorProperties(XmlAnyDefinition xmlAnyDefinition) {
        int n;
        super.initValidatorProperties(xmlAnyDefinition);
        Object object = xmlAnyDefinition.getAttributeValue(PNAME_CompareType);
        if (object != null) {
            this.setOperType(LengthValidator.parseOperatorTypeStr((String)object));
        }
        if ((object = xmlAnyDefinition.getAttributeValue(PNAME_DataType)) != null) {
            this.setDataType(LengthValidator.parseDataTypeStr((String)object));
        }
        if ((object = xmlAnyDefinition.getAttributeValue(PNAME_CompareLength)) != null) {
            this.setRhsValue(object);
        }
        if ((object = xmlAnyDefinition.getAttributeValue(PNAME_MinValue)) != null) {
            n = xmlAnyDefinition.getAttributeIntegerValue(PNAME_MinValue);
            this.setMinLength(n);
        }
        if ((object = xmlAnyDefinition.getAttributeValue(PNAME_MaxValue)) != null) {
            n = xmlAnyDefinition.getAttributeIntegerValue(PNAME_MaxValue);
            this.setMaxLength(n);
        }
    }
}

