/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.bindings.dbf;

import com.sun.util.logging.Level;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.adf.model.DataControlFactory;
import oracle.adfmf.bindings.DataControl;
import oracle.adfmf.bindings.dbf.AmxBindingContainer;
import oracle.adfmf.bindings.dbf.ContainerContext;
import oracle.adfmf.cache.CacheProvider;
import oracle.adfmf.cache.SimpleCache;
import oracle.adfmf.dc.rules.ValidationContext;
import oracle.adfmf.framework.EmbeddedFeatureContextAccessor;
import oracle.adfmf.framework.api.AdfmfJavaUtilities;
import oracle.adfmf.framework.exception.AdfException;
import oracle.adfmf.framework.model.AdfELContext;
import oracle.adfmf.metadata.cache.MetaDataFrameworkManager;
import oracle.adfmf.metadata.cpx.ApplicationDefinition;
import oracle.adfmf.metadata.cpx.PageDefinitionUsageDefinition;
import oracle.adfmf.metadata.cpx.PageMapDefinition;
import oracle.adfmf.metadata.dcx.AdapterDataControlDefinition;
import oracle.adfmf.metadata.dcx.DataControlConfigsDefinition;
import oracle.adfmf.metadata.page.PageDefDefinition;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.XmlAnyDefinition;
import oracle.adfmf.util.logging.Trace;

public class AmxBindingContext
implements Map,
CacheProvider {
    public static final String BINDINGCONTEXT_SCOPE_NAME = "data";
    private static final String BINDINGCONTAINER_TYPE_NAME = AmxBindingContainer.class.getName();
    private static final String DATACONTROL_TYPE_NAME = DataControl.class.getName();
    private static final String GENERAL_TYPE_NAME = Object.class.getName();
    private static final String APP_ROOT = "/";
    private SimpleCache containerCtxs = new SimpleCache(this, BINDINGCONTAINER_TYPE_NAME);
    private SimpleCache dataControls = new SimpleCache(this, DATACONTROL_TYPE_NAME);
    private HashMap values = new HashMap();
    private final ApplicationDefinition metaData;

    public static AmxBindingContext getBindingContext(ApplicationDefinition applicationDefinition, EmbeddedFeatureContextAccessor embeddedFeatureContextAccessor) {
        AmxBindingContext amxBindingContext = new AmxBindingContext(applicationDefinition);
        embeddedFeatureContextAccessor.getAdfELContext().setVariable(BINDINGCONTEXT_SCOPE_NAME, amxBindingContext, Map.class);
        return amxBindingContext;
    }

    public AmxBindingContext(ApplicationDefinition applicationDefinition) {
        this.metaData = applicationDefinition;
    }

    private String resolvePageDefPath(String string) {
        String string2 = "";
        PageDefinitionUsageDefinition pageDefinitionUsageDefinition = this.metaData.getPageUsageDefinition(string);
        if (pageDefinitionUsageDefinition != null) {
            string2 = string2 + pageDefinitionUsageDefinition.getPath();
        }
        return string2.replace('.', '/') + ".xml";
    }

    private Object loadContainerById(String string, AdfELContext adfELContext) {
        Object object;
        if (string.indexOf(46) > 0) {
            object = this.metaData.getPageMapDefinition(string);
            if (object == null && !string.startsWith(APP_ROOT)) {
                object = this.metaData.getPageMapDefinition(APP_ROOT + string);
            }
            if (object == null) {
                if (Utility.FrameworkLogger.isLoggable(Level.WARNING)) {
                    Trace.log(Utility.FrameworkLogger, Level.WARNING, AmxBindingContext.class, "setContext", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11043", new Object[]{string});
                }
                return null;
            }
            string = ((PageMapDefinition)object).getUsageId();
        }
        object = this.resolvePageDefPath(string);
        PageDefDefinition pageDefDefinition = MetaDataFrameworkManager.getInstance().getPageDefDefinitionByLocation((String)object);
        AmxBindingContainer amxBindingContainer = AmxBindingContainer.getBindingContainer(pageDefDefinition, this);
        return amxBindingContainer;
    }

    private Object loadDataControlById(String string) {
        XmlAnyDefinition xmlAnyDefinition = this.metaData.getDataControlUsages().getChildDefinition("dc", "id", string);
        if (xmlAnyDefinition == null) {
            if (Utility.FrameworkLogger.isLoggable(Level.SEVERE)) {
                Trace.log(Utility.FrameworkLogger, Level.SEVERE, AmxBindingContext.class, "loadDataControlById", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11044", new Object[]{string});
            }
            throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11044", new Object[]{string});
        }
        DataControlConfigsDefinition dataControlConfigsDefinition = null;
        try {
            dataControlConfigsDefinition = MetaDataFrameworkManager.getInstance().getDataControlConfig();
        }
        catch (Exception exception) {
            if (Utility.FrameworkLogger.isLoggable(Level.SEVERE)) {
                Trace.log(Utility.FrameworkLogger, Level.SEVERE, AmxBindingContext.class, "loadDataControlById", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11045", new Object[]{string});
            }
            throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11045", new Object[]{string});
        }
        AdapterDataControlDefinition adapterDataControlDefinition = dataControlConfigsDefinition.getAdapterDataControl(string);
        if (adapterDataControlDefinition == null) {
            if (Utility.FrameworkLogger.isLoggable(Level.SEVERE)) {
                Trace.log(Utility.FrameworkLogger, Level.SEVERE, AmxBindingContext.class, "loadDataControlById", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11046", new Object[]{string});
            }
            throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11046", new Object[]{string});
        }
        DataControlFactory dataControlFactory = null;
        try {
            dataControlFactory = (DataControlFactory)Utility.loadClass(adapterDataControlDefinition.getFactoryClass()).newInstance();
        }
        catch (Exception exception) {
            if (Utility.FrameworkLogger.isLoggable(Level.SEVERE)) {
                Trace.log(Utility.FrameworkLogger, Level.SEVERE, AmxBindingContext.class, "loadDataControlById", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11047", new Object[]{string});
            }
            throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11047", new Object[]{string});
        }
        DataControl dataControl = null;
        try {
            dataControl = dataControlFactory.createDataControl(this, adapterDataControlDefinition, null);
            dataControl.setName(string);
            if (!string.equals(dataControl.getName()) && Utility.FrameworkLogger.isLoggable(Level.SEVERE)) {
                Trace.log(Utility.FrameworkLogger, Level.SEVERE, AmxBindingContext.class, "loadDataControlById", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11048", new Object[]{dataControl.getName(), string});
            }
        }
        catch (Exception exception) {
            if (Utility.FrameworkLogger.isLoggable(Level.SEVERE)) {
                Trace.log(Utility.FrameworkLogger, Level.SEVERE, AmxBindingContext.class, "loadDataControlById", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11049", new Object[]{string, exception});
            }
            if (exception instanceof AdfException) {
                throw (AdfException)exception;
            }
            throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11049", new Object[]{string, exception});
        }
        return dataControl;
    }

    public ContainerContext getContainerContext(String string, String string2) {
        ContainerContextRegistry containerContextRegistry = (ContainerContextRegistry)this.containerCtxs.get(string, BINDINGCONTAINER_TYPE_NAME);
        ContainerContext containerContext = containerContextRegistry.get(string2);
        if (containerContext == null) {
            AdfELContext adfELContext = new AdfELContext(AdfmfJavaUtilities.getAdfELContext());
            AmxBindingContainer amxBindingContainer = (AmxBindingContainer)this.loadContainerById(string, adfELContext);
            adfELContext.setVariable("bindings_contextKey", string, String.class);
            adfELContext.setVariable("validationScope", new ValidationContext(string), Map.class);
            containerContext = new ContainerContext(amxBindingContainer, adfELContext, string2);
            containerContextRegistry.add(containerContext);
        }
        return containerContext;
    }

    public void removeContainerContext(String string, String string2) {
        ContainerContextRegistry containerContextRegistry = (ContainerContextRegistry)this.containerCtxs.get(string, BINDINGCONTAINER_TYPE_NAME);
        ContainerContext containerContext = containerContextRegistry.get(string2);
        if (containerContext != null) {
            AmxBindingContainer amxBindingContainer = containerContext.getContainer();
            if (amxBindingContainer != null) {
                amxBindingContainer.release();
            }
            containerContextRegistry.remove(string2);
        }
    }

    public Object getDataControlById(String string) {
        return this.dataControls.get(string, DATACONTROL_TYPE_NAME);
    }

    public Object fetch(Object object, Object object2) {
        Object object3 = null;
        if (BINDINGCONTAINER_TYPE_NAME.equals(object2)) {
            object3 = new ContainerContextRegistry();
        } else if (DATACONTROL_TYPE_NAME.equals(object2)) {
            object3 = this.loadDataControlById(object.toString());
        }
        return object3;
    }

    public Object get(Object object) {
        Object v = this.values.get(object);
        if (v != null) {
            return v;
        }
        Set set = this.containerCtxs.keySet(BINDINGCONTAINER_TYPE_NAME);
        if (set.contains(object)) {
            return this.containerCtxs.get(object, BINDINGCONTAINER_TYPE_NAME);
        }
        Set set2 = this.dataControls.keySet(DATACONTROL_TYPE_NAME);
        if (set2.contains(object)) {
            return this.dataControls.get(object, DATACONTROL_TYPE_NAME);
        }
        return null;
    }

    public Object put(Object object, Object object2) {
        return this.values.put(object, object2);
    }

    public void putAll(Map map) {
        this.values.putAll(map);
    }

    public void clear() {
        this.values.clear();
    }

    public boolean containsKey(Object object) {
        return this.values.containsKey(object);
    }

    public boolean containsValue(Object object) {
        return this.values.containsValue(object);
    }

    public Set entrySet() {
        return this.values.entrySet();
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public Set keySet() {
        return this.values.keySet();
    }

    public Object remove(Object object) {
        return this.values.remove(object);
    }

    public int size() {
        return this.values.size();
    }

    public Collection values() {
        return this.values.values();
    }

    private static final class ContainerContextRegistry {
        private List cctxs = new ArrayList();

        private ContainerContextRegistry() {
        }

        public ContainerContext get(String string) {
            if (Utility.isEmpty(string)) {
                return this.cctxs.size() > 0 ? this.cctxs.get(0) : null;
            }
            Iterator iterator = this.cctxs.iterator();
            while (iterator.hasNext()) {
                ContainerContext containerContext = (ContainerContext)iterator.next();
                if (!string.equals(containerContext.getInstanceId())) continue;
                return containerContext;
            }
            return null;
        }

        public void add(ContainerContext containerContext) {
            this.cctxs.add(containerContext);
        }

        public void remove(String string) {
            ContainerContext containerContext = this.get(string);
            this.cctxs.remove(containerContext);
        }
    }
}

