/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.model.datacontrols.device;

import com.sun.util.logging.Level;
import oracle.adf.model.datacontrols.device.CameraProxy;
import oracle.adf.model.datacontrols.device.Contact;
import oracle.adf.model.datacontrols.device.ContactProxy;
import oracle.adf.model.datacontrols.device.DeviceManager;
import oracle.adf.model.datacontrols.device.DevicePropertiesProxy;
import oracle.adf.model.datacontrols.device.FileDisplayProxy;
import oracle.adf.model.datacontrols.device.GeolocationCallback;
import oracle.adf.model.datacontrols.device.GeolocationProxy;
import oracle.adf.model.datacontrols.device.Location;
import oracle.adf.model.datacontrols.device.MessagingProxy;
import oracle.adfmf.cache.TimeoutCache;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.logging.Trace;

public class RuntimeDeviceManager
implements DeviceManager {
    private GeolocationProxy geolocationProxy = new GeolocationProxy();
    private DevicePropertiesProxy devicePropertiesProxy = new DevicePropertiesProxy();
    private ContactProxy contactProxy = new ContactProxy();
    private MessagingProxy messagingProxy = new MessagingProxy();
    private CameraProxy cameraProxy = new CameraProxy();
    private FileDisplayProxy fileDisplayProxy = new FileDisplayProxy();
    private static final RuntimeDeviceManager instance = new RuntimeDeviceManager();
    private static long lastSpecifiedMaxAge = 100000L;
    private static TimeoutCache timeoutCache = new TimeoutCache();

    public static RuntimeDeviceManager getInstance() {
        return instance;
    }

    private RuntimeDeviceManager() {
    }

    protected Object getCachedValue(Object object) {
        return timeoutCache.get(object);
    }

    protected void putCachedValue(Object object, Object object2, long l) {
        timeoutCache.put(object, object2, l);
    }

    protected void updateCachedValues(Object object, Object object2) {
        this.putCachedValue(object, object2, lastSpecifiedMaxAge);
    }

    public Location getCurrentPosition(int n, boolean bl) {
        return this.geolocationProxy.getCurrentPosition(n, 60000, bl);
    }

    public String startUpdatingPosition(int n, boolean bl, String string, GeolocationCallback geolocationCallback) {
        return this.geolocationProxy.watchPosition(n, 60000, bl, string, geolocationCallback);
    }

    public void clearWatchPosition(String string) {
        this.geolocationProxy.clearWatch(string);
    }

    public String getName() {
        return this.devicePropertiesProxy.getName();
    }

    public String getPlatform() {
        return this.devicePropertiesProxy.getPlatform();
    }

    public String getVersion() {
        return this.devicePropertiesProxy.getVersion();
    }

    public String getOs() {
        return this.devicePropertiesProxy.getOs();
    }

    public String getModel() {
        return this.devicePropertiesProxy.getModel();
    }

    public String getPhonegap() {
        return this.devicePropertiesProxy.getPhonegap();
    }

    public boolean hasCamera() {
        return this.devicePropertiesProxy.getHasCamera();
    }

    public boolean hasContacts() {
        return this.devicePropertiesProxy.getHasContacts();
    }

    public boolean hasTouchScreen() {
        return this.devicePropertiesProxy.getHasTouchScreen();
    }

    public boolean hasGeolocation() {
        return this.devicePropertiesProxy.getHasGeolocation();
    }

    public boolean hasAccelerometer() {
        return this.devicePropertiesProxy.getHasAccelerometer();
    }

    public boolean hasCompass() {
        return this.devicePropertiesProxy.getHasCompass();
    }

    public String getNetworkStatus() {
        return this.devicePropertiesProxy.getNetworkStatus();
    }

    public int getScreenWidth() {
        return this.devicePropertiesProxy.getScreenWidth();
    }

    public int getScreenHeight() {
        return this.devicePropertiesProxy.getScreenHeight();
    }

    public int getAvailableScreenWidth() {
        return this.devicePropertiesProxy.getAvailableScreenWidth();
    }

    public int getAvailableScreenHeight() {
        return this.devicePropertiesProxy.getAvailableScreenHeight();
    }

    public boolean hasFileAccess() {
        return this.devicePropertiesProxy.getHasFileAccess();
    }

    public boolean hasLocalStorage() {
        return this.devicePropertiesProxy.getHasLocalStorage();
    }

    public boolean hasMediaPlayer() {
        return this.devicePropertiesProxy.getHasMediaPlayer();
    }

    public boolean hasMediaRecorder() {
        return this.devicePropertiesProxy.getHasMediaRecorder();
    }

    public String getPicture(int n, int n2, int n3, boolean bl, int n4, int n5, int n6) {
        String string = this.cameraProxy.getPicture(n, n2, n3, bl, n4, n5, n6);
        if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
            Trace.log(Utility.FrameworkLogger, Level.FINE, RuntimeDeviceManager.class, "getPicture", "ImageData = {0}", new Object[]{string});
        }
        return string;
    }

    public Contact[] findContacts(String string, String string2, boolean bl) {
        Contact[] contactArray = this.contactProxy.findContacts(string, string2, bl);
        return contactArray;
    }

    public Contact createContact(Contact contact) {
        return this.contactProxy.createContact(contact);
    }

    public void removeContact(Contact contact) {
        this.contactProxy.removeContact(contact);
    }

    public Contact updateContact(Contact contact) {
        return this.contactProxy.updateContact(contact);
    }

    public void sendEmail(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        this.messagingProxy.sendEmail(string, string2, string3, string4, string5, string6, string7);
    }

    public void sendSMS(String string, String string2) {
        this.messagingProxy.sendSMS(string, string2);
    }

    public int getScreenDpi() {
        return this.devicePropertiesProxy.getScreenDpi();
    }

    public double getScreenScaleFactor() {
        return this.devicePropertiesProxy.getScreenScaleFactor();
    }

    public double getScreenDiagonalSize() {
        return this.devicePropertiesProxy.getScreenDiagonalSize();
    }

    public void displayFile(String string, String string2) {
        this.fileDisplayProxy.displayFile(string, string2);
    }
}

