/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.model.datacontrols.device;

import com.sun.util.logging.Level;
import java.util.Date;
import java.util.HashMap;
import oracle.adf.model.datacontrols.device.BaseProxy;
import oracle.adf.model.datacontrols.device.GeolocationCallback;
import oracle.adf.model.datacontrols.device.Location;
import oracle.adfmf.framework.api.AdfmfContainerUtilities;
import oracle.adfmf.framework.api.AdfmfJavaUtilities;
import oracle.adfmf.framework.api.Model;
import oracle.adfmf.framework.exception.AdfException;
import oracle.adfmf.framework.internal.AdfmfContainerUtilitiesInternal;
import oracle.adfmf.json.JSONObject;
import oracle.adfmf.misc.ISO8601DateTimeUtil;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.logging.Trace;

public class GeolocationProxy
extends BaseProxy {
    private static long lastSpecifiedMaxAge = 60000L;
    private static final String GET_CURRENT_POSITION_METHOD = "adf.mf.internal.api.getCurrentPosition";
    private static final String WATCH_POSITION_METHOD = "adf.mf.internal.api.watchPosition";
    private static final String CLEAR_WATCH_METHOD = "adf.mf.internal.api.clearWatch";
    private static final String LOCATION_KEY = "Location";
    private static final String ENABLE_HIGH_ACCURACY_KEY = "enableHighAccuracy";
    private static final String TIMEOUT_KEY = "timeout";
    private static final String MAXIMUM_AGE_KEY = "maximumAge";
    private static final long GEO_LOCATION_ASYNC_JS_TIMEOUT = 300000L;
    private static final int FIRST_TIMEOUT = 3000;
    private static final int MINIMUM_GCP_MAXIMUM_AGE = 1000;
    private static HashMap callbackDictionary = new HashMap();
    private static HashMap userToCordovaWatchIdMap = new HashMap();

    public Location getCurrentPosition(int n, int n2, boolean bl) {
        if (Utility.FrameworkLogger.isLoggable(Level.INFO)) {
            Trace.log(Utility.FrameworkLogger, Level.INFO, GeolocationProxy.class, "getCurrentPosition", "ADF-MF-40021", new Object[]{new Integer(n), new Integer(n2), new Boolean(bl)});
        }
        if (n < 1000) {
            n = 1000;
        }
        lastSpecifiedMaxAge = n;
        Location location = this.getCachedPosition();
        if (location != null) {
            return location;
        }
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put(TIMEOUT_KEY, n2);
            jSONObject.put(MAXIMUM_AGE_KEY, n);
            jSONObject.put(ENABLE_HIGH_ACCURACY_KEY, bl);
            Model.waitForDeviceReady();
            Object object = AdfmfContainerUtilitiesInternal.invokeAsyncContainerJavaScriptFunction("_Back_Communication_Channel_", AdfmfJavaUtilities.getFeatureName(), GET_CURRENT_POSITION_METHOD, new Object[]{jSONObject}, JSONObject.class);
            Location location2 = GeolocationProxy.convertPositiontoLocation((JSONObject)object, null);
            if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                Trace.log(Utility.FrameworkLogger, Level.FINEST, GeolocationProxy.class, "getCurrentPosition", "Location JSON = {0}", new Object[]{object});
            }
            this.updateCachedPosition(location2);
            return location2;
        }
        catch (Exception exception) {
            throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11034", null);
        }
    }

    private void updateCachedPosition(Location location) {
        this.putCachedValue(LOCATION_KEY, location, lastSpecifiedMaxAge);
    }

    private Location getCachedPosition() {
        return (Location)this.getCachedValue(LOCATION_KEY);
    }

    public String watchPosition(int n, int n2, boolean bl, String string, GeolocationCallback geolocationCallback) {
        if (Utility.FrameworkLogger.isLoggable(Level.INFO)) {
            Trace.log(Utility.FrameworkLogger, Level.INFO, GeolocationProxy.class, "watchPosition", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40022", new Object[]{new Integer(n), new Integer(n2), new Boolean(bl), string, geolocationCallback});
        }
        lastSpecifiedMaxAge = n;
        int n3 = 1;
        Location location = this.getCachedPosition();
        if (location == null) {
            n3 = 5;
            if (n2 > 3000) {
                n2 = 3000;
            }
        }
        while (n3 > 0) {
            try {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put(TIMEOUT_KEY, n2);
                jSONObject.put(MAXIMUM_AGE_KEY, n);
                jSONObject.put(ENABLE_HIGH_ACCURACY_KEY, bl);
                Object object = AdfmfContainerUtilitiesInternal.invokeAsyncContainerJavaScriptFunction("_Back_Communication_Channel_", AdfmfJavaUtilities.getFeatureName(), WATCH_POSITION_METHOD, new Object[]{string, jSONObject}, String.class, 300000L);
                String string2 = Utility.removeQuotes((String)object);
                callbackDictionary.put(string, geolocationCallback);
                userToCordovaWatchIdMap.put(string, string2);
                return string2;
            }
            catch (Exception exception) {
                if (--n3 != 0) continue;
                throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11035", null);
            }
        }
        return null;
    }

    public void invokeEmbeddedCallback(String string, JSONObject jSONObject) {
        Location location = null;
        try {
            location = GeolocationProxy.convertPositiontoLocation(jSONObject, string);
            if (Utility.FrameworkLogger.isLoggable(Level.INFO)) {
                Trace.log(Utility.FrameworkLogger, Level.INFO, GeolocationProxy.class, "invokeEmbeddedCallback", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40023", new Object[]{location, string});
            }
            this.updateCachedPosition(location);
        }
        catch (Exception exception) {
            Trace.log(Utility.FrameworkLogger, Level.SEVERE, GeolocationProxy.class, "invokeEmbeddedCallback", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11060", new Object[]{exception});
            throw new AdfException(exception);
        }
        if (Utility.isEmpty(string)) {
            return;
        }
        GeolocationCallback geolocationCallback = (GeolocationCallback)callbackDictionary.get(string);
        if (geolocationCallback != null) {
            if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                Trace.log(Utility.FrameworkLogger, Level.FINEST, GeolocationProxy.class, "invokeEmbeddedCallback", "Callback {0} found, invoking it", new Object[]{string});
            }
            geolocationCallback.locationUpdated(location);
        } else if (Utility.FrameworkLogger.isLoggable(Level.WARNING)) {
            Trace.log(Utility.FrameworkLogger, Level.WARNING, GeolocationProxy.class, "invokeEmbeddedCallback", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11032", new Object[]{string});
        }
    }

    public void clearWatch(String string) {
        String string2 = (String)userToCordovaWatchIdMap.remove(string);
        AdfmfContainerUtilities.invokeContainerJavaScriptFunction(AdfmfJavaUtilities.getFeatureName(), CLEAR_WATCH_METHOD, new Object[]{string2});
        callbackDictionary.remove(string2);
    }

    public static Location convertPositiontoLocation(JSONObject jSONObject, String string) throws Exception {
        if (jSONObject == null) {
            return null;
        }
        JSONObject jSONObject2 = (JSONObject)jSONObject.get("coords");
        Object object = jSONObject.get("timestamp");
        Date date = object instanceof Long ? new Date((Long)object) : ISO8601DateTimeUtil.coerceToDate((Class)Date.class, (String)((String)object));
        Location location = new Location(jSONObject2.optDouble("latitude", 0.0), jSONObject2.optDouble("longitude", 0.0), jSONObject2.optDouble("altitude", 0.0), jSONObject2.optDouble("accuracy", 0.0), jSONObject2.optDouble("altitudeAccuracy", 0.0), jSONObject2.optDouble("heading", 0.0), jSONObject2.optDouble("speed", 0.0), date.getTime(), string);
        return location;
    }
}

