/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.model.datacontrols.device;

import com.sun.util.logging.Level;
import java.util.HashMap;
import oracle.adf.model.datacontrols.device.BaseProxy;
import oracle.adfmf.framework.api.AdfmfJavaUtilities;
import oracle.adfmf.framework.api.Model;
import oracle.adfmf.framework.contract.adf.DeviceHardware;
import oracle.adfmf.framework.contract.adf.DeviceProperties;
import oracle.adfmf.framework.contract.adf.DeviceScreen;
import oracle.adfmf.framework.exception.AdfException;
import oracle.adfmf.framework.internal.AdfmfContainerUtilitiesInternal;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.logging.Trace;

public class DevicePropertiesProxy
extends BaseProxy {
    private static final String GET_ALL_DEVICE_PROPERTIES_METHOD = "adf.mf.internal.api.getDeviceProperties";
    private static final String DEVICE_DEVICE_KEY = "device";
    private static final String DEVICE_HARDWARE_KEY = "hardware";
    private static HashMap allDeviceProperties = null;

    private HashMap getAllDeviceProperties() {
        if (Utility.FrameworkLogger.isLoggable(Level.INFO)) {
            Trace.log(Utility.FrameworkLogger, Level.INFO, DevicePropertiesProxy.class, "getAllDeviceProperties", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40020");
        }
        if (allDeviceProperties == null) {
            if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                Trace.log(Utility.FrameworkLogger, Level.FINEST, DevicePropertiesProxy.class, "getAllDeviceProperties", (Object)"Before invokeContainerHandlerMethod");
            }
            try {
                Model.waitForDeviceReady();
                Object object = AdfmfContainerUtilitiesInternal.invokeAsyncContainerJavaScriptFunction("_Back_Communication_Channel_", AdfmfJavaUtilities.getFeatureName(), GET_ALL_DEVICE_PROPERTIES_METHOD, new Object[]{}, HashMap.class);
                allDeviceProperties = (HashMap)object;
            }
            catch (Exception exception) {
                throw new AdfException(exception);
            }
            if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                Trace.log(Utility.FrameworkLogger, Level.FINEST, DevicePropertiesProxy.class, "getAllDeviceProperties", (Object)"After invokeContainerHandlerMethod");
            }
        }
        return allDeviceProperties;
    }

    public DeviceProperties getDevice() {
        return (DeviceProperties)this.getAllDeviceProperties().get(DEVICE_DEVICE_KEY);
    }

    public void setDevice(DeviceProperties deviceProperties) {
        this.getAllDeviceProperties().put(DEVICE_DEVICE_KEY, deviceProperties);
    }

    public DeviceHardware getHardware() {
        return (DeviceHardware)this.getAllDeviceProperties().get(DEVICE_HARDWARE_KEY);
    }

    public void setHardware(DeviceHardware deviceHardware) {
        this.getAllDeviceProperties().put(DEVICE_HARDWARE_KEY, deviceHardware);
    }

    public String getName() {
        return this.getDevice().getName();
    }

    public String getPlatform() {
        return this.getDevice().getPlatform();
    }

    public String getVersion() {
        return this.getDevice().getVersion();
    }

    public String getOs() {
        return this.getDevice().getOs();
    }

    public String getModel() {
        return this.getDevice().getModel();
    }

    public String getPhonegap() {
        return this.getDevice().getPhonegap();
    }

    public boolean getHasCamera() {
        return this.getHardware().getHasCamera();
    }

    public boolean getHasContacts() {
        return this.getHardware().getHasContacts();
    }

    public boolean getHasTouchScreen() {
        return this.getHardware().getHasTouchScreen();
    }

    public boolean getHasGeolocation() {
        return this.getHardware().getHasGeolocation();
    }

    public boolean getHasAccelerometer() {
        return this.getHardware().getHasAccelerometer();
    }

    public boolean getHasCompass() {
        return this.getHardware().getHasCompass();
    }

    public boolean getHasFileAccess() {
        return this.getHardware().getHasFileAccess();
    }

    public boolean getHasLocalStorage() {
        return this.getHardware().getHasLocalStorage();
    }

    public boolean getHasMediaPlayer() {
        return this.getHardware().getHasMediaPlayer();
    }

    public boolean getHasMediaRecorder() {
        return this.getHardware().getHasMediaRecorder();
    }

    public String getNetworkStatus() {
        return this.getHardware().getNetworkStatus();
    }

    private DeviceScreen getHardwareScreen() {
        return this.getHardware().getScreen();
    }

    public int getScreenWidth() {
        return this.getHardwareScreen().getWidth();
    }

    public int getScreenHeight() {
        return this.getHardwareScreen().getHeight();
    }

    public int getAvailableScreenWidth() {
        return this.getHardwareScreen().getAvailableWidth();
    }

    public int getAvailableScreenHeight() {
        return this.getHardwareScreen().getAvailableHeight();
    }

    public int getScreenDpi() {
        return this.getHardwareScreen().getDpi();
    }

    public double getScreenDiagonalSize() {
        return this.getHardwareScreen().getDiagonalSize();
    }

    public double getScreenScaleFactor() {
        return this.getHardwareScreen().getScaleFactor();
    }
}

