/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import com.sun.security.cert.CertPathValidatorException;
import com.sun.security.cert.CertStoreException;
import com.sun.security.cert.PKIXBuilderParameters;
import com.sun.security.cert.PKIXCertPathChecker;
import com.sun.security.cert.TrustAnchor;
import com.sun.security.cert.X509CertSelector;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import sun.security.provider.certpath.AlgorithmChecker;
import sun.security.provider.certpath.Builder;
import sun.security.provider.certpath.CertPathHelper;
import sun.security.provider.certpath.CrlRevocationChecker;
import sun.security.provider.certpath.ForwardState;
import sun.security.provider.certpath.KeyChecker;
import sun.security.provider.certpath.State;
import sun.security.util.Debug;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;

class ForwardBuilder
extends Builder {
    private Debug debug = Debug.getInstance("certpath");
    private Date date;
    private final Set trustedCerts;
    private final Set trustedSubjectDNs;
    private final Set trustAnchors;
    private X509CertSelector eeSelector;
    private X509CertSelector caSelector;
    private X509CertSelector caTargetSelector;
    TrustAnchor trustAnchor;
    private Comparator comparator;

    ForwardBuilder(PKIXBuilderParameters pKIXBuilderParameters, X500Principal x500Principal) {
        super(pKIXBuilderParameters, x500Principal);
        this.date = pKIXBuilderParameters.getDate();
        if (this.date == null) {
            this.date = new Date();
        }
        this.trustAnchors = pKIXBuilderParameters.getTrustAnchors();
        this.trustedCerts = new HashSet(this.trustAnchors.size());
        this.trustedSubjectDNs = new HashSet(this.trustAnchors.size());
        Iterator iterator = this.trustAnchors.iterator();
        while (iterator.hasNext()) {
            TrustAnchor trustAnchor = (TrustAnchor)iterator.next();
            X509Certificate x509Certificate = trustAnchor.getTrustedCert();
            if (x509Certificate != null) {
                this.trustedCerts.add(x509Certificate);
                this.trustedSubjectDNs.add(x509Certificate.getSubjectX500Principal());
                continue;
            }
            this.trustedSubjectDNs.add(CertPathHelper.getCA(trustAnchor));
        }
        this.comparator = new PKIXCertComparator(this.trustedSubjectDNs);
    }

    Collection getMatchingCerts(State state) throws CertStoreException, CertificateException, IOException {
        if (this.debug != null) {
            this.debug.println("ForwardBuilder.getMatchingCerts()...");
        }
        ForwardState forwardState = (ForwardState)state;
        ArrayList arrayList = new ArrayList();
        if (forwardState.isInitial()) {
            arrayList.addAll(this.getMatchingEECerts(forwardState));
        }
        arrayList.addAll(this.getMatchingCACerts(forwardState));
        Collections.sort(arrayList, this.comparator);
        return arrayList;
    }

    private Collection getMatchingEECerts(ForwardState forwardState) throws CertStoreException, CertificateException, IOException {
        if (this.debug != null) {
            this.debug.println("ForwardBuilder.getMatchingEECerts()...");
        }
        if (this.eeSelector == null) {
            this.eeSelector = (X509CertSelector)this.buildParams.getTargetCertConstraints();
            this.eeSelector.setCertificateValid(this.date);
            if (this.buildParams.isExplicitPolicyRequired()) {
                this.eeSelector.setPolicy(this.getMatchingPolicies());
            }
            this.eeSelector.setBasicConstraints(-2);
        }
        HashSet hashSet = new HashSet();
        ForwardBuilder.addMatchingCerts(this.eeSelector, this.buildParams.getCertStores(), hashSet);
        return hashSet;
    }

    private Collection getMatchingCACerts(ForwardState forwardState) throws CertificateException, CertStoreException, IOException {
        if (this.debug != null) {
            this.debug.println("ForwardBuilder.getMatchingCACerts()...");
        }
        X509CertSelector x509CertSelector = null;
        if (forwardState.isInitial()) {
            if (this.caTargetSelector == null) {
                this.caTargetSelector = (X509CertSelector)this.buildParams.getTargetCertConstraints();
                this.caTargetSelector.setCertificateValid(this.date);
                if (this.buildParams.isExplicitPolicyRequired()) {
                    this.caTargetSelector.setPolicy(this.getMatchingPolicies());
                }
            }
            this.caTargetSelector.setBasicConstraints(forwardState.traversedCACerts);
            x509CertSelector = this.caTargetSelector;
        } else {
            if (this.caSelector == null) {
                this.caSelector = new X509CertSelector();
                this.caSelector.setCertificateValid(this.date);
                if (this.buildParams.isExplicitPolicyRequired()) {
                    this.caSelector.setPolicy(this.getMatchingPolicies());
                }
            }
            CertPathHelper.setSubject(this.caSelector, forwardState.issuerDN);
            CertPathHelper.setPathToNames(this.caSelector, forwardState.subjectNamesTraversed);
            this.caSelector.setBasicConstraints(forwardState.traversedCACerts);
            x509CertSelector = this.caSelector;
        }
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        X509CertSelector x509CertSelector2 = new X509CertSelector();
        if (forwardState.isInitial()) {
            x509CertSelector2 = (X509CertSelector)this.buildParams.getTargetCertConstraints();
        } else {
            CertPathHelper.setSubject(x509CertSelector2, forwardState.issuerDN);
        }
        Iterator iterator = this.trustedCerts.iterator();
        while (iterator.hasNext()) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            if (!x509CertSelector2.match(x509Certificate)) continue;
            if (this.debug != null) {
                this.debug.println("ForwardBuilder.getMatchingCACerts: found matching trust anchor");
            }
            arrayList.add(x509Certificate);
        }
        if (forwardState.isInitial() || this.buildParams.getMaxPathLength() == -1 || this.buildParams.getMaxPathLength() > forwardState.traversedCACerts) {
            ForwardBuilder.addMatchingCerts(x509CertSelector, this.buildParams.getCertStores(), arrayList);
        }
        return arrayList;
    }

    void verifyCert(X509Certificate x509Certificate, State state, List list) throws GeneralSecurityException {
        boolean bl;
        Object object;
        Object object2;
        Object object3;
        int n;
        if (this.debug != null) {
            this.debug.println("ForwardBuilder.verifyCert(SN: " + Debug.toHexString(x509Certificate.getSerialNumber()) + "\n  Issuer: " + x509Certificate.getIssuerX500Principal() + ")" + "\n  Subject: " + x509Certificate.getSubjectX500Principal() + ")");
        }
        ForwardState forwardState = (ForwardState)state;
        if (list != null && !list.isEmpty()) {
            Iterator iterator = list.iterator();
            n = 0;
            while (iterator.hasNext()) {
                object3 = (X509Certificate)iterator.next();
                object2 = X509CertImpl.toImpl((X509Certificate)object3);
                object = ((X509CertImpl)object2).getPolicyMappingsExtension();
                if (object != null) {
                    n = 1;
                }
                if (this.debug != null) {
                    this.debug.println("policyMappingFound = " + (n != 0));
                }
                if (!x509Certificate.equals(object3) || !this.buildParams.isPolicyMappingInhibited() && n) continue;
                if (this.debug != null) {
                    this.debug.println("loop detected!!");
                }
                throw new CertPathValidatorException("loop detected");
            }
        }
        if (!(bl = this.isTrustedCert(x509Certificate))) {
            AlgorithmChecker.check(x509Certificate);
            Set set = x509Certificate.getCriticalExtensionOIDs();
            if (set == null) {
                set = Collections.EMPTY_SET;
            }
            object3 = forwardState.forwardCheckers.iterator();
            while (object3.hasNext()) {
                object2 = (PKIXCertPathChecker)object3.next();
                ((PKIXCertPathChecker)object2).check(x509Certificate, set);
            }
            object2 = this.buildParams.getCertPathCheckers();
            object = object2.iterator();
            while (object.hasNext()) {
                Set set2;
                PKIXCertPathChecker pKIXCertPathChecker = (PKIXCertPathChecker)object.next();
                if (pKIXCertPathChecker.isForwardCheckingSupported() || (set2 = pKIXCertPathChecker.getSupportedExtensions()) == null) continue;
                Iterator iterator = set2.iterator();
                while (iterator.hasNext()) {
                    set.remove(iterator.next());
                }
            }
            if (!set.isEmpty()) {
                set.remove(PKIXExtensions.BasicConstraints_Id.toString());
                set.remove(PKIXExtensions.NameConstraints_Id.toString());
                set.remove(PKIXExtensions.CertificatePolicies_Id.toString());
                set.remove(PKIXExtensions.PolicyMappings_Id.toString());
                set.remove(PKIXExtensions.PolicyConstraints_Id.toString());
                set.remove(PKIXExtensions.InhibitAnyPolicy_Id.toString());
                set.remove(PKIXExtensions.SubjectAlternativeName_Id.toString());
                set.remove(PKIXExtensions.KeyUsage_Id.toString());
                set.remove(PKIXExtensions.ExtendedKeyUsage_Id.toString());
                if (!set.isEmpty()) {
                    throw new CertificateException("Unrecognized critical extension(s)");
                }
            }
        }
        if (forwardState.isInitial()) {
            return;
        }
        if (!bl) {
            n = x509Certificate.getBasicConstraints();
            if (n == -1) {
                throw new CertificateException("cert is NOT a CA cert");
            }
            KeyChecker.verifyCAKeyUsage(x509Certificate);
        }
        if (this.buildParams.isRevocationEnabled()) {
            if (forwardState.crlChecker.certCanSignCrl(x509Certificate)) {
                if (!forwardState.keyParamsNeeded()) {
                    forwardState.crlChecker.check(forwardState.cert, x509Certificate.getPublicKey(), true);
                }
            } else {
                throw new CertPathValidatorException("cert can't vouch for crl");
            }
        }
        if (!forwardState.keyParamsNeeded()) {
            forwardState.cert.verify(x509Certificate.getPublicKey(), this.buildParams.getSigProvider());
        }
    }

    boolean isPathCompleted(X509Certificate x509Certificate) {
        Iterator iterator = this.trustAnchors.iterator();
        while (iterator.hasNext()) {
            TrustAnchor trustAnchor = (TrustAnchor)iterator.next();
            if (trustAnchor.getTrustedCert() != null) {
                if (!x509Certificate.equals(trustAnchor.getTrustedCert())) continue;
                this.trustAnchor = trustAnchor;
                return true;
            }
            X500Principal x500Principal = CertPathHelper.getCA(trustAnchor);
            if (!x500Principal.equals(x509Certificate.getIssuerX500Principal())) continue;
            if (this.buildParams.isRevocationEnabled()) {
                try {
                    CrlRevocationChecker crlRevocationChecker = new CrlRevocationChecker(null, this.buildParams.getCertStores(), this.buildParams.getSigProvider(), this.buildParams.getDate());
                    crlRevocationChecker.check(x509Certificate, trustAnchor.getCAPublicKey(), true);
                }
                catch (CertPathValidatorException certPathValidatorException) {
                    if (this.debug == null) continue;
                    this.debug.println("ForwardBuilder.isPathCompleted() cpve");
                    certPathValidatorException.printStackTrace();
                    continue;
                }
                catch (Exception exception) {
                    if (this.debug == null) continue;
                    this.debug.println("ForwardBuilder.isPathCompleted() unexpected exception");
                    exception.printStackTrace();
                    continue;
                }
            }
            try {
                x509Certificate.verify(trustAnchor.getCAPublicKey(), this.buildParams.getSigProvider());
            }
            catch (InvalidKeyException invalidKeyException) {
                if (this.debug == null) continue;
                this.debug.println("ForwardBuilder.isPathCompleted() invalid DSA key found");
                continue;
            }
            catch (Exception exception) {
                if (this.debug == null) continue;
                this.debug.println("ForwardBuilder.isPathCompleted() 2 unexpected exception");
                exception.printStackTrace();
                continue;
            }
            this.trustAnchor = trustAnchor;
            return true;
        }
        return false;
    }

    boolean isTrustedCert(X509Certificate x509Certificate) {
        return this.trustedCerts.contains(x509Certificate);
    }

    void addCertToPath(X509Certificate x509Certificate, LinkedList linkedList) {
        linkedList.addFirst(x509Certificate);
    }

    void removeFinalCertFromPath(LinkedList linkedList) {
        linkedList.removeFirst();
    }

    static class PKIXCertComparator
    implements Comparator {
        private static final Debug debug = Debug.getInstance("certpath");
        static final String METHOD_NME = "ForwardBuilder.PKIXCertComparator.compare()";
        private final Set trustedSubjectDNs;

        PKIXCertComparator(Set set) {
            this.trustedSubjectDNs = set;
        }

        public int compare(Object object, Object object2) {
            int n;
            int n2;
            int n3;
            X500Principal x500Principal;
            X509Certificate x509Certificate = (X509Certificate)object;
            X509Certificate x509Certificate2 = (X509Certificate)object2;
            X500Principal x500Principal2 = x509Certificate.getIssuerX500Principal();
            X500Principal x500Principal3 = x509Certificate2.getIssuerX500Principal();
            X500Name x500Name = X500Name.asX500Name(x500Principal2);
            X500Name x500Name2 = X500Name.asX500Name(x500Principal3);
            if (debug != null) {
                debug.println("ForwardBuilder.PKIXCertComparator.compare() o1 Issuer:  " + x500Principal2.toString());
                debug.println("ForwardBuilder.PKIXCertComparator.compare() o2 Issuer:  " + x500Principal3.toString());
            }
            if (debug != null) {
                debug.println("ForwardBuilder.PKIXCertComparator.compare() MATCH TRUSTED SUBJECT TEST...");
            }
            Iterator iterator = this.trustedSubjectDNs.iterator();
            while (iterator.hasNext()) {
                x500Principal = (X500Principal)iterator.next();
                boolean bl = x500Principal2.equals(x500Principal);
                n3 = x500Principal3.equals(x500Principal);
                if (bl && n3 != 0) {
                    if (debug != null) {
                        debug.println("ForwardBuilder.PKIXCertComparator.compare() m1 && m2; RETURN 0");
                    }
                    return 0;
                }
                if (bl) {
                    if (debug != null) {
                        debug.println("ForwardBuilder.PKIXCertComparator.compare() m1; RETURN -1");
                    }
                    return -1;
                }
                if (n3 == 0) continue;
                if (debug != null) {
                    debug.println("ForwardBuilder.PKIXCertComparator.compare() m2; RETURN 1");
                }
                return 1;
            }
            if (debug != null) {
                debug.println("ForwardBuilder.PKIXCertComparator.compare() NAMING DESCENDANT TEST...");
            }
            iterator = this.trustedSubjectDNs.iterator();
            while (iterator.hasNext()) {
                x500Principal = (X500Principal)iterator.next();
                X500Name x500Name3 = X500Name.asX500Name(x500Principal);
                try {
                    n3 = Builder.distance(x500Name3, x500Name);
                }
                catch (IOException iOException) {
                    n3 = -1;
                }
                try {
                    n2 = Builder.distance(x500Name3, x500Name2);
                }
                catch (IOException iOException) {
                    n2 = -1;
                }
                if (debug != null) {
                    debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceTto1: " + n3);
                    debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceTto2: " + n2);
                }
                if (n3 <= 0 && n2 <= 0) continue;
                if (debug != null) {
                    debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceTto1 > 0 || distanceTto2 > 0...");
                }
                if (n3 == n2) {
                    if (debug != null) {
                        debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceTto1 == distanceTto2; RETURN 0");
                    }
                    return 0;
                }
                if (n3 > 0 && n2 <= 0) {
                    if (debug != null) {
                        debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceTto1 > 0 && distanceTto2 <= 0); RETURN -1");
                    }
                    return -1;
                }
                if (n3 <= 0 && n2 > 0) {
                    if (debug != null) {
                        debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceTto1 <= 0 && distanceTto2 > 0; RETURN 1");
                    }
                    return 1;
                }
                if (n3 < n2) {
                    if (debug != null) {
                        debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceTto1 < distance Tto2; RETURN -1");
                    }
                    return -1;
                }
                if (debug != null) {
                    debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceTto1 >= distanceTto2; RETURN 1");
                }
                return 1;
            }
            if (debug != null) {
                debug.println("ForwardBuilder.PKIXCertComparator.compare() NAMING ANCESTOR TEST...");
            }
            iterator = this.trustedSubjectDNs.iterator();
            while (iterator.hasNext()) {
                x500Principal = (X500Principal)iterator.next();
                X500Name x500Name4 = X500Name.asX500Name(x500Principal);
                n3 = 0;
                n2 = 0;
                try {
                    n3 = Builder.distance(x500Name4, x500Name);
                }
                catch (IOException iOException) {
                    n3 = Integer.MAX_VALUE;
                }
                try {
                    n2 = Builder.distance(x500Name4, x500Name2);
                }
                catch (IOException iOException) {
                    n2 = Integer.MAX_VALUE;
                }
                if (debug != null) {
                    debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceTto1: " + n3);
                    debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceTto2: " + n2);
                }
                if (n3 >= 0 && n2 >= 0) continue;
                if (debug != null) {
                    debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceTto1 < 0 || distanceTto2 < 0...");
                }
                if (n3 == n2) {
                    if (debug != null) {
                        debug.println("ForwardBuilder.PKIXCertComparator.compare() distance==; RETURN 0");
                    }
                    return 0;
                }
                if (n3 < 0 && n2 >= 0) {
                    if (debug != null) {
                        debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceTto1 < 0 && distanceTto2 >= 0; RETURN -1");
                    }
                    return -1;
                }
                if (n3 >= 0 && n2 < 0) {
                    if (debug != null) {
                        debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceTto1 >= 0 && distanceTto2 < 0; RETURN 1");
                    }
                    return 1;
                }
                if (n3 > n2) {
                    if (debug != null) {
                        debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceTto1 > distanceTto2; RETURN -1");
                    }
                    return -1;
                }
                if (debug != null) {
                    debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceTto1 <= distanceTto2; RETURN 1");
                }
                return 1;
            }
            if (debug != null) {
                debug.println("ForwardBuilder.PKIXCertComparator.compare() SAME NAMESPACE AS TRUSTED TEST...");
            }
            iterator = this.trustedSubjectDNs.iterator();
            while (iterator.hasNext()) {
                x500Principal = (X500Principal)iterator.next();
                X500Name x500Name5 = X500Name.asX500Name(x500Principal);
                X500Name x500Name6 = x500Name5.commonAncestor(x500Name);
                X500Name x500Name7 = x500Name5.commonAncestor(x500Name2);
                if (debug != null) {
                    debug.println("ForwardBuilder.PKIXCertComparator.compare() tAo1: " + String.valueOf(x500Name6));
                    debug.println("ForwardBuilder.PKIXCertComparator.compare() tAo2: " + String.valueOf(x500Name7));
                }
                if (x500Name6 == null && x500Name7 == null) continue;
                if (debug != null) {
                    debug.println("ForwardBuilder.PKIXCertComparator.compare() tAo1 != null || tAo2 != null...");
                }
                if (x500Name6 != null && x500Name7 != null) {
                    int n4;
                    block73: {
                        block72: {
                            if (debug != null) {
                                debug.println("ForwardBuilder.PKIXCertComparator.compare() tAo1 != null && tAo2 != null...");
                            }
                            n4 = Integer.MAX_VALUE;
                            n = Integer.MAX_VALUE;
                            try {
                                n4 = Builder.hops(x500Name5, x500Name);
                            }
                            catch (IOException iOException) {
                                if (debug == null) break block72;
                                debug.println("ForwardBuilder.PKIXCertComparator.compare() exception in Builder.hops(tSubject, cIssuer1)");
                                iOException.printStackTrace();
                            }
                        }
                        try {
                            n = Builder.hops(x500Name5, x500Name2);
                        }
                        catch (IOException iOException) {
                            if (debug == null) break block73;
                            debug.println("ForwardBuilder.PKIXCertComparator.compare() exception in Builder.hops(tSubject, cIssuer2)");
                            iOException.printStackTrace();
                        }
                    }
                    if (debug != null) {
                        debug.println("ForwardBuilder.PKIXCertComparator.compare() hopsTto1: " + n4);
                        debug.println("ForwardBuilder.PKIXCertComparator.compare() hopsTto2: " + n);
                    }
                    if (n4 == n) {
                        if (debug == null) continue;
                        debug.println("ForwardBuilder.PKIXCertComparator.compare() hopsTto1 == hopsTto2; continue");
                        continue;
                    }
                    if (n4 > n) {
                        if (debug != null) {
                            debug.println("ForwardBuilder.PKIXCertComparator.compare() hopsTto1 > hopsTto2; RETURN 1");
                        }
                        return 1;
                    }
                    if (debug != null) {
                        debug.println("ForwardBuilder.PKIXCertComparator.compare() hopsTto1 < hopsTto2; RETURN -1");
                    }
                    return -1;
                }
                if (x500Name6 == null) {
                    if (debug != null) {
                        debug.println("ForwardBuilder.PKIXCertComparator.compare() tA01 == null; RETURN 1");
                    }
                    return 1;
                }
                if (debug != null) {
                    debug.println("ForwardBuilder.PKIXCertComparator.compare() tA02 == null; RETURN -1");
                }
                return -1;
            }
            if (debug != null) {
                debug.println("ForwardBuilder.PKIXCertComparator.compare() CERT ISSUER/SUBJECT COMPARISON TEST...");
            }
            x500Principal = x509Certificate.getSubjectX500Principal();
            X500Principal x500Principal4 = x509Certificate2.getSubjectX500Principal();
            X500Name x500Name8 = X500Name.asX500Name(x500Principal);
            X500Name x500Name9 = X500Name.asX500Name(x500Principal4);
            if (debug != null) {
                debug.println("ForwardBuilder.PKIXCertComparator.compare() o1 Subject: " + x500Principal.toString());
                debug.println("ForwardBuilder.PKIXCertComparator.compare() o2 Subject: " + x500Principal4.toString());
            }
            int n5 = 0;
            n = 0;
            try {
                n5 = Builder.distance(x500Name8, x500Name);
            }
            catch (IOException iOException) {
                n5 = Integer.MAX_VALUE;
            }
            try {
                n = Builder.distance(x500Name9, x500Name2);
            }
            catch (IOException iOException) {
                n = Integer.MAX_VALUE;
            }
            if (debug != null) {
                debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceStoI1: " + n5);
                debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceStoI2: " + n);
            }
            if (n > n5) {
                if (debug != null) {
                    debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceStoI2 > distanceStoI1; RETURN -1");
                }
                return -1;
            }
            if (n < n5) {
                if (debug != null) {
                    debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceStoI2 < distanceStoI1; RETURN 1");
                }
                return 1;
            }
            if (debug != null) {
                debug.println("ForwardBuilder.PKIXCertComparator.compare() no tests matched; RETURN 0");
            }
            return 0;
        }
    }
}

