/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.cert;

import com.sun.security.cert.CertPathBuilderResult;
import com.sun.security.cert.PKIXCertPathValidatorResult;
import com.sun.security.cert.PolicyNode;
import com.sun.security.cert.TrustAnchor;
import java.security.PublicKey;
import java.security.cert.CertPath;

public class PKIXCertPathBuilderResult
extends PKIXCertPathValidatorResult
implements CertPathBuilderResult {
    private CertPath certPath;

    public PKIXCertPathBuilderResult(CertPath certPath, TrustAnchor trustAnchor, PolicyNode policyNode, PublicKey publicKey) {
        super(trustAnchor, policyNode, publicKey);
        if (certPath == null) {
            throw new NullPointerException("certPath must be non-null");
        }
        this.certPath = certPath;
    }

    public CertPath getCertPath() {
        return this.certPath;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PKIXCertPathBuilderResult: [\n");
        stringBuffer.append("  Certification Path: " + this.certPath + "\n");
        stringBuffer.append("  Trust Anchor: " + this.getTrustAnchor().toString() + "\n");
        stringBuffer.append("  Policy Tree: " + String.valueOf(this.getPolicyTree()) + "\n");
        stringBuffer.append("  Subject Public Key: " + this.getPublicKey() + "\n");
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

