/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import com.sun.security.cert.CRLSelector;
import com.sun.security.cert.CertSelector;
import com.sun.security.cert.CertStoreException;
import com.sun.security.cert.CertStoreParameters;
import com.sun.security.cert.CertStoreSpi;
import com.sun.security.cert.CollectionCertStoreParameters;
import com.sun.security.cert.X509CRLSelector;
import com.sun.security.cert.X509CertSelector;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import sun.security.provider.certpath.CertPathHelper;

public class IndexedCollectionCertStore
extends CertStoreSpi {
    private Map certSubjects;
    private Map crlIssuers;
    private Set otherCertificates;
    private Set otherCRLs;

    public IndexedCollectionCertStore(CertStoreParameters certStoreParameters) throws InvalidAlgorithmParameterException {
        super(certStoreParameters);
        if (!(certStoreParameters instanceof CollectionCertStoreParameters)) {
            throw new InvalidAlgorithmParameterException("parameters must be CollectionCertStoreParameters");
        }
        Collection collection = ((CollectionCertStoreParameters)certStoreParameters).getCollection();
        if (collection == null) {
            throw new InvalidAlgorithmParameterException("Collection must not be null");
        }
        this.buildIndex(collection);
    }

    private void buildIndex(Collection collection) {
        this.certSubjects = new HashMap();
        this.crlIssuers = new HashMap();
        this.otherCertificates = null;
        this.otherCRLs = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof X509Certificate) {
                this.indexCertificate((X509Certificate)e);
                continue;
            }
            if (e instanceof X509CRL) {
                this.indexCRL((X509CRL)e);
                continue;
            }
            if (e instanceof Certificate) {
                if (this.otherCertificates == null) {
                    this.otherCertificates = new HashSet();
                }
                this.otherCertificates.add(e);
                continue;
            }
            if (!(e instanceof CRL)) continue;
            if (this.otherCRLs == null) {
                this.otherCRLs = new HashSet();
            }
            this.otherCRLs.add(e);
        }
        if (this.otherCertificates == null) {
            this.otherCertificates = Collections.EMPTY_SET;
        }
        if (this.otherCRLs == null) {
            this.otherCRLs = Collections.EMPTY_SET;
        }
    }

    private void indexCertificate(X509Certificate x509Certificate) {
        X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
        X509Certificate x509Certificate2 = this.certSubjects.put(x500Principal, x509Certificate);
        if (x509Certificate2 != null) {
            if (x509Certificate2 instanceof X509Certificate) {
                if (x509Certificate.equals(x509Certificate2)) {
                    return;
                }
                ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>(2);
                arrayList.add(x509Certificate);
                arrayList.add(x509Certificate2);
                this.certSubjects.put(x500Principal, arrayList);
            } else {
                List list = (List)((Object)x509Certificate2);
                if (!list.contains(x509Certificate)) {
                    list.add(x509Certificate);
                }
                this.certSubjects.put(x500Principal, list);
            }
        }
    }

    private void indexCRL(X509CRL x509CRL) {
        X500Principal x500Principal = x509CRL.getIssuerX500Principal();
        X509CRL x509CRL2 = this.crlIssuers.put(x500Principal, x509CRL);
        if (x509CRL2 != null) {
            if (x509CRL2 instanceof X509CRL) {
                if (x509CRL.equals(x509CRL2)) {
                    return;
                }
                ArrayList<X509CRL> arrayList = new ArrayList<X509CRL>(2);
                arrayList.add(x509CRL);
                arrayList.add(x509CRL2);
                this.crlIssuers.put(x500Principal, arrayList);
            } else {
                List list = (List)((Object)x509CRL2);
                if (!list.contains(x509CRL)) {
                    list.add(x509CRL);
                }
                this.crlIssuers.put(x500Principal, list);
            }
        }
    }

    public Collection engineGetCertificates(CertSelector certSelector) throws CertStoreException {
        if (certSelector == null) {
            HashSet hashSet = new HashSet();
            this.matchX509Certs(new X509CertSelector(), hashSet);
            hashSet.addAll(this.otherCertificates);
            return hashSet;
        }
        if (!(certSelector instanceof X509CertSelector)) {
            HashSet<Certificate> hashSet = new HashSet<Certificate>();
            this.matchX509Certs(certSelector, hashSet);
            Iterator iterator = this.otherCertificates.iterator();
            while (iterator.hasNext()) {
                Certificate certificate = (Certificate)iterator.next();
                if (!certSelector.match(certificate)) continue;
                hashSet.add(certificate);
            }
            return hashSet;
        }
        if (this.certSubjects.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        X509CertSelector x509CertSelector = (X509CertSelector)certSelector;
        X509Certificate x509Certificate = x509CertSelector.getCertificate();
        X500Principal x500Principal = x509Certificate != null ? x509Certificate.getSubjectX500Principal() : CertPathHelper.getSubject(x509CertSelector);
        if (x500Principal != null) {
            Object v = this.certSubjects.get(x500Principal);
            if (v == null) {
                return Collections.EMPTY_SET;
            }
            if (v instanceof X509Certificate) {
                X509Certificate x509Certificate2 = (X509Certificate)v;
                if (x509CertSelector.match(x509Certificate2)) {
                    return Collections.singleton(x509Certificate2);
                }
                return Collections.EMPTY_SET;
            }
            List list = (List)v;
            HashSet<X509Certificate> hashSet = new HashSet<X509Certificate>(16);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                X509Certificate x509Certificate3 = (X509Certificate)iterator.next();
                if (!x509CertSelector.match(x509Certificate3)) continue;
                hashSet.add(x509Certificate3);
            }
            return hashSet;
        }
        HashSet hashSet = new HashSet(16);
        this.matchX509Certs(x509CertSelector, hashSet);
        return hashSet;
    }

    private void matchX509Certs(CertSelector certSelector, Collection collection) {
        Iterator iterator = this.certSubjects.values().iterator();
        while (iterator.hasNext()) {
            Object object;
            Object v = iterator.next();
            if (v instanceof X509Certificate) {
                object = (X509Certificate)v;
                if (!certSelector.match((Certificate)object)) continue;
                collection.add(object);
                continue;
            }
            object = (List)v;
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                X509Certificate x509Certificate = (X509Certificate)iterator2.next();
                if (!certSelector.match(x509Certificate)) continue;
                collection.add(x509Certificate);
            }
        }
    }

    public Collection engineGetCRLs(CRLSelector cRLSelector) throws CertStoreException {
        if (cRLSelector == null) {
            HashSet hashSet = new HashSet();
            this.matchX509CRLs(new X509CRLSelector(), hashSet);
            hashSet.addAll(this.otherCRLs);
            return hashSet;
        }
        if (!(cRLSelector instanceof X509CRLSelector)) {
            HashSet<CRL> hashSet = new HashSet<CRL>();
            this.matchX509CRLs(cRLSelector, hashSet);
            Iterator iterator = this.otherCRLs.iterator();
            while (iterator.hasNext()) {
                CRL cRL = (CRL)iterator.next();
                if (!cRLSelector.match(cRL)) continue;
                hashSet.add(cRL);
            }
            return hashSet;
        }
        if (this.crlIssuers.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        X509CRLSelector x509CRLSelector = (X509CRLSelector)cRLSelector;
        Collection collection = CertPathHelper.getIssuers(x509CRLSelector);
        if (collection != null) {
            HashSet<Object> hashSet = new HashSet<Object>(16);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object object;
                X500Principal x500Principal = (X500Principal)iterator.next();
                Object v = this.crlIssuers.get(x500Principal);
                if (v == null) continue;
                if (v instanceof X509CRL) {
                    object = (X509CRL)v;
                    if (!x509CRLSelector.match((CRL)object)) continue;
                    hashSet.add(object);
                    continue;
                }
                object = (List)v;
                Iterator iterator2 = object.iterator();
                while (iterator2.hasNext()) {
                    X509CRL x509CRL = (X509CRL)iterator2.next();
                    if (!x509CRLSelector.match(x509CRL)) continue;
                    hashSet.add(x509CRL);
                }
            }
            return hashSet;
        }
        HashSet hashSet = new HashSet(16);
        this.matchX509CRLs(x509CRLSelector, hashSet);
        return hashSet;
    }

    private void matchX509CRLs(CRLSelector cRLSelector, Collection collection) {
        Iterator iterator = this.crlIssuers.values().iterator();
        while (iterator.hasNext()) {
            Object object;
            Object v = iterator.next();
            if (v instanceof X509CRL) {
                object = (X509CRL)v;
                if (!cRLSelector.match((CRL)object)) continue;
                collection.add(object);
                continue;
            }
            object = (List)v;
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                X509CRL x509CRL = (X509CRL)iterator2.next();
                if (!cRLSelector.match(x509CRL)) continue;
                collection.add(x509CRL);
            }
        }
    }
}

