/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import com.sun.security.cert.CRLSelector;
import com.sun.security.cert.CertPathValidatorException;
import com.sun.security.cert.CertStore;
import com.sun.security.cert.PKIXCertPathChecker;
import com.sun.security.cert.X509CRLSelector;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import sun.security.provider.certpath.AlgorithmChecker;
import sun.security.provider.certpath.BasicChecker;
import sun.security.provider.certpath.CertPathHelper;
import sun.security.provider.certpath.DistributionPointFetcher;
import sun.security.util.Debug;
import sun.security.x509.KeyUsageExtension;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.X509CRLEntryImpl;

class CrlRevocationChecker
extends PKIXCertPathChecker {
    private static final Debug debug = Debug.getInstance("certpath");
    private final PublicKey mInitPubKey;
    private final List mStores;
    private final String mSigProvider;
    private final Date mCurrentTime;
    private PublicKey mPrevPubKey;
    private boolean mCRLSignFlag;
    private HashSet mPossibleCRLs;
    private HashSet mApprovedCRLs;

    CrlRevocationChecker(PublicKey publicKey, List list, String string, Date date) throws CertPathValidatorException {
        this.mInitPubKey = publicKey;
        this.mStores = list;
        this.mSigProvider = string;
        this.mCurrentTime = date != null ? date : new Date();
        this.init(false);
    }

    public void init(boolean bl) throws CertPathValidatorException {
        if (bl) {
            throw new CertPathValidatorException("forward checking not supported");
        }
        this.mPrevPubKey = this.mInitPubKey;
        this.mCRLSignFlag = true;
    }

    public boolean isForwardCheckingSupported() {
        return false;
    }

    public Set getSupportedExtensions() {
        return null;
    }

    public void check(Certificate certificate, Collection collection) throws CertPathValidatorException {
        X509Certificate x509Certificate = (X509Certificate)certificate;
        this.verifyRevocationStatus(x509Certificate, this.mPrevPubKey, this.mCRLSignFlag);
        PublicKey publicKey = x509Certificate.getPublicKey();
        if (publicKey instanceof DSAPublicKey && ((DSAPublicKey)publicKey).getParams() == null) {
            publicKey = BasicChecker.makeInheritedParamsKey(publicKey, this.mPrevPubKey);
        }
        this.mPrevPubKey = publicKey;
        this.mCRLSignFlag = this.certCanSignCrl(x509Certificate);
    }

    public boolean check(X509Certificate x509Certificate, PublicKey publicKey, boolean bl) throws CertPathValidatorException {
        this.verifyRevocationStatus(x509Certificate, publicKey, bl);
        return this.certCanSignCrl(x509Certificate);
    }

    public boolean certCanSignCrl(X509Certificate x509Certificate) {
        try {
            boolean[] blArray = x509Certificate.getKeyUsage();
            if (blArray != null) {
                KeyUsageExtension keyUsageExtension = new KeyUsageExtension(blArray);
                Boolean bl = (Boolean)keyUsageExtension.get("crl_sign");
                return bl != false;
            }
            return true;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.println("CrlRevocationChecker.certCanSignCRL() unexpected exception");
                exception.printStackTrace();
            }
            return false;
        }
    }

    private void verifyRevocationStatus(X509Certificate x509Certificate, PublicKey publicKey, boolean bl) throws CertPathValidatorException {
        Object object;
        Iterator iterator;
        String string = "revocation status";
        if (debug != null) {
            debug.println("CrlRevocationChecker.verifyRevocationStatus() ---checking " + string + "...");
        }
        if (!bl) {
            throw new CertPathValidatorException("cert can't vouch for CRL");
        }
        X500Principal x500Principal = x509Certificate.getIssuerX500Principal();
        this.mPossibleCRLs = new HashSet();
        this.mApprovedCRLs = new HashSet();
        try {
            iterator = new X509CRLSelector();
            ((X509CRLSelector)((Object)iterator)).setCertificateChecking(x509Certificate);
            ((X509CRLSelector)((Object)iterator)).setDateAndTime(this.mCurrentTime);
            CertPathHelper.addIssuer((X509CRLSelector)((Object)iterator), x500Principal);
            object = this.mStores.iterator();
            while (object.hasNext()) {
                this.mPossibleCRLs.addAll(((CertStore)object.next()).getCRLs((CRLSelector)((Object)iterator)));
            }
            DistributionPointFetcher distributionPointFetcher = DistributionPointFetcher.getInstance();
            this.mPossibleCRLs.addAll(distributionPointFetcher.getCRLs((CRLSelector)((Object)iterator)));
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.println("CrlRevocationChecker.verifyRevocationStatus() unexpected exception: " + exception.getMessage());
                exception.printStackTrace();
            }
            throw new CertPathValidatorException(exception);
        }
        if (this.mPossibleCRLs.isEmpty()) {
            throw new CertPathValidatorException(string + " check failed: no CRL found");
        }
        if (debug != null) {
            debug.println("CrlRevocationChecker.verifyRevocationStatus() crls.size() = " + this.mPossibleCRLs.size());
        }
        iterator = this.mPossibleCRLs.iterator();
        while (iterator.hasNext()) {
            object = (X509CRL)iterator.next();
            if (!this.verifyPossibleCRL((X509CRL)object, x500Principal, publicKey)) continue;
            this.mApprovedCRLs.add(object);
        }
        if (this.mApprovedCRLs.isEmpty()) {
            throw new CertPathValidatorException("no possible CRLs");
        }
        if (debug != null) {
            debug.println("starting the final sweep...");
        }
        iterator = this.mApprovedCRLs.iterator();
        object = x509Certificate.getSerialNumber();
        if (debug != null) {
            debug.println("CrlRevocationChecker.verifyRevocationStatus cert SN: " + ((BigInteger)object).toString());
        }
        boolean bl2 = false;
        while (iterator.hasNext()) {
            Set<String> set;
            X509CRL x509CRL = (X509CRL)iterator.next();
            X509CRLEntry x509CRLEntry = x509CRL.getRevokedCertificate((BigInteger)object);
            if (x509CRLEntry == null) continue;
            if (debug != null) {
                debug.println("CrlRevocationChecker.verifyRevocationStatus CRL entry: " + x509CRLEntry.toString());
            }
            int n = 0;
            try {
                set = X509CRLEntryImpl.toImpl(x509CRLEntry);
                Integer n2 = ((X509CRLEntryImpl)((Object)set)).getReasonCode();
                n = n2 == null ? 0 : n2;
            }
            catch (Exception exception) {
                throw new CertPathValidatorException(exception);
            }
            boolean bl3 = bl2 = n == 6;
            if (!bl2 && n != 8) {
                throw new CertPathValidatorException("Certificate has been revoked, reason: " + CrlRevocationChecker.reasonToString(n));
            }
            set = x509CRLEntry.getCriticalExtensionOIDs();
            if (set == null || set.isEmpty()) continue;
            set.remove(PKIXExtensions.ReasonCode_Id.toString());
            if (set.isEmpty()) continue;
            throw new CertPathValidatorException("Unrecognized critical extension(s) in revoked CRL entry: " + set);
        }
        if (bl2) {
            throw new CertPathValidatorException("Certificate is on hold");
        }
    }

    private static String reasonToString(int n) {
        switch (n) {
            case 0: {
                return "unspecified";
            }
            case 1: {
                return "key compromise";
            }
            case 2: {
                return "CA compromise";
            }
            case 3: {
                return "affiliation changed";
            }
            case 4: {
                return "superseded";
            }
            case 5: {
                return "cessation of operation";
            }
            case 6: {
                return "certificate hold";
            }
            case 8: {
                return "remove from CRL";
            }
        }
        return "unrecognized reason code";
    }

    private boolean verifyPossibleCRL(X509CRL x509CRL, X500Principal x500Principal, PublicKey publicKey) throws CertPathValidatorException {
        try {
            AlgorithmChecker.check(x509CRL);
        }
        catch (CertPathValidatorException certPathValidatorException) {
            if (debug != null) {
                debug.println("CRL signature algorithm check failed: " + certPathValidatorException);
            }
            return false;
        }
        if (!x509CRL.getIssuerX500Principal().equals(x500Principal)) {
            if (debug != null) {
                debug.println("CRL issuer does not match cert issuer");
            }
            return false;
        }
        try {
            x509CRL.verify(publicKey, this.mSigProvider);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.println("CRL signature failed to verify");
                exception.printStackTrace();
            }
            return false;
        }
        Date date = x509CRL.getNextUpdate();
        if (date != null && date.before(this.mCurrentTime)) {
            if (debug != null) {
                debug.println("discarding stale CRL (nextUpdate is before required validation time)");
            }
            return false;
        }
        Set<String> set = x509CRL.getCriticalExtensionOIDs();
        if (set != null && !set.isEmpty()) {
            if (debug != null) {
                Iterator<String> iterator = set.iterator();
                while (iterator.hasNext()) {
                    debug.println(iterator.next());
                }
            }
            throw new CertPathValidatorException("Unrecognized critical extension(s) in CRL: " + set);
        }
        return true;
    }
}

