/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.cert;

import com.sun.security.cert.CertPathParameters;
import com.sun.security.cert.CertSelector;
import com.sun.security.cert.CertStore;
import com.sun.security.cert.PKIXCertPathChecker;
import com.sun.security.cert.TrustAnchor;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class PKIXParameters
implements CertPathParameters {
    private Set unmodTrustAnchors;
    private Date date;
    private List certPathCheckers;
    private String sigProvider;
    private boolean revocationEnabled = true;
    private Set unmodInitialPolicies;
    private boolean explicitPolicyRequired = false;
    private boolean policyMappingInhibited = false;
    private boolean anyPolicyInhibited = false;
    private boolean policyQualifiersRejected = true;
    private List certStores;
    private CertSelector certSelector;

    public PKIXParameters(Set set) throws InvalidAlgorithmParameterException {
        this.setTrustAnchors(set);
        this.unmodInitialPolicies = Collections.unmodifiableSet(new HashSet());
        this.certPathCheckers = new ArrayList();
        this.certStores = new ArrayList();
    }

    public PKIXParameters(KeyStore keyStore) throws KeyStoreException, InvalidAlgorithmParameterException {
        if (keyStore == null) {
            throw new NullPointerException("the keystore parameter must be non-null");
        }
        HashSet<TrustAnchor> hashSet = new HashSet<TrustAnchor>();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            Certificate certificate;
            String string = enumeration.nextElement();
            if (!keyStore.isCertificateEntry(string) || !((certificate = keyStore.getCertificate(string)) instanceof X509Certificate)) continue;
            hashSet.add(new TrustAnchor((X509Certificate)certificate, null));
        }
        this.setTrustAnchors(hashSet);
        this.unmodInitialPolicies = Collections.unmodifiableSet(new HashSet());
        this.certPathCheckers = new ArrayList();
        this.certStores = new ArrayList();
    }

    public Set getTrustAnchors() {
        return this.unmodTrustAnchors;
    }

    public void setTrustAnchors(Set set) throws InvalidAlgorithmParameterException {
        if (set == null) {
            throw new NullPointerException("the trustAnchors parameters must be non-null");
        }
        if (set.isEmpty()) {
            throw new InvalidAlgorithmParameterException("the trustAnchors parameter must be non-empty");
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof TrustAnchor) continue;
            throw new ClassCastException("all elements of set must be of type java.security.cert.TrustAnchor");
        }
        this.unmodTrustAnchors = Collections.unmodifiableSet(new HashSet(set));
    }

    public Set getInitialPolicies() {
        return this.unmodInitialPolicies;
    }

    public void setInitialPolicies(Set set) {
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() instanceof String) continue;
                throw new ClassCastException("all elements of set must be of type java.lang.String");
            }
            this.unmodInitialPolicies = Collections.unmodifiableSet(new HashSet(set));
        } else {
            this.unmodInitialPolicies = Collections.unmodifiableSet(new HashSet());
        }
    }

    public void setCertStores(List list) {
        if (list == null) {
            this.certStores = new ArrayList();
        } else {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() instanceof CertStore) continue;
                throw new ClassCastException("all elements of list must be of type java.security.cert.CertStore");
            }
            this.certStores = new ArrayList(list);
        }
    }

    public void addCertStore(CertStore certStore) {
        if (certStore != null) {
            this.certStores.add(certStore);
        }
    }

    public List getCertStores() {
        return Collections.unmodifiableList(new ArrayList(this.certStores));
    }

    public void setRevocationEnabled(boolean bl) {
        this.revocationEnabled = bl;
    }

    public boolean isRevocationEnabled() {
        return this.revocationEnabled;
    }

    public void setExplicitPolicyRequired(boolean bl) {
        this.explicitPolicyRequired = bl;
    }

    public boolean isExplicitPolicyRequired() {
        return this.explicitPolicyRequired;
    }

    public void setPolicyMappingInhibited(boolean bl) {
        this.policyMappingInhibited = bl;
    }

    public boolean isPolicyMappingInhibited() {
        return this.policyMappingInhibited;
    }

    public void setAnyPolicyInhibited(boolean bl) {
        this.anyPolicyInhibited = bl;
    }

    public boolean isAnyPolicyInhibited() {
        return this.anyPolicyInhibited;
    }

    public void setPolicyQualifiersRejected(boolean bl) {
        this.policyQualifiersRejected = bl;
    }

    public boolean getPolicyQualifiersRejected() {
        return this.policyQualifiersRejected;
    }

    public Date getDate() {
        if (this.date == null) {
            return null;
        }
        return (Date)this.date.clone();
    }

    public void setDate(Date date) {
        if (date != null) {
            this.date = (Date)date.clone();
        } else {
            date = null;
        }
    }

    public void setCertPathCheckers(List list) {
        if (list != null) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                PKIXCertPathChecker pKIXCertPathChecker = (PKIXCertPathChecker)iterator.next();
                arrayList.add(pKIXCertPathChecker.clone());
            }
            this.certPathCheckers = arrayList;
        } else {
            this.certPathCheckers = new ArrayList();
        }
    }

    public List getCertPathCheckers() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = this.certPathCheckers.iterator();
        while (iterator.hasNext()) {
            PKIXCertPathChecker pKIXCertPathChecker = (PKIXCertPathChecker)iterator.next();
            arrayList.add(pKIXCertPathChecker.clone());
        }
        return Collections.unmodifiableList(arrayList);
    }

    public void addCertPathChecker(PKIXCertPathChecker pKIXCertPathChecker) {
        if (pKIXCertPathChecker != null) {
            this.certPathCheckers.add(pKIXCertPathChecker.clone());
        }
    }

    public String getSigProvider() {
        return this.sigProvider;
    }

    public void setSigProvider(String string) {
        this.sigProvider = string;
    }

    public CertSelector getTargetCertConstraints() {
        if (this.certSelector != null) {
            return (CertSelector)this.certSelector.clone();
        }
        return null;
    }

    public void setTargetCertConstraints(CertSelector certSelector) {
        this.certSelector = certSelector != null ? (CertSelector)certSelector.clone() : null;
    }

    public Object clone() {
        try {
            Object object = super.clone();
            if (this.certStores != null) {
                this.certStores = new ArrayList(this.certStores);
            }
            if (this.certPathCheckers != null) {
                this.certPathCheckers = new ArrayList(this.certPathCheckers);
            }
            return object;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[\n");
        if (this.unmodTrustAnchors != null) {
            stringBuffer.append("  Trust Anchors: " + this.unmodTrustAnchors.toString() + "\n");
        }
        if (this.unmodInitialPolicies != null) {
            if (this.unmodInitialPolicies.isEmpty()) {
                stringBuffer.append("  Initial Policy OIDs: any\n");
            } else {
                stringBuffer.append("  Initial Policy OIDs: [" + this.unmodInitialPolicies.toString() + "]\n");
            }
        }
        stringBuffer.append("  Validity Date: " + String.valueOf(this.date) + "\n");
        stringBuffer.append("  Signature Provider: " + String.valueOf(this.sigProvider) + "\n");
        stringBuffer.append("  Default Revocation Enabled: " + this.revocationEnabled + "\n");
        stringBuffer.append("  Explicit Policy Required: " + this.explicitPolicyRequired + "\n");
        stringBuffer.append("  Policy Mapping Inhibited: " + this.policyMappingInhibited + "\n");
        stringBuffer.append("  Any Policy Inhibited: " + this.anyPolicyInhibited + "\n");
        stringBuffer.append("  Policy Qualifiers Rejected: " + this.policyQualifiersRejected + "\n");
        stringBuffer.append("  Target Cert Constraints: " + String.valueOf(this.certSelector) + "\n");
        if (this.certPathCheckers != null) {
            stringBuffer.append("  Certification Path Checkers: [" + this.certPathCheckers.toString() + "]\n");
        }
        if (this.certStores != null) {
            stringBuffer.append("  CertStores: [" + this.certStores.toString() + "]\n");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

