/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.SSLSessionImpl;
import com.sun.net.ssl.internal.ssl.SessionId;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import sun.misc.Cache;

final class SSLSessionContextImpl
implements SSLSessionContext {
    private Cache a = new Cache();
    private Cache b = new Cache();
    private int c = this.a();
    private long d = 86400000L;
    private static final Debug e = Debug.getInstance("ssl");

    SSLSessionContextImpl() {
    }

    public SSLSession getSession(byte[] byArray) {
        SSLSession sSLSession = (SSLSession)this.a.get((Object)new SessionId(byArray));
        return this.a(sSLSession);
    }

    public Enumeration getIds() {
        Vector<byte[]> vector = new Vector<byte[]>(this.a.size());
        Enumeration enumeration = this.a.keys();
        while (enumeration.hasMoreElements()) {
            SessionId sessionId = (SessionId)enumeration.nextElement();
            if (this.b((SSLSession)this.a.get((Object)sessionId))) continue;
            vector.addElement(sessionId.b());
        }
        return vector.elements();
    }

    public void setSessionTimeout(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.d = n * 1000;
    }

    public int getSessionTimeout() {
        return (int)(this.d / 1000L);
    }

    public void setSessionCacheSize(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.c = n;
        if (this.c != 0 && this.a.size() > this.c) {
            this.a(this.c);
        }
    }

    public int getSessionCacheSize() {
        return this.c;
    }

    SSLSessionImpl a(byte[] byArray) {
        return (SSLSessionImpl)this.getSession(byArray);
    }

    SSLSessionImpl a(String string, int n) {
        SSLSessionImpl sSLSessionImpl = (SSLSessionImpl)this.b.get((Object)this.b(string, n));
        return (SSLSessionImpl)this.a((SSLSession)sSLSessionImpl);
    }

    private String b(String string, int n) {
        return (string + ":" + String.valueOf(n)).toLowerCase();
    }

    void a(SSLSessionImpl sSLSessionImpl) {
        if (this.c != 0 && this.a.size() >= this.c) {
            this.a(this.c - 1);
        }
        this.a.put((Object)sSLSessionImpl.d(), (Object)sSLSessionImpl);
        this.b.put((Object)this.b(sSLSessionImpl.getPeerHost(), sSLSessionImpl.h()), (Object)sSLSessionImpl);
        sSLSessionImpl.a(this);
    }

    private void a(int n) {
        int n2 = this.a.size();
        if (n < 0) {
            return;
        }
        while (n2 > n) {
            SSLSessionImpl sSLSessionImpl = null;
            SSLSessionImpl sSLSessionImpl2 = null;
            if (e != null && Debug.isOn("sessioncache")) {
                System.out.println("exceeded cache limit of " + this.c);
            }
            int n3 = 0;
            Enumeration enumeration = this.a.elements();
            while (enumeration.hasMoreElements()) {
                try {
                    sSLSessionImpl2 = (SSLSessionImpl)enumeration.nextElement();
                }
                catch (NoSuchElementException noSuchElementException) {
                    break;
                }
                if (this.b(sSLSessionImpl2)) {
                    sSLSessionImpl = sSLSessionImpl2;
                    break;
                }
                if (sSLSessionImpl == null || sSLSessionImpl2.getLastAccessedTime() < sSLSessionImpl.getLastAccessedTime()) {
                    sSLSessionImpl = sSLSessionImpl2;
                }
                ++n3;
            }
            if (sSLSessionImpl != null && n3 > n) {
                if (e != null && Debug.isOn("sessioncache")) {
                    System.out.println("uncaching " + sSLSessionImpl);
                }
                sSLSessionImpl.invalidate();
            }
            n2 = --n3;
        }
    }

    void a(SessionId sessionId) {
        SSLSessionImpl sSLSessionImpl = (SSLSessionImpl)this.a.get((Object)sessionId);
        this.a.remove((Object)sessionId);
        this.b.remove((Object)this.b(sSLSessionImpl.getPeerHost(), sSLSessionImpl.h()));
    }

    private int a() {
        int n = 0;
        try {
            String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("javax.net.ssl.sessionCacheSize");
                }
            });
            n = string != null ? Integer.valueOf(string) : 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n > 0 ? n : 0;
    }

    SSLSession a(SSLSession sSLSession) {
        if (this.b(sSLSession)) {
            sSLSession.invalidate();
            return null;
        }
        return sSLSession;
    }

    boolean b(SSLSession sSLSession) {
        if (this.d == 0L) {
            return false;
        }
        return sSLSession != null && sSLSession.getCreationTime() + this.d <= System.currentTimeMillis();
    }
}

