/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import sun.security.pkcs.ParsingException;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AlgorithmId;

class MacData {
    private String a;
    private AlgorithmParameters b;
    private byte[] c;
    private byte[] d;
    private int e;
    private byte[] f = null;

    MacData(DerInputStream derInputStream) throws IOException, ParsingException {
        DerValue[] derValueArray = derInputStream.getSequence(2);
        DerInputStream derInputStream2 = new DerInputStream(derValueArray[0].toByteArray());
        DerValue[] derValueArray2 = derInputStream2.getSequence(2);
        AlgorithmId algorithmId = AlgorithmId.parse(derValueArray2[0]);
        this.a = algorithmId.getName();
        this.b = algorithmId.getParameters();
        this.c = derValueArray2[1].getOctetString();
        this.d = derValueArray[1].getOctetString();
        this.e = derValueArray.length > 2 ? derValueArray[2].getInteger() : 1;
    }

    MacData(String string, byte[] byArray, byte[] byArray2, int n) throws NoSuchAlgorithmException {
        if (string == null) {
            throw new NullPointerException("the algName parameter must be non-null");
        }
        AlgorithmId algorithmId = AlgorithmId.get(string);
        this.a = algorithmId.getName();
        this.b = algorithmId.getParameters();
        if (byArray == null) {
            throw new NullPointerException("the digest parameter must be non-null");
        }
        if (byArray.length == 0) {
            throw new IllegalArgumentException("the digest parameter must not be empty");
        }
        this.c = (byte[])byArray.clone();
        this.d = byArray2;
        this.e = n;
        this.f = null;
    }

    MacData(AlgorithmParameters algorithmParameters, byte[] byArray, byte[] byArray2, int n) throws NoSuchAlgorithmException {
        if (algorithmParameters == null) {
            throw new NullPointerException("the algParams parameter must be non-null");
        }
        AlgorithmId algorithmId = AlgorithmId.get(algorithmParameters);
        this.a = algorithmId.getName();
        this.b = algorithmId.getParameters();
        if (byArray == null) {
            throw new NullPointerException("the digest parameter must be non-null");
        }
        if (byArray.length == 0) {
            throw new IllegalArgumentException("the digest parameter must not be empty");
        }
        this.c = (byte[])byArray.clone();
        this.d = byArray2;
        this.e = n;
        this.f = null;
    }

    String a() {
        return this.a;
    }

    byte[] b() {
        return this.d;
    }

    int c() {
        return this.e;
    }

    byte[] d() {
        return this.c;
    }

    public byte[] getEncoded() throws NoSuchAlgorithmException, IOException {
        if (this.f != null) {
            return (byte[])this.f.clone();
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        DerOutputStream derOutputStream3 = new DerOutputStream();
        AlgorithmId algorithmId = AlgorithmId.get(this.a);
        algorithmId.encode(derOutputStream3);
        derOutputStream3.putOctetString(this.c);
        derOutputStream2.write((byte)48, derOutputStream3);
        derOutputStream2.putOctetString(this.d);
        derOutputStream2.putInteger(this.e);
        derOutputStream.write((byte)48, derOutputStream2);
        this.f = derOutputStream.toByteArray();
        return (byte[])this.f.clone();
    }
}

