/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.util.regex;

final class ASCII {
    static final int UPPER = 256;
    static final int LOWER = 512;
    static final int DIGIT = 1024;
    static final int SPACE = 2048;
    static final int PUNCT = 4096;
    static final int CNTRL = 8192;
    static final int BLANK = 16384;
    static final int HEX = 32768;
    static final int UNDER = 65536;
    static final int ASCII = 65280;
    static final int ALPHA = 768;
    static final int ALNUM = 1792;
    static final int GRAPH = 5888;
    static final int WORD = 67328;
    static final int XDIGIT = 32768;
    private static final int[] ctype = new int[]{8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 26624, 10240, 10240, 10240, 10240, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 18432, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 33792, 33793, 33794, 33795, 33796, 33797, 33798, 33799, 33800, 33801, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 33034, 33035, 33036, 33037, 33038, 33039, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 4096, 4096, 4096, 4096, 69632, 4096, 33290, 33291, 33292, 33293, 33294, 33295, 528, 529, 530, 531, 532, 533, 534, 535, 536, 537, 538, 539, 540, 541, 542, 543, 544, 545, 546, 547, 4096, 4096, 4096, 4096, 8192};

    ASCII() {
    }

    static int getType(int n) {
        return (n & 0xFFFFFF80) == 0 ? ctype[n] : 0;
    }

    static boolean isType(int n, int n2) {
        return (oracle.adfmf.util.regex.ASCII.getType(n) & n2) != 0;
    }

    static boolean isAscii(int n) {
        return (n & 0xFFFFFF80) == 0;
    }

    static boolean isAlpha(int n) {
        return oracle.adfmf.util.regex.ASCII.isType(n, 768);
    }

    static boolean isDigit(int n) {
        return (n - 48 | 57 - n) >= 0;
    }

    static boolean isAlnum(int n) {
        return oracle.adfmf.util.regex.ASCII.isType(n, 1792);
    }

    static boolean isGraph(int n) {
        return oracle.adfmf.util.regex.ASCII.isType(n, 5888);
    }

    static boolean isPrint(int n) {
        return (n - 32 | 126 - n) >= 0;
    }

    static boolean isPunct(int n) {
        return oracle.adfmf.util.regex.ASCII.isType(n, 4096);
    }

    static boolean isSpace(int n) {
        return oracle.adfmf.util.regex.ASCII.isType(n, 2048);
    }

    static boolean isHexDigit(int n) {
        return oracle.adfmf.util.regex.ASCII.isType(n, 32768);
    }

    static boolean isOctDigit(int n) {
        return (n - 48 | 55 - n) >= 0;
    }

    static boolean isCntrl(int n) {
        return oracle.adfmf.util.regex.ASCII.isType(n, 8192);
    }

    static boolean isLower(int n) {
        return (n - 97 | 122 - n) >= 0;
    }

    static boolean isUpper(int n) {
        return (n - 65 | 90 - n) >= 0;
    }

    static boolean isWord(int n) {
        return oracle.adfmf.util.regex.ASCII.isType(n, 67328);
    }

    static int toDigit(int n) {
        return ctype[n & 0x7F] & 0x3F;
    }

    static int toLower(int n) {
        return oracle.adfmf.util.regex.ASCII.isUpper(n) ? n + 32 : n;
    }

    static int toUpper(int n) {
        return oracle.adfmf.util.regex.ASCII.isLower(n) ? n - 32 : n;
    }
}

