/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.misc.iso8601;

import oracle.adfmf.misc.iso8601.Format;
import oracle.adfmf.misc.iso8601.FormatEntry;
import oracle.adfmf.misc.iso8601.NestedFormatEntry;
import oracle.adfmf.util.regex.Matcher;

class FormatEntryFrac
extends NestedFormatEntry {
    final long multiplier;

    FormatEntryFrac(FormatEntry formatEntry, long l) {
        this(formatEntry, l, false);
    }

    FormatEntryFrac(FormatEntry formatEntry, long l, boolean bl) {
        super(formatEntry, 2, formatEntry.name + "_Frac", "(" + formatEntry.pattern + ")" + "([\\.,][0-9]{1,})", formatEntry.format, bl);
        this.multiplier = l;
    }

    protected Format getFormat(String string) {
        Matcher matcher = this.getMatcher(string);
        if (!matcher.matches()) {
            return null;
        }
        int n = this.getEntryCaptureGroupOffset() + 1;
        String string2 = matcher.group(1);
        String string3 = matcher.group(n + 1);
        Long l = this._getTicksToAdd(string3);
        if (l == null) {
            return null;
        }
        Format format = this.entry.getFormat(string2);
        if (format == null) {
            return null;
        }
        long l2 = l;
        if (l2 == 0L) {
            return format;
        }
        return new Format(format.value, format.pattern, l2);
    }

    private static String _sanitizeFraction(String string) {
        return "." + string.substring(1);
    }

    private Long _getTicksToAdd(String string) {
        try {
            double d = Double.parseDouble(FormatEntryFrac._sanitizeFraction(string));
            return new Long((long)(d * (double)this.multiplier));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }
}

