/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.misc;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import oracle.adfmf.misc.iso8601.Format;
import oracle.adfmf.misc.iso8601.Parser;

public class ISO8601DateTimeUtil {
    private ISO8601DateTimeUtil() {
    }

    public static Date coerceToDate(Class clazz, String string) throws ParseException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
        Date date = ISO8601DateTimeUtil.parse(string);
        if (Date.class != clazz) {
            Constructor constructor = clazz.getConstructor(Long.TYPE);
            return (Date)constructor.newInstance(new Long(date.getTime()));
        }
        return date;
    }

    public static boolean isDateType(Class clazz) {
        return Date.class.isAssignableFrom(clazz);
    }

    public static Date parse(String string) throws ParseException {
        Format format = ISO8601DateTimeUtil._makeFormatInfo(string);
        if (format == null) {
            throw new ParseException("Unable to parse '" + string + "' - value must be in the ISO-8601 date-time format", -1);
        }
        Date date = new SimpleDateFormat(format.pattern).parse(format.value);
        if (format.ticks != 0L) {
            date = new Date(date.getTime() + format.ticks);
        }
        return date;
    }

    public static String format(Date date) {
        return ISO8601DateTimeUtil.format(date, null);
    }

    public static String format(Date date, String string) {
        String string2 = "";
        if (date != null) {
            SimpleDateFormat simpleDateFormat;
            int n;
            String string3 = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
            if (string != null) {
                if (string.equals("date")) {
                    string3 = "yyyy-MM-ddZ";
                } else if (string.equals("time")) {
                    string3 = "HH:mm:ss.SSSZ";
                }
            }
            if ((n = (string2 = (simpleDateFormat = new SimpleDateFormat(string3)).format(date)).length()) > 2) {
                string2 = string2.substring(0, n - 2) + ":" + string2.substring(n - 2);
            }
        }
        return string2;
    }

    private static Format _makeFormatInfo(String string) {
        int n = string.length();
        int n2 = string.indexOf(84);
        if (n2 < 0 || n2 + 1 >= n) {
            Format format = Parser.getDateFormat(string, true);
            if (format == null) {
                format = Parser.getTimeFormat(string);
            }
            return format;
        }
        String string2 = string.substring(0, n2);
        String string3 = string.substring(n2 + 1);
        Format format = Parser.getDateFormat(string2, false);
        if (format == null) {
            return null;
        }
        Format format2 = Parser.getTimeFormat(string3);
        if (format2 == null) {
            return null;
        }
        String string4 = format.value + " " + format2.value;
        String string5 = format.pattern + " " + format2.pattern;
        long l = format.ticks + format2.ticks;
        return new Format(string4, string5, l);
    }
}

