/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.tree.impl;

import de.odysseus.el.misc.LocalMessages;
import de.odysseus.el.tree.Tree;
import de.odysseus.el.tree.impl.Builder;
import de.odysseus.el.tree.impl.Scanner;
import de.odysseus.el.tree.impl.ast.AstBinary;
import de.odysseus.el.tree.impl.ast.AstBoolean;
import de.odysseus.el.tree.impl.ast.AstBracket;
import de.odysseus.el.tree.impl.ast.AstChoice;
import de.odysseus.el.tree.impl.ast.AstComposite;
import de.odysseus.el.tree.impl.ast.AstDot;
import de.odysseus.el.tree.impl.ast.AstEval;
import de.odysseus.el.tree.impl.ast.AstFunction;
import de.odysseus.el.tree.impl.ast.AstIdentifier;
import de.odysseus.el.tree.impl.ast.AstMethod;
import de.odysseus.el.tree.impl.ast.AstNested;
import de.odysseus.el.tree.impl.ast.AstNode;
import de.odysseus.el.tree.impl.ast.AstNull;
import de.odysseus.el.tree.impl.ast.AstNumber;
import de.odysseus.el.tree.impl.ast.AstParameters;
import de.odysseus.el.tree.impl.ast.AstProperty;
import de.odysseus.el.tree.impl.ast.AstString;
import de.odysseus.el.tree.impl.ast.AstText;
import de.odysseus.el.tree.impl.ast.AstUnary;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class Parser {
    private static final String EXPR_FIRST = Scanner.Symbol.codeToString(8) + "|" + Scanner.Symbol.codeToString(18) + "|" + Scanner.Symbol.codeToString(15) + "|" + Scanner.Symbol.codeToString(14) + "|" + Scanner.Symbol.codeToString(16) + "|" + Scanner.Symbol.codeToString(17) + "|" + Scanner.Symbol.codeToString(19) + "|" + Scanner.Symbol.codeToString(2) + "|" + Scanner.Symbol.codeToString(9) + "|" + Scanner.Symbol.codeToString(12) + "|" + Scanner.Symbol.codeToString(6);
    protected final Builder context;
    protected final Scanner scanner;
    private List identifiers = new Vector();
    private List functions = new Vector();
    private List lookahead = new Vector();
    private Scanner.Token token;
    private int position;
    protected Map extensions = new HashMap();

    public Parser(Builder builder, String string) {
        this.context = builder;
        this.scanner = this.createScanner(string);
    }

    protected Scanner createScanner(String string) {
        return new Scanner(string);
    }

    public void putExtensionHandler(Scanner.ExtensionToken extensionToken, ExtensionHandler extensionHandler) {
        if (this.extensions.isEmpty()) {
            this.extensions = new HashMap(16);
        }
        this.extensions.put(extensionToken, extensionHandler);
    }

    protected ExtensionHandler getExtensionHandler(Scanner.Token token) {
        return (ExtensionHandler)this.extensions.get(token);
    }

    protected Number parseInteger(String string) throws ParseException {
        try {
            return Long.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.fail(Scanner.Symbol.codeToString(14));
            return null;
        }
    }

    protected Number parseFloat(String string) throws ParseException {
        try {
            return Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.fail(Scanner.Symbol.codeToString(15));
            return null;
        }
    }

    protected AstBinary createAstBinary(AstNode astNode, AstNode astNode2, AstBinary.Operator operator) {
        return new AstBinary(astNode, astNode2, operator);
    }

    protected AstBracket createAstBracket(AstNode astNode, AstNode astNode2, boolean bl, boolean bl2) {
        return new AstBracket(astNode, astNode2, bl, bl2);
    }

    protected AstChoice createAstChoice(AstNode astNode, AstNode astNode2, AstNode astNode3) {
        return new AstChoice(astNode, astNode2, astNode3);
    }

    protected AstComposite createAstComposite(List list) {
        return new AstComposite(list);
    }

    protected AstDot createAstDot(AstNode astNode, String string, boolean bl) {
        return new AstDot(astNode, string, bl);
    }

    protected AstFunction createAstFunction(String string, int n, AstParameters astParameters) {
        return new AstFunction(string, n, astParameters, this.context.isEnabled(new Builder.Feature(Builder.Feature.VARARGS)));
    }

    protected AstIdentifier createAstIdentifier(String string, int n) {
        return new AstIdentifier(string, n);
    }

    protected AstMethod createAstMethod(AstProperty astProperty, AstParameters astParameters) {
        return new AstMethod(astProperty, astParameters);
    }

    protected AstUnary createAstUnary(AstNode astNode, AstUnary.Operator operator) {
        return new AstUnary(astNode, operator);
    }

    protected final List getFunctions() {
        return this.functions;
    }

    protected final List getIdentifiers() {
        return this.identifiers;
    }

    protected final Scanner.Token getToken() {
        return this.token;
    }

    protected void fail(String string) throws ParseException {
        throw new ParseException(this.position, "'" + this.token.getImage() + "'", string);
    }

    protected void fail(Scanner.Symbol symbol) throws ParseException {
        this.fail(symbol.toString());
    }

    protected final Scanner.Token lookahead(int n) throws Scanner.ScanException, ParseException {
        if (this.lookahead.isEmpty()) {
            this.lookahead = new LinkedList();
        }
        while (n >= this.lookahead.size()) {
            this.lookahead.add(new LookaheadToken(this.scanner.next(), this.scanner.getPosition()));
        }
        return ((LookaheadToken)this.lookahead.get((int)n)).token;
    }

    protected final Scanner.Token consumeToken() throws Scanner.ScanException, ParseException {
        Scanner.Token token = this.token;
        if (this.lookahead.isEmpty()) {
            this.token = this.scanner.next();
            this.position = this.scanner.getPosition();
        } else {
            LookaheadToken lookaheadToken = (LookaheadToken)this.lookahead.remove(0);
            this.token = lookaheadToken.token;
            this.position = lookaheadToken.position;
        }
        return token;
    }

    protected final Scanner.Token consumeToken(Scanner.Symbol symbol) throws Scanner.ScanException, ParseException {
        if (!this.token.getSymbol().equals(symbol)) {
            this.fail(symbol);
        }
        return this.consumeToken();
    }

    protected final Scanner.Token consumeToken(int n) throws Scanner.ScanException, ParseException {
        return this.consumeToken(new Scanner.Symbol(n));
    }

    public Tree tree() throws Scanner.ScanException, ParseException {
        this.consumeToken();
        AstNode astNode = this.text();
        if (this.token.getSymbol().getCode() == 0) {
            if (astNode == null) {
                astNode = new AstText("");
            }
            return new Tree(astNode, this.functions, this.identifiers, false);
        }
        AstEval astEval = this.eval();
        if (this.token.getSymbol().getCode() == 0 && astNode == null) {
            return new Tree(astEval, this.functions, this.identifiers, astEval.isDeferred());
        }
        ArrayList<AstNode> arrayList = new ArrayList<AstNode>();
        if (astNode != null) {
            arrayList.add(astNode);
        }
        arrayList.add(astEval);
        astNode = this.text();
        if (astNode != null) {
            arrayList.add(astNode);
        }
        while (this.token.getSymbol().getCode() != 0) {
            if (astEval.isDeferred()) {
                arrayList.add(this.eval(true, true));
            } else {
                arrayList.add(this.eval(true, false));
            }
            if ((astNode = this.text()) == null) continue;
            arrayList.add(astNode);
        }
        return new Tree(this.createAstComposite(arrayList), this.functions, this.identifiers, astEval.isDeferred());
    }

    protected AstNode text() throws Scanner.ScanException, ParseException {
        AstText astText = null;
        if (this.token.getSymbol().getCode() == 28) {
            astText = new AstText(this.token.getImage());
            this.consumeToken();
        }
        return astText;
    }

    protected AstEval eval() throws Scanner.ScanException, ParseException {
        AstEval astEval = this.eval(false, false);
        if (astEval == null && (astEval = this.eval(false, true)) == null) {
            this.fail(Scanner.Symbol.codeToString(33) + "|" + Scanner.Symbol.codeToString(34));
        }
        return astEval;
    }

    protected AstEval eval(boolean bl, boolean bl2) throws Scanner.ScanException, ParseException {
        int n;
        AstEval astEval = null;
        int n2 = n = bl2 ? 33 : 34;
        if (this.token.getSymbol().getCode() == n) {
            this.consumeToken();
            astEval = new AstEval(this.expr(true), bl2);
            this.consumeToken(new Scanner.Symbol(35));
        } else if (bl) {
            this.fail(Scanner.Symbol.codeToString(n));
        }
        return astEval;
    }

    protected AstNode expr(boolean bl) throws Scanner.ScanException, ParseException {
        AstNode astNode = this.or(bl);
        if (astNode == null) {
            return null;
        }
        if (this.token.getSymbol().getCode() == 26) {
            this.consumeToken();
            AstNode astNode2 = this.expr(true);
            this.consumeToken(new Scanner.Symbol(27));
            AstNode astNode3 = this.expr(true);
            astNode = this.createAstChoice(astNode, astNode2, astNode3);
        }
        return astNode;
    }

    protected AstNode or(boolean bl) throws Scanner.ScanException, ParseException {
        AstNode astNode = this.and(bl);
        if (astNode == null) {
            return null;
        }
        block4: while (true) {
            switch (this.token.getSymbol().getCode()) {
                case 11: {
                    this.consumeToken();
                    astNode = this.createAstBinary(astNode, this.and(true), AstBinary.OR);
                    continue block4;
                }
                case 36: {
                    if (this.getExtensionHandler(this.token).getExtensionPoint().getCode() != ExtensionPoint.OR) break block4;
                    astNode = this.getExtensionHandler(this.consumeToken()).createAstNode(new AstNode[]{astNode, this.and(true)});
                    continue block4;
                }
            }
            break;
        }
        return astNode;
    }

    protected AstNode and(boolean bl) throws Scanner.ScanException, ParseException {
        AstNode astNode = this.eq(bl);
        if (astNode == null) {
            return null;
        }
        block4: while (true) {
            switch (this.token.getSymbol().getCode()) {
                case 10: {
                    this.consumeToken();
                    astNode = this.createAstBinary(astNode, this.eq(true), AstBinary.AND);
                    continue block4;
                }
                case 36: {
                    if (this.getExtensionHandler(this.token).getExtensionPoint().getCode() != ExtensionPoint.AND) break block4;
                    astNode = this.getExtensionHandler(this.consumeToken()).createAstNode(new AstNode[]{astNode, this.eq(true)});
                    continue block4;
                }
            }
            break;
        }
        return astNode;
    }

    protected AstNode eq(boolean bl) throws Scanner.ScanException, ParseException {
        AstNode astNode = this.cmp(bl);
        if (astNode == null) {
            return null;
        }
        block5: while (true) {
            switch (this.token.getSymbol().getCode()) {
                case 24: {
                    this.consumeToken();
                    astNode = this.createAstBinary(astNode, this.cmp(true), AstBinary.EQ);
                    continue block5;
                }
                case 25: {
                    this.consumeToken();
                    astNode = this.createAstBinary(astNode, this.cmp(true), AstBinary.NE);
                    continue block5;
                }
                case 36: {
                    if (this.getExtensionHandler(this.token).getExtensionPoint().getCode() != ExtensionPoint.EQ) break block5;
                    astNode = this.getExtensionHandler(this.consumeToken()).createAstNode(new AstNode[]{astNode, this.cmp(true)});
                    continue block5;
                }
            }
            break;
        }
        return astNode;
    }

    protected AstNode cmp(boolean bl) throws Scanner.ScanException, ParseException {
        AstNode astNode = this.add(bl);
        if (astNode == null) {
            return null;
        }
        block7: while (true) {
            switch (this.token.getSymbol().getCode()) {
                case 21: {
                    this.consumeToken();
                    astNode = this.createAstBinary(astNode, this.add(true), AstBinary.LT);
                    continue block7;
                }
                case 20: {
                    this.consumeToken();
                    astNode = this.createAstBinary(astNode, this.add(true), AstBinary.LE);
                    continue block7;
                }
                case 22: {
                    this.consumeToken();
                    astNode = this.createAstBinary(astNode, this.add(true), AstBinary.GE);
                    continue block7;
                }
                case 23: {
                    this.consumeToken();
                    astNode = this.createAstBinary(astNode, this.add(true), AstBinary.GT);
                    continue block7;
                }
                case 36: {
                    if (this.getExtensionHandler(this.token).getExtensionPoint().getCode() != ExtensionPoint.CMP) break block7;
                    astNode = this.getExtensionHandler(this.consumeToken()).createAstNode(new AstNode[]{astNode, this.add(true)});
                    continue block7;
                }
            }
            break;
        }
        return astNode;
    }

    protected AstNode add(boolean bl) throws Scanner.ScanException, ParseException {
        AstNode astNode = this.mul(bl);
        if (astNode == null) {
            return null;
        }
        block5: while (true) {
            switch (this.token.getSymbol().getCode()) {
                case 1: {
                    this.consumeToken();
                    astNode = this.createAstBinary(astNode, this.mul(true), AstBinary.ADD);
                    continue block5;
                }
                case 2: {
                    this.consumeToken();
                    astNode = this.createAstBinary(astNode, this.mul(true), AstBinary.SUB);
                    continue block5;
                }
                case 36: {
                    if (this.getExtensionHandler(this.token).getExtensionPoint().getCode() != ExtensionPoint.ADD) break block5;
                    astNode = this.getExtensionHandler(this.consumeToken()).createAstNode(new AstNode[]{astNode, this.mul(true)});
                    continue block5;
                }
            }
            break;
        }
        return astNode;
    }

    protected AstNode mul(boolean bl) throws Scanner.ScanException, ParseException {
        AstNode astNode = this.unary(bl);
        if (astNode == null) {
            return null;
        }
        block6: while (true) {
            switch (this.token.getSymbol().getCode()) {
                case 3: {
                    this.consumeToken();
                    astNode = this.createAstBinary(astNode, this.unary(true), AstBinary.MUL);
                    continue block6;
                }
                case 4: {
                    this.consumeToken();
                    astNode = this.createAstBinary(astNode, this.unary(true), AstBinary.DIV);
                    continue block6;
                }
                case 5: {
                    this.consumeToken();
                    astNode = this.createAstBinary(astNode, this.unary(true), AstBinary.MOD);
                    continue block6;
                }
                case 36: {
                    if (this.getExtensionHandler(this.token).getExtensionPoint().getCode() != ExtensionPoint.MUL) break block6;
                    astNode = this.getExtensionHandler(this.consumeToken()).createAstNode(new AstNode[]{astNode, this.unary(true)});
                    continue block6;
                }
            }
            break;
        }
        return astNode;
    }

    protected AstNode unary(boolean bl) throws Scanner.ScanException, ParseException {
        AstNode astNode = null;
        switch (this.token.getSymbol().getCode()) {
            case 9: {
                this.consumeToken();
                astNode = this.createAstUnary(this.unary(true), AstUnary.NOT);
                break;
            }
            case 2: {
                this.consumeToken();
                astNode = this.createAstUnary(this.unary(true), AstUnary.NEG);
                break;
            }
            case 12: {
                this.consumeToken();
                astNode = this.createAstUnary(this.unary(true), AstUnary.EMPTY);
                break;
            }
            case 36: {
                if (this.getExtensionHandler(this.token).getExtensionPoint().getCode() == ExtensionPoint.UNARY) {
                    astNode = this.getExtensionHandler(this.consumeToken()).createAstNode(new AstNode[]{this.unary(true)});
                    break;
                }
            }
            default: {
                astNode = this.value();
            }
        }
        if (astNode == null && bl) {
            this.fail(EXPR_FIRST);
        }
        return astNode;
    }

    protected AstNode value() throws Scanner.ScanException, ParseException {
        boolean bl = true;
        AstNode astNode = this.nonliteral();
        if (astNode == null) {
            astNode = this.literal();
            if (astNode == null) {
                return null;
            }
            bl = false;
        }
        block4: while (true) {
            switch (this.token.getSymbol().getCode()) {
                case 29: {
                    this.consumeToken();
                    String string = this.consumeToken(8).getImage();
                    AstDot astDot = this.createAstDot(astNode, string, bl);
                    if (this.token.getSymbol().getCode() == 6 && this.context.isEnabled(new Builder.Feature(Builder.Feature.METHOD_INVOCATIONS))) {
                        astNode = this.createAstMethod(astDot, this.params());
                        continue block4;
                    }
                    astNode = astDot;
                    continue block4;
                }
                case 30: {
                    this.consumeToken();
                    AstNode astNode2 = this.expr(true);
                    boolean bl2 = !this.context.isEnabled(new Builder.Feature(Builder.Feature.NULL_PROPERTIES));
                    this.consumeToken(31);
                    AstBracket astBracket = this.createAstBracket(astNode, astNode2, bl, bl2);
                    if (this.token.getSymbol().getCode() == 6 && this.context.isEnabled(new Builder.Feature(Builder.Feature.METHOD_INVOCATIONS))) {
                        astNode = this.createAstMethod(astBracket, this.params());
                        continue block4;
                    }
                    astNode = astBracket;
                    continue block4;
                }
            }
            break;
        }
        return astNode;
    }

    protected AstNode nonliteral() throws Scanner.ScanException, ParseException {
        AstNode astNode = null;
        switch (this.token.getSymbol().getCode()) {
            case 8: {
                String string = this.consumeToken().getImage();
                if (this.token.getSymbol().getCode() == 27 && this.lookahead(0).getSymbol().getCode() == 8 && this.lookahead(1).getSymbol().getCode() == 6) {
                    this.consumeToken();
                    string = string + ":" + this.token.getImage();
                    this.consumeToken();
                }
                if (this.token.getSymbol().getCode() == 6) {
                    astNode = this.function(string, this.params());
                    break;
                }
                astNode = this.identifier(string);
                break;
            }
            case 6: {
                this.consumeToken();
                astNode = this.expr(true);
                this.consumeToken(7);
                astNode = new AstNested(astNode);
            }
        }
        return astNode;
    }

    protected AstParameters params() throws Scanner.ScanException, ParseException {
        this.consumeToken(6);
        AbstractList abstractList = new Vector();
        AstNode astNode = this.expr(false);
        if (astNode != null) {
            abstractList = new ArrayList();
            abstractList.add(astNode);
            while (this.token.getSymbol().getCode() == 32) {
                this.consumeToken();
                abstractList.add(this.expr(true));
            }
        }
        this.consumeToken(7);
        return new AstParameters(abstractList);
    }

    protected AstNode literal() throws Scanner.ScanException, ParseException {
        AstNode astNode = null;
        switch (this.token.getSymbol().getCode()) {
            case 16: {
                astNode = new AstBoolean(true);
                this.consumeToken();
                break;
            }
            case 17: {
                astNode = new AstBoolean(false);
                this.consumeToken();
                break;
            }
            case 18: {
                astNode = new AstString(this.token.getImage());
                this.consumeToken();
                break;
            }
            case 14: {
                astNode = new AstNumber(this.parseInteger(this.token.getImage()));
                this.consumeToken();
                break;
            }
            case 15: {
                astNode = new AstNumber(this.parseFloat(this.token.getImage()));
                this.consumeToken();
                break;
            }
            case 19: {
                astNode = new AstNull();
                this.consumeToken();
                break;
            }
            case 36: {
                if (this.getExtensionHandler(this.token).getExtensionPoint().getCode() != ExtensionPoint.LITERAL) break;
                astNode = this.getExtensionHandler(this.consumeToken()).createAstNode(new AstNode[0]);
            }
        }
        return astNode;
    }

    protected final AstFunction function(String string, AstParameters astParameters) {
        if (this.functions.isEmpty()) {
            this.functions = new ArrayList(4);
        }
        AstFunction astFunction = this.createAstFunction(string, this.functions.size(), astParameters);
        this.functions.add(astFunction);
        return astFunction;
    }

    protected final AstIdentifier identifier(String string) {
        if (this.identifiers.isEmpty()) {
            this.identifiers = new ArrayList(4);
        }
        AstIdentifier astIdentifier = this.createAstIdentifier(string, this.identifiers.size());
        this.identifiers.add(astIdentifier);
        return astIdentifier;
    }

    public static abstract class ExtensionHandler {
        private final ExtensionPoint point;

        public ExtensionHandler(ExtensionPoint extensionPoint) {
            this.point = extensionPoint;
        }

        public ExtensionPoint getExtensionPoint() {
            return this.point;
        }

        public abstract AstNode createAstNode(AstNode[] var1);
    }

    public static class ExtensionPoint {
        private static int i = 0;
        public static final int OR = i++;
        public static final int AND = i++;
        public static final int EQ = i++;
        public static final int CMP = i++;
        public static final int ADD = i++;
        public static final int MUL = i++;
        public static final int UNARY = i++;
        public static final int LITERAL = i++;
        private int _code;

        public ExtensionPoint(int n) {
            this._code = n;
        }

        public int getCode() {
            return this._code;
        }
    }

    private static final class LookaheadToken {
        final Scanner.Token token;
        final int position;

        LookaheadToken(Scanner.Token token, int n) {
            this.token = token;
            this.position = n;
        }
    }

    public static class ParseException
    extends Exception {
        final int position;
        final String encountered;
        final String expected;

        public ParseException(int n, String string, String string2) {
            super(LocalMessages.get("error.parse", new Object[]{new Integer(n), string, string2}));
            this.position = n;
            this.encountered = string;
            this.expected = string2;
        }
    }
}

