/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.wizard.archiveimport;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.wizard.archiveimport.MobileArchiveImport;
import oracle.ide.Ide;
import oracle.ide.component.NewFilePanel;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLTextField;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.NewWorkspacePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.ide.wizard.WizardCallbacks;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ModelUtil;
import oracle.jdevimpl.wizard.project.NewProjectPanel;

public final class MobileArchiveLocationPanel
extends DefaultTraversablePanel {
    private JLabel _maaLbl = new JLabel();
    private URLTextField _maaUrlFld = new URLTextField(null, false, false){

        public void setURL(URL url) {
            super.setURL(url);
            if (url != null) {
                MobileArchiveLocationPanel.this._initSourcePath(url);
            }
        }
    };
    private JButton _maaBrowseBtn = new JButton();
    private NewWorkspacePanel _newWorkspacePanel;
    private NewFilePanel _newWorkspaceNewFilePanel;
    private transient MobileArchiveImport _maaImport;
    private transient WizardCallbacks _callbacks;
    private URL _origMaaUrl;
    private URL _defaultedWorkspaceFileUrl;
    private static final Insets _MAA_FIELD_AND_WORKSPACE_INSETS = new Insets(0, 0, 5, 0);
    private static final Insets _BUTTON_AND_FILLER_INSETS = new Insets(0, 5, 5, 0);

    public MobileArchiveLocationPanel() {
        this.setLayout(new GridBagLayout());
        this.setDefaultTitle(MobileResourceUtils.getText("ARCHIVE_IMPORT_LOCATION_PAGE_TITLE"));
        this.add((Component)this._getLabelPrompt(), new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 10, 0), 0, 0));
        this.add(this._getMaaUrlFieldLabel(), new GridBagConstraints(0, 1, 5, 1, 0.0, 0.0, 17, 0, _MAA_FIELD_AND_WORKSPACE_INSETS, 0, 0));
        this.add((Component)this._maaUrlFld, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 17, 2, _MAA_FIELD_AND_WORKSPACE_INSETS, 0, 0));
        this.add(this._getMaaBrowseButton(), new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 0, _BUTTON_AND_FILLER_INSETS, 0, 0));
        this.add((Component)this._getNewWorkspacePanel(), new GridBagConstraints(0, 3, 5, 4, 1.0, 0.0, 17, 1, _MAA_FIELD_AND_WORKSPACE_INSETS, 0, 0));
        this.add(new JLabel(), new GridBagConstraints(0, 7, 3, 1, 0.0, 1.0, 17, 0, _BUTTON_AND_FILLER_INSETS, 0, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEntry(TraversableContext tc) {
        this._callbacks = tc.getWizardCallbacks();
        this._setNextButtonStatus();
        this._callbacks.wizardSetInitialFocus((Component)this._maaUrlFld);
        this._maaUrlFld.setURL((URL)tc.get("MAA-url"));
        this._origMaaUrl = this._maaUrlFld.getURL();
        if (!tc.contains("workspace-file-name")) {
            URL wspDirURL = NewWorkspacePanel.getDefaultWorkspaceDirURL();
            String wspFileName = NewWorkspacePanel.getDefaultWorkspaceFileName((URL)wspDirURL);
            this._newWorkspaceNewFilePanel.setDirectoryURL(wspDirURL);
            this._newWorkspaceNewFilePanel.setFileName(wspFileName);
            this._newWorkspaceNewFilePanel.setInteractiveMode(false);
            try {
                this._defaultedWorkspaceFileUrl = this._newWorkspaceNewFilePanel.getFileURL();
                this._newWorkspaceNewFilePanel.setFileName(URLFileSystem.getFileName((URL)this._defaultedWorkspaceFileUrl));
            }
            catch (TraversalException e) {
                this._defaultedWorkspaceFileUrl = null;
            }
            finally {
                this._newWorkspaceNewFilePanel.setInteractiveMode(true);
            }
        } else {
            URL wspFileName = (URL)tc.get("workspace-file-name");
            this._newWorkspaceNewFilePanel.setDirectoryURL(URLFileSystem.getParent((URL)wspFileName));
            this._newWorkspaceNewFilePanel.setFileName(URLFileSystem.getFileName((URL)wspFileName));
            this._defaultedWorkspaceFileUrl = (URL)tc.get("default-workspace-url");
        }
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        if (!this._validateMaaFile(true)) {
            throw new TraversalException(null);
        }
        if (!this._newWorkspacePanel.validatePanel()) {
            throw new TraversalException(null);
        }
        URL workspaceFileURL = this._newWorkspaceNewFilePanel.getFileURL();
        if (workspaceFileURL == null) {
            throw new TraversalException(null);
        }
        tc.findAndReplace("workspace-file-name", (Object)workspaceFileURL);
        tc.findAndReplace("default-workspace-url", (Object)this._defaultedWorkspaceFileUrl);
        if (!ModelUtil.areEqual((Object)this._origMaaUrl, (Object)this._maaUrlFld.getURL())) {
            this._maaImport = (MobileArchiveImport)tc.get("MAA-import");
            if (this._maaImport != null) {
                this._maaImport = null;
            }
            this._maaImport = new MobileArchiveImport();
            tc.put("MAA-import", (Object)this._maaImport);
            tc.findAndReplace("MAA-url", (Object)this._maaUrlFld.getURL());
        }
        List<URL> projectUrls = this._maaImport.getProjects(this._maaUrlFld.getURL(), URLFileSystem.getParent((URL)workspaceFileURL));
        for (URL projectUrl : projectUrls) {
            if (this._validateProject(projectUrl)) continue;
            throw new TraversalException(null);
        }
        tc.findAndReplace("projects-file-path", projectUrls);
    }

    private void _setNextButtonStatus() {
        if (!this._validateMaaFile(false)) {
            this._callbacks.wizardEnableButtons(Boolean.TRUE, Boolean.FALSE, Boolean.FALSE);
        } else {
            this._callbacks.wizardEnableButtons(Boolean.TRUE, Boolean.TRUE, Boolean.TRUE);
        }
    }

    private boolean _validateMaaFile(boolean interactive) {
        boolean retVal = true;
        String errMsg = null;
        URL url = this._maaUrlFld.getURL();
        if (url == null) {
            errMsg = MobileResourceUtils.getText("ARCHIVE_IMPORT_NULL_MAA_FILE_ERROR");
            retVal = false;
        } else if (!URLFileSystem.canRead((URL)url)) {
            errMsg = MobileResourceUtils.getText("ARCHIVE_IMPORT_UNREADABLE_MAA_FILE_ERROR");
            retVal = false;
        } else if (!URLFileSystem.hasSuffix((URL)url, (String)".maa")) {
            errMsg = MobileResourceUtils.getText("ARCHIVE_IMPORT_NOT_MAA_FILE_ERROR");
            retVal = false;
        }
        if (!retVal && interactive) {
            MessageDialog.error((Component)((Object)this), (Object)errMsg, (String)MobileResourceUtils.getText("ARCHIVE_IMPORT_MAA_FILE_ERROR_TITLE"), null);
        }
        return retVal;
    }

    private boolean _validateProject(URL projectUrl) {
        NewProjectPanel newProjectPanel = new NewProjectPanel();
        newProjectPanel.setDirectoryURL(URLFileSystem.getParent((URL)projectUrl));
        newProjectPanel.setFileName(URLFileSystem.getFileName((URL)projectUrl));
        try {
            newProjectPanel.getFileURL();
        }
        catch (TraversalException e) {
            e.showMessageDialog((Component)((Object)this));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _initSourcePath(URL url) {
        if (this._defaultedWorkspaceFileUrl != null) {
            this._newWorkspaceNewFilePanel.setInteractiveMode(false);
            try {
                URL currentWorkspaceFileUrl = this._newWorkspaceNewFilePanel.getFileURL();
                if (currentWorkspaceFileUrl.toString().equals(this._defaultedWorkspaceFileUrl.toString())) {
                    String maaName = URLFileSystem.getName((URL)url);
                    URL newWorkspaceDirectory = URLFactory.newDirURL((URL)URLFileSystem.getParent((URL)URLFileSystem.getParent((URL)currentWorkspaceFileUrl)), (String)maaName);
                    this._newWorkspaceNewFilePanel.setFileName(maaName + ".jws");
                    this._newWorkspaceNewFilePanel.setDirectoryURL(newWorkspaceDirectory);
                    try {
                        this._defaultedWorkspaceFileUrl = this._newWorkspaceNewFilePanel.getFileURL();
                        this._newWorkspaceNewFilePanel.setFileName(URLFileSystem.getFileName((URL)this._defaultedWorkspaceFileUrl));
                    }
                    catch (TraversalException e) {
                        this._defaultedWorkspaceFileUrl = null;
                    }
                }
            }
            catch (TraversalException traversalException) {
            }
            finally {
                this._newWorkspaceNewFilePanel.setInteractiveMode(true);
            }
        }
    }

    private JWrappedLabel _getLabelPrompt() {
        return new JWrappedLabel(MobileResourceUtils.getText("ARCHIVE_IMPORT_LOCATION_TEXT"));
    }

    private JLabel _getMaaUrlFieldLabel() {
        ResourceUtils.resLabel((JLabel)this._maaLbl, (Component)this._maaUrlFld, (String)MobileResourceUtils.getText("ARCHIVE_IMPORT_MAA_FILE_PROMPT"));
        return this._maaLbl;
    }

    private JButton _getMaaBrowseButton() {
        ResourceUtils.resButton((AbstractButton)this._maaBrowseBtn, (String)MobileResourceUtils.getText("ARCHIVE_IMPORT_MAA_BROWSE_BUTTON"));
        this._maaBrowseBtn.addActionListener((ActionListener)this._maaUrlFld);
        this._maaUrlFld.setDialogTitle(MobileResourceUtils.getText("ARCHIVE_IMPORT_MAA_CHOOSER_TITLE"));
        URL defaultUrl = URLFactory.newDirURL((String)Ide.getProductHomeDirectory());
        this._maaUrlFld.setDefaultChooserURL(URLFileSystem.getParent((URL)defaultUrl));
        this._maaUrlFld.clearChooseableURLFilters();
        this._maaUrlFld.setFilter((URLFilter)new DefaultURLFilter(MobileResourceUtils.getText("ARCHIVE_IMPORT_FILTER_DESCRIPTION"), ".maa"));
        this._maaUrlFld.getDocument().addDocumentListener(new MaaUrlFldDocumentListener());
        return this._maaBrowseBtn;
    }

    private NewWorkspacePanel _getNewWorkspacePanel() {
        this._newWorkspacePanel = new NewWorkspacePanel(false, false, false);
        this._newWorkspaceNewFilePanel = this._newWorkspacePanel.getNewFilePanel();
        this._newWorkspacePanel.setDirectoryPrompt(MobileResourceUtils.getText("ARCHIVE_IMPORT_WKSPC_DIRECTORY_LABEL"));
        this._newWorkspacePanel.setFilePrompt(MobileResourceUtils.getText("ARCHIVE_IMPORT_WKSPC_FILE_LABEL"));
        return this._newWorkspacePanel;
    }

    private class MaaUrlFldDocumentListener
    implements DocumentListener {
        private MaaUrlFldDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            MobileArchiveLocationPanel.this._setNextButtonStatus();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            MobileArchiveLocationPanel.this._setNextButtonStatus();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    }
}

