/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.wizard.archiveimport;

import java.awt.Component;
import java.net.URL;
import javax.ide.util.MetaClass;
import javax.swing.Icon;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.wizard.archiveimport.MobileArchiveFinishPanel;
import oracle.adfmf.framework.dt.wizard.archiveimport.MobileArchiveImport;
import oracle.adfmf.framework.dt.wizard.archiveimport.MobileArchiveLocationPanel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.GenericWizardLauncher;
import oracle.ide.wizard.Wizard;
import oracle.ideri.importexport.ImportWizard;
import oracle.jdeveloper.resource.ModelArb;

public final class MobileArchiveImportWizard
extends Wizard
implements Runnable,
ImportWizard {
    public static final String MAA_FILE_LOCATION_KEY = "MAA-url";
    public static final String WORKSPACE_FILENAME_KEY = "workspace-file-name";
    public static final String DEFAULT_WORKSPACE_URL_KEY = "default-workspace-url";
    public static final String MAA_IMPORT_KEY = "MAA-import";
    public static final String PROJECTS_FILEPATH_KEY = "projects-file-path";
    private static final String _NEW_ARCHIVE_LOCATION_HELP = "f1_adfmf_newarchivelocation_html";
    private static final String _NEW_ARCHIVE_SUMMARY_HELP = "f1_adfmf_newarchivesummary_html";
    private MobileArchiveImport _maaImport;
    private URL _maaURL;
    private URL _wkspDirURL;
    private String _wkspName;
    private ProgressBar _progressBar;

    public String getShortLabel() {
        return MobileResourceUtils.getText("WORKSPACE_FROM_ARCHIVE_FILE_ITEM_NAME");
    }

    public String getLongLabel() {
        return MobileResourceUtils.getText("WORKSPACE_FROM_ARCHIVE_FILE_ITEM_DESC");
    }

    public Icon getIcon() {
        return ModelArb.getIcon((int)49);
    }

    public boolean isAvailable(Context context) {
        return true;
    }

    public boolean invoke(Context context) {
        return this._invokeWizard(context);
    }

    public String getImportWizardName(Context context) {
        return MobileResourceUtils.getText("WORKSPACE_FROM_ARCHIVE_FILE_ITEM_NAME");
    }

    public Icon getImportWizardIcon(Context context) {
        return ModelArb.getIcon((int)49);
    }

    public String getImportWizardTooltipText(Context context) {
        return MobileResourceUtils.getText("WORKSPACE_FROM_ARCHIVE_FILE_ITEM_DESC");
    }

    public boolean isAvailableAsImportWizard(Context context) {
        return true;
    }

    public boolean invokeImportWizard(Context context, String[] params) {
        return this._invokeWizard(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this._maaImport.importMaa(this._maaURL, this._wkspDirURL, this._wkspName);
        }
        finally {
            if (this._progressBar != null) {
                this._progressBar.setDoneStatus();
            }
        }
    }

    private boolean _invokeWizard(Context context) {
        GenericWizardLauncher launcher = new GenericWizardLauncher(context, MobileResourceUtils.getText("ARCHIVE_IMPORT_GALERY_WIZARD_TITLE"));
        ClassLoader importWizardClassLoader = this.getClass().getClassLoader();
        launcher.addPage(new MetaClass(importWizardClassLoader, MobileArchiveLocationPanel.class.getName()), _NEW_ARCHIVE_LOCATION_HELP);
        launcher.addFinishPage(new MetaClass(importWizardClassLoader, MobileArchiveFinishPanel.class.getName()), _NEW_ARCHIVE_SUMMARY_HELP, MobileResourceUtils.getText("ARCHIVE_IMPORT_FINISH_PAGE_TITLE"));
        launcher.setShowStepNumber(true);
        if (launcher.runGenericWizard()) {
            Namespace ns = launcher.getNamespace();
            this._maaImport = (MobileArchiveImport)ns.find(MAA_IMPORT_KEY);
            this._maaURL = (URL)ns.get(MAA_FILE_LOCATION_KEY);
            URL wkspFileURL = (URL)ns.get(WORKSPACE_FILENAME_KEY);
            this._wkspDirURL = URLFileSystem.getParent((URL)wkspFileURL);
            this._wkspName = URLFileSystem.getName((URL)wkspFileURL);
            this._progressBar = new ProgressBar((Component)Ide.getMainWindow(), MobileResourceUtils.getText("ARCHIVE_IMPORT_PROGRESS_DLG_TITLE"), (Runnable)this, true);
            this._progressBar.start(MobileResourceUtils.getText("ARCHIVE_IMPORT_PROGRESS_TEXT"), null);
            this._progressBar.waitUntilDone();
            boolean isFinished = !this._progressBar.hasUserCancelled();
            this._progressBar = null;
            return isFinished;
        }
        return false;
    }
}

