/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.wizard.archiveimport;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import oracle.adfmf.common.util.FileUtils;
import oracle.adfmf.common.util.McAppUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.common.util.ProjectUtils;
import oracle.ide.Ide;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependencyConfiguration;
import oracle.ide.model.Element;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.jdeveloper.library.JLibraryDependableRecognizer;

public final class MobileArchiveImport {
    private final Logger _logger = Logger.getLogger(MobileArchiveImport.class.getName());
    private static final String _JAR_FILTER_DESC = "jar file";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<URL> getProjects(URL maaFileUrl, URL wkspDirUrl) {
        ArrayList<URL> projectUrls = new ArrayList<URL>();
        if (URLFileSystem.exists((URL)maaFileUrl)) {
            String archiveFileName = maaFileUrl.getPath();
            ZipFile archiveFile = null;
            try {
                archiveFile = new ZipFile(archiveFileName);
                List<ZipEntry> projectJarArchiveEntries = this._findArchiveEntries(archiveFile, "Projects/", ".jar");
                for (ZipEntry projectJarArchiveEntry : projectJarArchiveEntries) {
                    String projectFolderName = URLFileSystem.getName((URL)URLFactory.newJarURL((URL)maaFileUrl, (String)projectJarArchiveEntry.getName()));
                    URL projectFolderUrl = URLFactory.newDirURL((URL)wkspDirUrl, (String)projectFolderName);
                    projectUrls.addAll(this._getProjectUrls(archiveFile, projectJarArchiveEntry, projectFolderUrl));
                }
            }
            catch (Exception e) {
                this._logger.log(Level.SEVERE, MobileResourceUtils.getText("ARCHIVE_IMPORT_ERROR", maaFileUrl));
                this._logImportArchiveException(e);
            }
            finally {
                if (archiveFile != null) {
                    try {
                        archiveFile.close();
                    }
                    catch (Exception e) {}
                }
            }
        } else {
            this._logger.log(Level.SEVERE, MobileResourceUtils.getText("ARCHIVE_IMPORT_ERROR_FINDING_FILE", maaFileUrl));
        }
        return projectUrls;
    }

    public void importMaa(URL maaFileUrl, URL outDirUrl, String wkspName) {
        if (URLFileSystem.exists((URL)maaFileUrl)) {
            Workspace workspace = this._unpackArchive(maaFileUrl, outDirUrl, wkspName);
            if (workspace == null) {
                return;
            }
            URL projectsDirUrl = URLFactory.newDirURL((URL)outDirUrl, (String)"Projects");
            this._setupProjects(outDirUrl, projectsDirUrl, workspace);
            this._addWorkspace(outDirUrl, workspace);
        } else {
            this._logger.log(Level.SEVERE, MobileResourceUtils.getText("ARCHIVE_IMPORT_ERROR_FINDING_FILE", maaFileUrl));
        }
    }

    private List<ZipEntry> _findArchiveEntries(ZipFile archiveFile, String prefix, String extension) {
        ArrayList<ZipEntry> matchingZipEntries = new ArrayList<ZipEntry>();
        if (archiveFile != null) {
            Enumeration<? extends ZipEntry> archiveEntries = archiveFile.entries();
            while (archiveEntries.hasMoreElements()) {
                ZipEntry zipEntry = archiveEntries.nextElement();
                if (!this._isZipEntryMatching(zipEntry, prefix, extension)) continue;
                matchingZipEntries.add(zipEntry);
            }
        }
        return matchingZipEntries;
    }

    private boolean _isZipEntryMatching(ZipEntry zipEntry, String prefix, String extension) {
        String name = zipEntry.getName();
        return !(prefix != null && !name.startsWith(prefix) || extension != null && !name.endsWith(extension));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<URL> _getProjectUrls(ZipFile archiveFile, ZipEntry projectJarZipEntry, URL projectFolderUrl) {
        ArrayList<URL> projectUrls = new ArrayList<URL>();
        if (archiveFile != null) {
            ZipInputStream zis = null;
            try {
                zis = new ZipInputStream(archiveFile.getInputStream(projectJarZipEntry));
                ZipEntry zipEntry = zis.getNextEntry();
                while (zipEntry != null) {
                    if (this._isZipEntryMatching(zipEntry, null, ".jpr")) {
                        String name = zipEntry.getName();
                        projectUrls.add(URLFactory.newURL((URL)projectFolderUrl, (String)name));
                    }
                    zipEntry = zis.getNextEntry();
                }
            }
            catch (Exception e) {
                try {
                    this._logger.log(Level.SEVERE, MobileResourceUtils.getText("ARCHIVE_IMPORT_ERROR", archiveFile.getName()));
                    this._logImportArchiveException(e);
                }
                catch (Throwable throwable) {
                    FileUtils.closeStream(zis, null);
                    throw throwable;
                }
                FileUtils.closeStream(zis, null);
            }
            FileUtils.closeStream(zis, null);
        }
        return projectUrls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Workspace _unpackArchive(URL archiveUrl, URL outDirUrl, String wkspName) {
        Workspace workspace = null;
        ZipFile archiveFile = null;
        try {
            FileUtils.createDirectory(outDirUrl);
            String archiveFileName = archiveUrl.getPath();
            archiveFile = new ZipFile(archiveFileName);
            Enumeration<? extends ZipEntry> archiveEntries = archiveFile.entries();
            ArrayList<ZipEntry> metaInfZipEntries = new ArrayList<ZipEntry>();
            while (archiveEntries.hasMoreElements()) {
                ZipEntry zipEntry = archiveEntries.nextElement();
                String name = zipEntry.getName();
                if (name.startsWith("adf/")) {
                    name = "." + name;
                } else if (name.endsWith(".jws")) {
                    name = wkspName + ".jws";
                } else if (name.startsWith("META-INF/")) {
                    metaInfZipEntries.add(zipEntry);
                    continue;
                }
                FileUtils.copyFromZip(archiveFile, zipEntry, URLFactory.newURL((URL)outDirUrl, (String)name));
            }
            workspace = this._getWorkspace(outDirUrl, wkspName);
            if (workspace != null) {
                URL appSrcDirUrl = McAppUtils.getSourceDir(workspace);
                FileUtils.createDirectory(appSrcDirUrl);
                for (ZipEntry metaInfZipEntry : metaInfZipEntries) {
                    FileUtils.copyFromZip(archiveFile, metaInfZipEntry, URLFactory.newURL((URL)appSrcDirUrl, (String)metaInfZipEntry.getName()));
                }
            }
        }
        catch (Exception e) {
            this._logger.log(Level.SEVERE, MobileResourceUtils.getText("ARCHIVE_IMPORT_ERROR", archiveUrl));
            this._logImportArchiveException(e);
        }
        finally {
            if (archiveFile != null) {
                try {
                    archiveFile.close();
                }
                catch (Exception e) {}
            }
        }
        return workspace;
    }

    private void _logImportArchiveException(Exception e) {
        this._logger.log(Level.SEVERE, e.getClass() + " " + ":" + " " + e.getMessage());
    }

    private Workspace _getWorkspace(URL outDirUrl, String wkspName) {
        URL newWorkspaceUrl = URLFactory.newURL((URL)outDirUrl, (String)(wkspName + ".jws"));
        Workspace workspace = null;
        if (URLFileSystem.exists((URL)newWorkspaceUrl)) {
            try {
                workspace = (Workspace)NodeFactory.findOrCreate((URL)newWorkspaceUrl);
            }
            catch (Exception e) {
                this._logger.log(Level.SEVERE, MobileResourceUtils.getText("ARCHIVE_IMPORT_IMPORTING_WORKSPACE_ERROR", newWorkspaceUrl));
                this._logImportArchiveException(e);
            }
        } else {
            this._logger.log(Level.SEVERE, MobileResourceUtils.getText("ARCHIVE_IMPORT_FINDING_WORKSPACE_ERROR", newWorkspaceUrl));
        }
        return workspace;
    }

    private void _setupProjects(URL outDirUrl, URL projectsDirUrl, Workspace workspace) {
        this._unzipProjects(outDirUrl, projectsDirUrl);
        this._addProjectLibraries(workspace);
        this._updateProjectDependencies(workspace);
    }

    private void _unzipProjects(URL outDirUrl, URL projectsDirUrl) {
        if (URLFileSystem.exists((URL)projectsDirUrl)) {
            URL[] projectJars;
            for (URL projectJarUrl : projectJars = URLFileSystem.list((URL)projectsDirUrl, (URLFilter)new DefaultURLFilter(_JAR_FILTER_DESC, "jar"))) {
                String projectFolderName = URLFileSystem.getName((URL)projectJarUrl);
                if (projectFolderName.isEmpty()) continue;
                try {
                    URL projectFolderUrl = URLFactory.newDirURL((URL)outDirUrl, (String)projectFolderName);
                    FileUtils.unZipFile(projectJarUrl, projectFolderUrl);
                }
                catch (Exception e) {
                    this._logger.log(Level.SEVERE, MobileResourceUtils.getText("ARCHIVE_IMPORT_UNPACKING_PROJECT_ERROR", projectJarUrl));
                    this._logImportArchiveException(e);
                }
            }
            try {
                FileUtils.deleteDirectory(projectsDirUrl);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void _addProjectLibraries(Workspace workspace) {
        Collection projects = workspace.projects();
        for (Project project : projects) {
            URL projectUrl = project.getURL();
            if (URLFileSystem.exists((URL)projectUrl)) {
                URL libFolderUrl = URLFactory.newURL((URL)URLFileSystem.getParent((URL)projectUrl), (String)"classlib");
                URL[] libraryJarUrls = URLFileSystem.list((URL)libFolderUrl, (URLFilter)new DefaultURLFilter(_JAR_FILTER_DESC, "jar"));
                if (libraryJarUrls == null) continue;
                for (URL libraryJarUrl : libraryJarUrls) {
                    try {
                        ProjectUtils.addProjectLibrary(project, URLFactory.newJarURL((URL)libraryJarUrl, null));
                        project.save();
                    }
                    catch (Exception e) {
                        this._logger.log(Level.SEVERE, MobileResourceUtils.getText("ARCHIVE_IMPORT_ADDING_PROJECT_LIBRARY_ERROR", libraryJarUrl, projectUrl));
                        this._logImportArchiveException(e);
                    }
                }
                continue;
            }
            this._logger.log(Level.SEVERE, MobileResourceUtils.getText("ARCHIVE_IMPORT_FINDING_PROJECT_ERROR", projectUrl));
        }
    }

    private void _updateProjectDependencies(Workspace workspace) {
        Collection projects = workspace.projects();
        for (Project project : projects) {
            DependencyConfiguration projectDepends = DependencyConfiguration.getInstance((Project)project);
            List projectDependList = projectDepends.getDependencyList();
            if (projectDependList == null) continue;
            for (Dependable oldDependable : projectDependList) {
                Element dependencyProject = oldDependable.getSource();
                if (dependencyProject != null) {
                    Dependable updatedDependable = JLibraryDependableRecognizer.create((Element)dependencyProject, (Element)workspace);
                    if (updatedDependable == null) continue;
                    projectDepends.removeDependency(oldDependable);
                    projectDepends.addDependency(updatedDependable);
                    try {
                        project.save();
                    }
                    catch (Exception e) {
                        this._logger.log(Level.SEVERE, MobileResourceUtils.getText("ARCHIVE_IMPORT_UPDATING_PROJECT_DEPENDENCY_ERROR", updatedDependable.getSource().getLongLabel(), project.getLongLabel()));
                    }
                    continue;
                }
                this._logger.log(Level.WARNING, MobileResourceUtils.getText("ARCHIVE_IMPORT_INVALID_PROJECT_DEPENDENCY_DETECTED", oldDependable.toString(), project.getLongLabel()));
            }
        }
    }

    private void _addWorkspace(URL outDirUrl, Workspace workspace) {
        Workspaces workspaces = Ide.getWorkspaces();
        workspaces.setWorkDirectory(URLFileSystem.getParent((URL)outDirUrl));
        workspaces.add((Element)workspace);
        UpdateMessage.fireChildAdded((Subject)workspaces, (Element)workspace);
        Ide.setActiveWorkspace((Workspace)workspace);
    }
}

