/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.wizard.archiveimport;

import java.net.URL;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.TraversableContext;
import oracle.ide.wizard.FinishPanel;

public final class MobileArchiveFinishPanel
extends FinishPanel {
    private JTree _summaryTree;
    private DefaultMutableTreeNode _rootNode;
    private DefaultTreeModel _treeModel;

    public MobileArchiveFinishPanel() {
        super(MobileResourceUtils.getText("ARCHIVE_IMPORT_FINISH_LABEL"));
    }

    public void onEntry(TraversableContext tc) {
        if (this._summaryTree == null) {
            this._summaryTree = this.createSummaryTree(MobileResourceUtils.getText("ARCHIVE_IMPORT_FINISH_TEXT"));
            this._treeModel = (DefaultTreeModel)this._summaryTree.getModel();
            this._rootNode = (DefaultMutableTreeNode)this._treeModel.getRoot();
        }
        this._populateSummaryTree(tc);
        this.expandSummaryTree();
    }

    private void _populateSummaryTree(TraversableContext tc) {
        this._rootNode.removeAllChildren();
        this._rootNode.add(this._createMaaNode(tc));
        this._rootNode.add(this._createWorkspaceNode(tc));
        this._treeModel.reload();
    }

    private DefaultMutableTreeNode _createMaaNode(TraversableContext tc) {
        URL maaUrl = (URL)tc.get("MAA-url");
        String maaFileText = MobileResourceUtils.getText("ARCHIVE_IMPORT_SUMMARY_MAA_FILE", URLFileSystem.getPlatformPathName((URL)maaUrl));
        return new DefaultMutableTreeNode(maaFileText);
    }

    private DefaultMutableTreeNode _createWorkspaceNode(TraversableContext tc) {
        URL wkspFileUrl = (URL)tc.get("workspace-file-name");
        DefaultMutableTreeNode wspNode = new DefaultMutableTreeNode(MobileResourceUtils.getText("ARCHIVE_IMPORT_SUMMARY_WORKSPACE", URLFileSystem.getPlatformPathName((URL)wkspFileUrl)));
        this._addProjects(wspNode, tc);
        return wspNode;
    }

    private void _addProjects(DefaultMutableTreeNode wspNode, TraversableContext tc) {
        List projectUrls = (List)tc.get("projects-file-path");
        for (URL projectUrl : projectUrls) {
            DefaultMutableTreeNode projNode = new DefaultMutableTreeNode(MobileResourceUtils.getText("ARCHIVE_IMPORT_SUMMARY_PROJECT", URLFileSystem.getPlatformPathName((URL)projectUrl)));
            wspNode.add(projNode);
        }
    }
}

