/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.rc;

import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import oracle.adf.rc.attribute.AttributeConstants;
import oracle.adf.rc.attribute.AttributeDescriptor;
import oracle.adf.rc.core.CatalogItem;
import oracle.adf.rc.core.CatalogReference;
import oracle.adf.rc.core.ModelReference;
import oracle.adf.rc.core.RepositoryReference;
import oracle.adf.rc.spi.jndi.InMemoryContext;
import oracle.adf.rc.util.CatalogUtils;
import oracle.adf.share.services.DescriptorContext;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.ide.FeatureArchive;
import oracle.adfmf.framework.dt.rc.FeatureArchiveFactoryPlugin;
import oracle.adfmf.framework.dt.rc.FeatureResource;

public class FeaturesContext
extends InMemoryContext {
    private Attributes _attributes = null;
    private static DirContext _sSchema = null;
    private DescriptorContext _dctx = null;
    private RepositoryReference _repositoryRef = null;
    private static final Logger _logger = Logger.getLogger(FeatureArchiveFactoryPlugin.class.getName());

    public FeaturesContext(DescriptorContext dctx, RepositoryReference reposRef, CatalogReference catalogRef, Hashtable env) throws NamingException {
        super(null, catalogRef, env);
        this._dctx = dctx;
        this._repositoryRef = reposRef;
    }

    protected DirContext getLocalSchema() {
        return _sSchema;
    }

    protected Attributes getLocalAttributes(String[] attrIds) throws NamingException {
        if (this._attributes == null) {
            this._attributes = new BasicAttributes();
            this._attributes.put(new BasicAttribute("Title", MobileResourceUtils.getText("ADF_MOBILE_FEATURES")));
        }
        if (attrIds == null) {
            return this._attributes;
        }
        BasicAttributes filtered = new BasicAttributes();
        for (int i = 0; i < attrIds.length; ++i) {
            String id = attrIds[i];
            Attribute attr = this._attributes.get(id);
            if (attr == null) continue;
            filtered.put(id, attr.get());
        }
        return filtered;
    }

    protected void loadCache() {
        FeatureArchive far = new FeatureArchive(this._dctx.getJarURL());
        List<String> featureIds = far.getFeatureIds();
        for (String featureId : featureIds) {
            try {
                CatalogReference catalogRef = new CatalogReference((ModelReference)this.getCatalogReference(), featureId);
                RepositoryReference reposRef = new RepositoryReference(this.getRepositoryReference(), featureId);
                FeatureResource item = new FeatureResource(featureId, this._dctx, catalogRef, reposRef);
                this.cacheObject(featureId, (CatalogItem)item, null);
            }
            catch (NamingException e) {
                _logger.log(Level.WARNING, MobileResourceUtils.getMsg("ADF-MBL-10500", e));
            }
        }
    }

    public RepositoryReference getRepositoryReference() {
        return this._repositoryRef;
    }

    static {
        try {
            _sSchema = CatalogUtils.getSchemaContext(new Hashtable(1));
            AttributeDescriptor title = AttributeConstants.TITLE_DESCRIPTOR;
            _sSchema.bind("attributes/" + title.getId(), (Object)title);
        }
        catch (NamingException e) {
            _sSchema = CatalogUtils.getSchemaContext(new Hashtable(1));
        }
    }
}

