/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.rc;

import java.net.URL;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import oracle.adf.rc.core.CatalogItem;
import oracle.adf.rc.core.CatalogReference;
import oracle.adf.rc.core.RepositoryReference;
import oracle.adf.rc.spi.plugin.item.CatalogItemFactoryPlugin;
import oracle.adf.share.services.DescriptorContext;
import oracle.adf.share.services.DescriptorContextFactory;
import oracle.adfmf.common.util.McAppUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.rc.FeatureArchiveContext;

public class FeatureArchiveFactoryPlugin
implements CatalogItemFactoryPlugin {
    private static final Logger _logger = Logger.getLogger(FeatureArchiveFactoryPlugin.class.getName());

    public CatalogItem createItem(URL itemUrl, RepositoryReference reposRef, CatalogReference catalogRef, Hashtable env) {
        if (!this.canCreateItem(itemUrl)) {
            return null;
        }
        FeatureArchiveContext farCtx = null;
        try {
            DescriptorContext dctx = DescriptorContextFactory.getInstance().getContext(itemUrl);
            farCtx = new FeatureArchiveContext(dctx, reposRef, catalogRef, env);
        }
        catch (NamingException e) {
            _logger.log(Level.WARNING, MobileResourceUtils.getMsg("ADF-MBL-10500", e));
            return null;
        }
        return farCtx;
    }

    public boolean canCreateItem(URL itemUrl) {
        return McAppUtils.isFeatureArchive(itemUrl);
    }
}

