/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.rc;

import java.awt.Component;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import oracle.adf.rc.core.CatalogItem;
import oracle.adfmf.common.util.McAppUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.rc.FeatureArchiveContext;
import oracle.adfmf.framework.dt.rc.FeatureNode;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Workspace;
import oracle.jdeveloper.rescat2.model.nodes.ResourceNodeFactory;

public class FeatureArchiveContextMenuListener
implements Controller,
ContextMenuListener {
    public static final int ADD_TO_APPLICATION_CMD = Ide.findOrCreateCmdID((String)"featureArchive.ADD_TO_APPLICATION_CMD_ID");
    public static final int REMOVE_FROM_APPLICATION_CMD = Ide.findOrCreateCmdID((String)"featureArchive.REMOVE_FROM_APPLICATION_CMD_ID");
    private static final Logger _logger = Logger.getLogger(FeatureArchiveContextMenuListener.class.getName());

    public boolean handleEvent(IdeAction action, Context context) {
        FeatureArchiveContext farContext;
        Workspace workspace = Ide.getActiveWorkspace();
        if (workspace == null) {
            return true;
        }
        URL jarUrl = null;
        String featureId = null;
        FeatureNode featureNode = this.getFeatureNodeSelected(context);
        if (featureNode != null) {
            jarUrl = featureNode.getJarURL();
            featureId = featureNode.getShortLabel();
        }
        if ((farContext = this.getFeatureArchiveSelected(context)) != null) {
            jarUrl = farContext.getJarURL();
        }
        if (jarUrl == null) {
            return true;
        }
        int cmd = action.getCommandId();
        if (cmd == ADD_TO_APPLICATION_CMD) {
            if (!McAppUtils.isJarAdded(workspace, jarUrl)) {
                McAppUtils.addJar(workspace, jarUrl);
            }
            if (featureId != null) {
                McAppUtils.addFeatureReference(workspace, featureId);
            }
            return true;
        }
        if (cmd == REMOVE_FROM_APPLICATION_CMD) {
            if (featureId != null) {
                McAppUtils.removeFeatureReference(workspace, featureId);
            } else {
                McAppUtils.removeJar(workspace, jarUrl);
            }
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        int cmd = action.getCommandId();
        if (cmd == ADD_TO_APPLICATION_CMD || cmd == REMOVE_FROM_APPLICATION_CMD) {
            if ((context.getWorkspace() != null || Ide.getActiveWorkspace() != null) && this._hasSingleSelection(context)) {
                action.setEnabled(true);
            } else {
                action.setEnabled(false);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("Add/Remove application command disabled: " + context);
                }
            }
            return true;
        }
        return false;
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Context currentContext = contextMenu.getContext();
        if (this.getFeatureNodeSelected(currentContext) != null || this.getFeatureArchiveSelected(currentContext) != null) {
            String addStr = MobileResourceUtils.getText("ADD_TO_APPLICATION_MENU_ITEM");
            IdeAction addToApplication = IdeAction.findOrCreate((int)ADD_TO_APPLICATION_CMD, null, (String)StringUtils.stripMnemonic((String)addStr));
            addToApplication.addController((Controller)this);
            JMenuItem menuItem = contextMenu.createMenuItem((ToggleAction)addToApplication);
            contextMenu.add((Component)menuItem, 1.0f);
            String removeStr = MobileResourceUtils.getText("REMOVE_FROM_APPLICATION_MENU_ITEM");
            IdeAction removeFromProject = IdeAction.findOrCreate((int)REMOVE_FROM_APPLICATION_CMD, null, (String)StringUtils.stripMnemonic((String)removeStr));
            removeFromProject.addController((Controller)this);
            JMenuItem menuItem1 = contextMenu.createMenuItem((ToggleAction)removeFromProject);
            contextMenu.add((Component)menuItem1, 1.0f);
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    private FeatureNode getFeatureNodeSelected(Context context) {
        Element[] sel = context.getSelection();
        if (sel != null && sel.length > 0 && sel[0] instanceof Locatable && sel[0] instanceof FeatureNode) {
            return (FeatureNode)sel[0];
        }
        return null;
    }

    private FeatureArchiveContext getFeatureArchiveSelected(Context context) {
        CatalogItem res = null;
        Element[] sel = context.getSelection();
        if (sel != null && sel.length > 0 && sel[0] instanceof Locatable && (res = ResourceNodeFactory.getInstance().resolveCatalogItemURL(((Locatable)sel[0]).getURL())) instanceof FeatureArchiveContext) {
            return (FeatureArchiveContext)res;
        }
        return null;
    }

    private boolean _hasSingleSelection(Context ctx) {
        Element[] sel = ctx.getSelection();
        return sel != null && sel.length == 1;
    }
}

