/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.rc;

import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.swing.Icon;
import oracle.adf.rc.attribute.AttributeConstants;
import oracle.adf.rc.attribute.AttributeDescriptor;
import oracle.adf.rc.core.CatalogItem;
import oracle.adf.rc.core.CatalogReference;
import oracle.adf.rc.core.ModelReference;
import oracle.adf.rc.core.RepositoryReference;
import oracle.adf.rc.spi.jndi.InMemoryContext;
import oracle.adf.rc.util.CatalogUtils;
import oracle.adf.share.services.DescriptorContext;
import oracle.adfmf.framework.dt.rc.FeaturesContext;
import oracle.javatools.icons.OracleIcons;

public class FeatureArchiveContext
extends InMemoryContext {
    private Attributes _attributes = null;
    private static DirContext _sSchema = null;
    private DescriptorContext _dctx = null;
    private RepositoryReference _repositoryRef = null;
    private static final String _FEATURES = "Features";
    private static final String _FEATURES_CACHE_NAME = "ADF_Mobile_Features";

    FeatureArchiveContext(DescriptorContext dctx, RepositoryReference repoRef, CatalogReference catalogReference, Hashtable hashtable) throws NamingException {
        super(null, catalogReference, hashtable);
        this._dctx = dctx;
        this._repositoryRef = repoRef;
    }

    protected DirContext getLocalSchema() {
        return _sSchema;
    }

    protected Attributes getLocalAttributes(String[] attrIds) throws NamingException {
        if (this._attributes == null) {
            this._attributes = new BasicAttributes();
            this._attributes.put(new BasicAttribute("Title", this._getJarName()));
        }
        if (attrIds == null) {
            return this._attributes;
        }
        BasicAttributes filtered = new BasicAttributes();
        for (int i = 0; i < attrIds.length; ++i) {
            String id = attrIds[i];
            Attribute attr = this._attributes.get(id);
            if (attr == null) continue;
            filtered.put(id, attr.get());
        }
        return filtered;
    }

    public Icon getIcon() {
        return OracleIcons.getIcon((String)"library.png");
    }

    public URL getJarURL() {
        return this._dctx.getJarURL();
    }

    private String _getJarName() {
        if (this._dctx != null) {
            try {
                return this._dctx.getJarName();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    protected void loadCache() throws NamingException {
        CatalogReference catalogRef = new CatalogReference((ModelReference)this.getCatalogReference(), _FEATURES);
        RepositoryReference reposRef = new RepositoryReference(this.getRepositoryReference(), _FEATURES);
        FeaturesContext item = new FeaturesContext(this._dctx, reposRef, catalogRef, this.getEnvInternal());
        this.cacheObject(_FEATURES_CACHE_NAME, (CatalogItem)item, null);
    }

    public RepositoryReference getRepositoryReference() {
        return this._repositoryRef;
    }

    static {
        try {
            _sSchema = CatalogUtils.getSchemaContext(new Hashtable(1));
            AttributeDescriptor title = AttributeConstants.TITLE_DESCRIPTOR;
            _sSchema.bind("attributes/" + title.getId(), (Object)title);
        }
        catch (NamingException e) {
            _sSchema = CatalogUtils.getSchemaContext(new Hashtable(1));
        }
    }
}

