/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.preferences.formfactors;

import javax.swing.table.AbstractTableModel;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.preferences.formfactors.DeviceProperty;
import oracle.adfmf.framework.dt.preferences.formfactors.FormFactor;

public final class FormFactorsMorePropertiesTableModel
extends AbstractTableModel {
    private FormFactor m_formFactor;

    public void setFormFactor(FormFactor formFactor) {
        this.m_formFactor = formFactor;
        this.fireTableDataChanged();
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return MobileResourceUtils.getText("PROPERTY_COLUMN_HEADER");
            }
            case 1: {
                return MobileResourceUtils.getText("VALUE_COLUMN_HEADER");
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int colIndex) {
        return true;
    }

    public Class getColumnClass(int colIndex) {
        return String.class;
    }

    @Override
    public int getRowCount() {
        if (this.m_formFactor != null) {
            return this.m_formFactor.getMoreProperties().size();
        }
        return 0;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int rowIndex, int colIndex) {
        String ret;
        DeviceProperty currentRow = this.m_formFactor.getMoreProperties().get(rowIndex);
        switch (colIndex) {
            case 0: {
                ret = currentRow.getPropertyName();
                break;
            }
            case 1: {
                ret = currentRow.getPropertyValue();
                break;
            }
            default: {
                ret = null;
            }
        }
        return ret;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int colIndex) {
        DeviceProperty currentRow = this.m_formFactor.getMoreProperties().get(rowIndex);
        switch (colIndex) {
            case 0: {
                currentRow.setPropertyName((String)value);
                break;
            }
            case 1: {
                currentRow.setPropertyValue((String)value);
                break;
            }
        }
    }

    int addEmptyProperty() {
        DeviceProperty property = new DeviceProperty();
        this.m_formFactor.getMoreProperties().add(property);
        int lastRow = this.m_formFactor.getMoreProperties().size() - 1;
        this.fireTableRowsInserted(lastRow, lastRow);
        return lastRow;
    }

    void removeProperty(int rowIndex) {
        if (rowIndex != -1) {
            DeviceProperty property = this.m_formFactor.getMoreProperties().get(rowIndex);
            this.m_formFactor.getMoreProperties().remove(property);
            this.fireTableRowsDeleted(rowIndex, rowIndex);
        }
    }

    void removeProperty(DeviceProperty property) {
        int row = this.m_formFactor.getMoreProperties().indexOf(property);
        this.removeProperty(row);
    }

    DeviceProperty getProperty(int rowIndex) {
        return this.m_formFactor.getMoreProperties().get(rowIndex);
    }
}

