/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.preferences.formfactors;

import java.util.Arrays;
import java.util.Set;
import javax.swing.table.AbstractTableModel;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.preferences.formfactors.FormFactor;
import oracle.adfmf.framework.dt.preferences.formfactors.FormFactors;
import oracle.adfmf.framework.dt.preferences.formfactors.FormFactorsConstants;

public final class FormFactorsMasterTableModel
extends AbstractTableModel {
    private FormFactors m_formFactors = null;

    public void setFormFactors(FormFactors formFactors) {
        this.m_formFactors = formFactors;
        this.fireTableDataChanged();
    }

    public int addEmptyFormFactor(boolean isDefault) {
        FormFactor formFactor = new FormFactor();
        formFactor.setProperty("Default", isDefault);
        formFactor.setProperty("Default Orientation", FormFactorsConstants.Orientation.PORTRAIT.getOrientation());
        if (this.m_formFactors == null) {
            this.m_formFactors = new FormFactors();
        }
        this.m_formFactors.add(formFactor);
        int lastRow = this.m_formFactors.getSize() - 1;
        this.fireTableRowsInserted(lastRow, lastRow);
        return lastRow;
    }

    public void addFormFactors(Set<FormFactor> formFactors) {
        this.m_formFactors.addAll(formFactors);
        this.fireTableDataChanged();
    }

    public FormFactors getFormFactors() {
        return this.m_formFactors;
    }

    public FormFactor getFormFactor(int row) {
        return this.m_formFactors.get(row);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int colIndex) {
        return true;
    }

    public Class getColumnClass(int colIndex) {
        if (colIndex == FormFactorsConstants.MasterTableColumns.DEFAULT.ordinal()) {
            return Boolean.class;
        }
        if (colIndex == FormFactorsConstants.MasterTableColumns.RESOLUTION_WIDTH.ordinal() || colIndex == FormFactorsConstants.MasterTableColumns.RESOLUTION_HEIGHT.ordinal()) {
            return Integer.class;
        }
        if (colIndex == FormFactorsConstants.MasterTableColumns.SCALE_FACTOR.ordinal()) {
            return Double.class;
        }
        return String.class;
    }

    @Override
    public int getRowCount() {
        return this.m_formFactors == null ? 0 : this.m_formFactors.getSize();
    }

    @Override
    public int getColumnCount() {
        return FormFactorsConstants.MasterTableColumns.values().length;
    }

    @Override
    public Object getValueAt(int rowIndex, int colIndex) {
        FormFactor currentRow = this.m_formFactors.get(rowIndex);
        String columnName = FormFactorsConstants.MasterTableColumns.values()[colIndex].getColumnName();
        String value = currentRow.getProperty(columnName);
        if (colIndex == FormFactorsConstants.MasterTableColumns.DEFAULT.ordinal()) {
            if ("true".equals(value)) {
                return true;
            }
            return false;
        }
        return value;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int colIndex) {
        FormFactor currentRow = this.m_formFactors.get(rowIndex);
        String columnName = FormFactorsConstants.MasterTableColumns.values()[colIndex].getColumnName();
        currentRow.setProperty(columnName, value);
        if (colIndex == FormFactorsConstants.MasterTableColumns.PLATFORM.ordinal() && value != null) {
            int modelColIndex = FormFactorsConstants.MasterTableColumns.MODEL.ordinal();
            String modelValue = (String)this.getValueAt(rowIndex, modelColIndex);
            if (modelValue != null && Arrays.asList(FormFactorsConstants.getPlatformModels((String)value)).contains(modelValue)) {
                return;
            }
            if ("iOS".equals(value)) {
                this.setValueAt(FormFactorsConstants.getPlatformModels((String)value)[0], rowIndex, modelColIndex);
            }
        }
    }

    @Override
    public String getColumnName(int colIndex) {
        String key = FormFactorsConstants.MasterTableColumns.values()[colIndex].name().toUpperCase();
        String name = MobileResourceUtils.getText(key);
        if (FormFactorsConstants.isRequiredField(colIndex)) {
            name = name + "*";
        }
        return name;
    }

    public boolean isDefaultRow(int row) {
        return (Boolean)this.getValueAt(row, FormFactorsConstants.MasterTableColumns.DEFAULT.ordinal());
    }

    void removeFormFactor(int row) {
        if (row != -1) {
            FormFactor formFactor = this.m_formFactors.get(row);
            this.m_formFactors.remove(formFactor);
            this.fireTableRowsDeleted(row, row);
        }
    }

    void removeFormFactor(FormFactor formFactor) {
        int row = this.m_formFactors.indexOf(formFactor);
        this.removeFormFactor(row);
    }
}

