/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.preferences.formfactors;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.preferences.FormFactorsPrefs;
import oracle.adfmf.framework.dt.preferences.formfactors.FormFactor;
import oracle.adfmf.framework.dt.preferences.formfactors.FormFactors;
import oracle.adfmf.framework.dt.preferences.formfactors.FormFactorsConstants;
import oracle.adfmf.framework.dt.preferences.formfactors.FormFactorsDetailPanel;
import oracle.adfmf.framework.dt.preferences.formfactors.FormFactorsMasterTableModel;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.Borders;
import oracle.javatools.ui.builders.BuiltTable;
import oracle.javatools.ui.builders.TableBuilder;
import oracle.javatools.ui.table.GenericTableCellRenderer;

public class FormFactorsMasterPanel
extends JPanel {
    private static final String _CONFIRMATION_DIALOG_ID = FormFactorsMasterPanel.class.getName() + ".confirmationDialog";
    private FormFactorsMasterTableModel _tableModel;
    private JTable _table = null;
    private FormFactorsDetailPanel _detailPanel = null;

    public FormFactorsMasterPanel(JPanel detailPanel) {
        if (detailPanel != null) {
            assert (detailPanel instanceof FormFactorsDetailPanel);
            this._detailPanel = (FormFactorsDetailPanel)detailPanel;
        }
        this.setLayout(new BorderLayout());
        JComponent masterPanel = this._initMasterPanel();
        this.add(masterPanel);
    }

    public void setFormFactors(FormFactors formFactors) {
        this._tableModel.setFormFactors(formFactors);
        ListSelectionModel lsm = this._table.getSelectionModel();
        if (this._tableModel.getRowCount() > 0) {
            Rectangle cell = this._table.getCellRect(0, 0, true);
            this._table.scrollRectToVisible(cell);
            lsm.setSelectionInterval(0, 0);
        }
    }

    public FormFactors getFormFactors() {
        return this._tableModel.getFormFactors();
    }

    public void stopEditingAndSave() {
        this._stopCellEditing();
        if (this._detailPanel != null) {
            this._detailPanel.stopEditingAndSave();
        }
    }

    private void _stopCellEditing() {
        TableCellEditor cellEditor;
        if (this._table.isEditing() && (cellEditor = this._table.getCellEditor()) != null) {
            cellEditor.stopCellEditing();
        }
    }

    private JComponent _initMasterPanel() {
        this._tableModel = new FormFactorsMasterTableModel();
        TableRowSorter<FormFactorsMasterTableModel> tableSorter = new TableRowSorter<FormFactorsMasterTableModel>(this._tableModel);
        BuiltTable builtTable = this._buildTable(tableSorter);
        this._table = builtTable.getTable();
        tableSorter.toggleSortOrder(FormFactorsConstants.MasterTableColumns.NAME.ordinal());
        this._setDefaultColumn();
        this._setOrientationColumn();
        this._setPlatformColumn();
        this._setModelColumn();
        this._setDefaultRendererEditor();
        return builtTable.getGUI();
    }

    private BuiltTable _buildTable(TableRowSorter tableSorter) {
        JButton addButton = this._createAddAction();
        JButton deleteButton = this._createDeleteAction();
        TableBuilder builder = new TableBuilder();
        builder.setRollover(true);
        builder.setModel((TableModel)this._tableModel);
        builder.setSorter(tableSorter);
        builder.setToolbarComponents(new JComponent[]{addButton, deleteButton});
        builder.setActionsSecondary(new Action[]{this._createRestoreDefaultAction()});
        builder.setLabel(MobileResourceUtils.getText("AVAILABLE_FORM_FACTORS"));
        builder.setSelectionMode(2);
        builder.setSelectionEnabledComponent((JComponent)deleteButton);
        return builder.build();
    }

    private JButton _createAddAction() {
        JButton addButton = new JButton(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FormFactorsMasterPanel.this._stopCellEditing();
                boolean isDefault = FormFactorsMasterPanel.this._tableModel.getRowCount() == 0;
                int pos = FormFactorsMasterPanel.this._tableModel.addEmptyFormFactor(isDefault);
                pos = FormFactorsMasterPanel.this._table.getRowSorter().convertRowIndexToView(pos);
                ListSelectionModel lsm = FormFactorsMasterPanel.this._table.getSelectionModel();
                Rectangle cell = FormFactorsMasterPanel.this._table.getCellRect(pos, FormFactorsConstants.MasterTableColumns.NAME.ordinal(), true);
                FormFactorsMasterPanel.this._table.scrollRectToVisible(cell);
                lsm.setSelectionInterval(pos, pos);
                FormFactorsMasterPanel.this._table.requestFocus();
                FormFactorsMasterPanel.this._table.editCellAt(pos, FormFactorsConstants.MasterTableColumns.NAME.ordinal());
            }
        });
        addButton.setToolTipText(StringUtils.stripMnemonic((String)MobileResourceUtils.getText("NEW_ACTION")));
        addButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)MobileResourceUtils.getText("NEW_ACTION")));
        addButton.setIcon(OracleIcons.getIcon((String)"add.png"));
        return addButton;
    }

    private JButton _createDeleteAction() {
        JButton deleteButton = new JButton(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int newSelectedIdx;
                FormFactorsMasterPanel.this._stopCellEditing();
                ArrayList<FormFactor> deleteEntries = new ArrayList<FormFactor>();
                boolean setDefaultOnNewSelection = false;
                int firstSelectedRow = -1;
                for (int selectedRow : FormFactorsMasterPanel.this._table.getSelectedRows()) {
                    int rowIndex = FormFactorsMasterPanel.this._table.getRowSorter().convertRowIndexToModel(selectedRow);
                    deleteEntries.add(FormFactorsMasterPanel.this._tableModel.getFormFactor(rowIndex));
                    if (FormFactorsMasterPanel.this._tableModel.isDefaultRow(rowIndex)) {
                        setDefaultOnNewSelection = true;
                    }
                    if (firstSelectedRow != -1) continue;
                    firstSelectedRow = selectedRow;
                }
                for (FormFactor formFactor : deleteEntries) {
                    FormFactorsMasterPanel.this._tableModel.removeFormFactor(formFactor);
                }
                if (deleteEntries.size() > 0 && (newSelectedIdx = Math.min(firstSelectedRow, FormFactorsMasterPanel.this._tableModel.getRowCount() - 1)) >= 0) {
                    if (setDefaultOnNewSelection) {
                        FormFactorsMasterPanel.this._tableModel.setValueAt(true, FormFactorsMasterPanel.this._table.getRowSorter().convertRowIndexToModel(newSelectedIdx), FormFactorsConstants.MasterTableColumns.DEFAULT.ordinal());
                    }
                    FormFactorsMasterPanel.this._table.getSelectionModel().setSelectionInterval(newSelectedIdx, newSelectedIdx);
                }
            }
        });
        deleteButton.setToolTipText(StringUtils.stripMnemonic((String)MobileResourceUtils.getText("DELETE_ACTION")));
        deleteButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)MobileResourceUtils.getText("DELETE_ACTION")));
        deleteButton.setIcon(OracleIcons.getIcon((String)"delete.png"));
        return deleteButton;
    }

    private Action _createRestoreDefaultAction() {
        AbstractAction restoreAction = new AbstractAction(MobileResourceUtils.getText("RESTORE_DEFAULTS")){

            @Override
            public void actionPerformed(ActionEvent e) {
                FormFactorsMasterPanel.this._restoreDefaults();
            }
        };
        return restoreAction;
    }

    private void _restoreDefaults() {
        boolean proceed = MessageDialog.optionalConfirm((String)_CONFIRMATION_DIALOG_ID, (Component)Ide.getMainWindow(), (String)(MobileResourceUtils.getText("RESTORE_DEFAULTS_TEXT1") + "\n\n" + MobileResourceUtils.getText("RESTORE_DEFAULTS_TEXT2")), (String)MobileResourceUtils.getText("RESTORE_DEFAULTS_DIALOG_TITLE"), null);
        if (proceed) {
            List<FormFactor> defaultFormFactors = FormFactorsPrefs.getDefaultFormFactors();
            FormFactors formFactors = this._tableModel.getFormFactors();
            formFactors.set(defaultFormFactors);
            this._tableModel.setFormFactors(formFactors);
        }
    }

    private void _setDefaultColumn() {
        TableColumn defaultColumn = this._table.getColumnModel().getColumn(FormFactorsConstants.MasterTableColumns.DEFAULT.ordinal());
        defaultColumn.setResizable(true);
        defaultColumn.setPreferredWidth(45);
        defaultColumn.setMaxWidth(Short.MAX_VALUE);
    }

    private void _setOrientationColumn() {
        JComboBox<String> orientationCombo = new JComboBox<String>(FormFactorsConstants.getOrientations());
        orientationCombo.setEditable(false);
        TableColumn orientationColumn = this._table.getColumnModel().getColumn(FormFactorsConstants.MasterTableColumns.DEFAULT_ORIENTATION.ordinal());
        orientationColumn.setCellEditor(new DefaultCellEditor(orientationCombo));
    }

    private void _setPlatformColumn() {
        JComboBox<String> platformCombo = new JComboBox<String>(FormFactorsConstants.getPlatforms());
        platformCombo.setEditable(false);
        TableColumn platformColumn = this._table.getColumnModel().getColumn(FormFactorsConstants.MasterTableColumns.PLATFORM.ordinal());
        platformColumn.setCellEditor(new DefaultCellEditor(platformCombo));
    }

    private void _setModelColumn() {
        TableColumn modelColumn = this._table.getColumnModel().getColumn(FormFactorsConstants.MasterTableColumns.MODEL.ordinal());
        modelColumn.setCellEditor(new DelegatingModelCellEditor());
    }

    private void _setDefaultRendererEditor() {
        this._table.setDefaultRenderer(Boolean.class, new RadioButtonRenderer());
        this._table.setDefaultEditor(Boolean.class, new RadioButtonEditor(new JCheckBox()));
        this._table.setDefaultRenderer(String.class, new NameBoxedTableCellRenderer());
        this._table.setDefaultRenderer(Integer.class, new ResolutionBoxedTableCellRenderer((TableCellRenderer)new GenericTableCellRenderer(this._table.getDefaultRenderer(Integer.class))));
        this._table.setDefaultRenderer(Double.class, new ScaleFactorBoxedTableCellRenderer((TableCellRenderer)new GenericTableCellRenderer(this._table.getDefaultRenderer(Number.class))));
    }

    private void _handleSelectionChange() {
        ListSelectionModel lsm = this._table.getSelectionModel();
        lsm.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (FormFactorsMasterPanel.this._detailPanel != null && !e.getValueIsAdjusting()) {
                    if (FormFactorsMasterPanel.this._table.getSelectedRowCount() != 1) {
                        FormFactorsMasterPanel.this._detailPanel.sync(null);
                    } else {
                        int selectedRow = FormFactorsMasterPanel.this._table.getSelectedRow();
                        int rowIndex = FormFactorsMasterPanel.this._table.getRowSorter().convertRowIndexToModel(selectedRow);
                        FormFactor ff = FormFactorsMasterPanel.this._tableModel.getFormFactor(rowIndex);
                        FormFactorsMasterPanel.this._detailPanel.sync(ff);
                    }
                }
            }
        });
    }

    private class DelegatingModelCellEditor
    implements TableCellEditor {
        private final TableCellEditor _textFieldEditor = new DefaultCellEditor(new JTextField());
        private final TableCellEditor _comboBoxEditor = new DefaultCellEditor(new JComboBox<String>(FormFactorsConstants.getPlatformModels("iOS")));
        private TableCellEditor currentEditor = this._textFieldEditor;

        private DelegatingModelCellEditor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            String platformValue = (String)FormFactorsMasterPanel.this._table.getValueAt(row, FormFactorsConstants.MasterTableColumns.PLATFORM.ordinal());
            this.currentEditor = "iOS".equals(platformValue) ? this._comboBoxEditor : this._textFieldEditor;
            return this.currentEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        @Override
        public Object getCellEditorValue() {
            return this.currentEditor.getCellEditorValue();
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return this.currentEditor.shouldSelectCell(anEvent);
        }

        @Override
        public boolean stopCellEditing() {
            return this.currentEditor.stopCellEditing();
        }

        @Override
        public void cancelCellEditing() {
            this.currentEditor.cancelCellEditing();
        }

        @Override
        public void addCellEditorListener(CellEditorListener cl) {
            this.currentEditor.addCellEditorListener(cl);
        }

        @Override
        public void removeCellEditorListener(CellEditorListener cl) {
            this.currentEditor.removeCellEditorListener(cl);
        }
    }

    private static final class RadioButtonEditor
    extends DefaultCellEditor {
        private JPanel _panel;
        private JToggleButton _button = new JRadioButton();

        public RadioButtonEditor(JCheckBox checkBox) {
            super(checkBox);
            this._panel = new JPanel(new BorderLayout());
            this._panel.setOpaque(true);
            this._panel.add((Component)this._button, "Center");
            for (MouseListener l : this._button.getMouseListeners()) {
                this._button.removeMouseListener(l);
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value == null) {
                return null;
            }
            TableModel model = table.getModel();
            int rowIndex = table.getRowSorter().convertRowIndexToModel(row);
            for (int i = 0; i < model.getRowCount(); ++i) {
                model.setValueAt(i == rowIndex, i, FormFactorsConstants.MasterTableColumns.DEFAULT.ordinal());
            }
            this._panel.setBackground(table.getSelectionBackground());
            this._button.setOpaque(false);
            this._button.setSelected(true);
            TableColumn defaultColumn = table.getColumnModel().getColumn(0);
            int leftOffset = defaultColumn.getPreferredWidth() / 2 - (int)this._button.getPreferredSize().getWidth() / 2;
            this._panel.setBorder(BorderFactory.createEmptyBorder(0, leftOffset, 0, 0));
            return this._panel;
        }

        @Override
        public Object getCellEditorValue() {
            return this._button.isSelected();
        }
    }

    private static final class RadioButtonRenderer
    implements TableCellRenderer {
        private JPanel _panel;
        private JToggleButton _button = new JRadioButton();

        public RadioButtonRenderer() {
            this._panel = new JPanel(new BorderLayout());
            this._panel.setOpaque(true);
            this._panel.setBackground(Color.WHITE);
            this._panel.add((Component)this._button, "Center");
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                return null;
            }
            TableModel model = table.getModel();
            int rowIndex = table.getRowSorter().convertRowIndexToModel(row);
            boolean isDefault = (Boolean)model.getValueAt(rowIndex, FormFactorsConstants.MasterTableColumns.DEFAULT.ordinal());
            this._button.setSelected(isDefault);
            this._button.setOpaque(false);
            TableColumn defaultColumn = table.getColumnModel().getColumn(0);
            int leftOffset = defaultColumn.getPreferredWidth() / 2 - (int)this._button.getPreferredSize().getWidth() / 2;
            Color focusedButtonColor = UIManager.getColor("Button.focus");
            if (hasFocus && focusedButtonColor != null) {
                this._panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(focusedButtonColor, 1), BorderFactory.createEmptyBorder(0, leftOffset - 1, 0, 0)));
            } else {
                this._panel.setBorder(BorderFactory.createEmptyBorder(0, leftOffset, 0, 0));
            }
            if (isSelected) {
                this._panel.setBackground(table.getSelectionBackground());
            } else {
                this._panel.setBackground(table.getBackground());
            }
            return this._panel;
        }
    }

    private static final class ResolutionBoxedTableCellRenderer
    extends BoxedTableCellRenderer {
        public ResolutionBoxedTableCellRenderer() {
        }

        public ResolutionBoxedTableCellRenderer(TableCellRenderer tableCellRenderer) {
            super(tableCellRenderer);
        }

        @Override
        protected boolean shouldHaveBox(Object value, boolean hasFocus, boolean isRequired) {
            if (hasFocus) {
                return false;
            }
            if (!FormFactorsConstants.isValueSet((String)value)) {
                this.setToolTip(MobileResourceUtils.getText("REQUIRED_FIELD_TOOLTIP"));
                return true;
            }
            if (!FormFactorsConstants.isResolutionValid((String)value)) {
                this.setToolTip(MobileResourceUtils.getText("INVALID_RESOLUTION_TOOLTIP"));
                return true;
            }
            return false;
        }
    }

    private static final class NameBoxedTableCellRenderer
    extends BoxedTableCellRenderer {
        public NameBoxedTableCellRenderer() {
        }

        public NameBoxedTableCellRenderer(TableCellRenderer tableCellRenderer) {
            super(tableCellRenderer);
        }

        @Override
        protected boolean shouldHaveBox(Object value, boolean hasFocus, boolean isRequired) {
            if (!isRequired || hasFocus) {
                return false;
            }
            if (!FormFactorsConstants.isValueSet((String)value)) {
                this.setToolTip(MobileResourceUtils.getText("REQUIRED_FIELD_TOOLTIP"));
                return true;
            }
            return false;
        }
    }

    private static final class ScaleFactorBoxedTableCellRenderer
    extends BoxedTableCellRenderer {
        public ScaleFactorBoxedTableCellRenderer(TableCellRenderer tableCellRenderer) {
            super(tableCellRenderer);
        }

        @Override
        protected boolean shouldHaveBox(Object value, boolean hasFocus, boolean isRequired) {
            if (hasFocus) {
                return false;
            }
            if (!FormFactorsConstants.isValueSet((String)value)) {
                this.setToolTip(MobileResourceUtils.getText("REQUIRED_FIELD_TOOLTIP"));
                return true;
            }
            if (!FormFactorsConstants.isScaleValid((String)value)) {
                this.setToolTip(MobileResourceUtils.getText("INVALID_SCALE_FACTOR_TOOLTIP"));
                return true;
            }
            return false;
        }
    }

    private static class BoxedTableCellRenderer
    implements TableCellRenderer {
        private String _toolTip = null;
        private TableCellRenderer _defaultRenderer;

        public BoxedTableCellRenderer() {
            this((TableCellRenderer)new GenericTableCellRenderer());
        }

        public BoxedTableCellRenderer(TableCellRenderer defaultRenderer) {
            this._defaultRenderer = defaultRenderer;
        }

        public TableCellRenderer getBaseRenderer() {
            return this._defaultRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = this._defaultRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            assert (comp instanceof JComponent);
            JComponent cellComponent = (JComponent)comp;
            boolean isRequired = FormFactorsConstants.isRequiredField(column);
            if (this.shouldHaveBox(value, hasFocus, isRequired)) {
                Borders.attachErrorBorder((JComponent)cellComponent);
            } else {
                Borders.restoreBorder((JComponent)cellComponent);
            }
            cellComponent.setToolTipText(this._toolTip);
            return comp;
        }

        protected boolean shouldHaveBox(Object value, boolean hasFocus, boolean isRequired) {
            return false;
        }

        protected void setToolTip(String tooltip) {
            this._toolTip = tooltip;
        }
    }
}

