/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.preferences.formfactors;

import java.awt.BorderLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.preferences.formfactors.DeviceProperty;
import oracle.adfmf.framework.dt.preferences.formfactors.FormFactor;
import oracle.adfmf.framework.dt.preferences.formfactors.FormFactorsConstants;
import oracle.adfmf.framework.dt.preferences.formfactors.FormFactorsMorePropertiesTableModel;
import oracle.bali.share.nls.StringUtils;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.builders.BuiltTable;
import oracle.javatools.ui.builders.TableBuilder;

public final class FormFactorsDetailMorePropertiesPanel
extends JPanel {
    private FormFactorsMorePropertiesTableModel m_tableModel;
    private JTable m_table;

    public FormFactorsDetailMorePropertiesPanel() {
        this.setLayout(new BorderLayout());
        JComponent morePropertiesPanel = this.initMorePropertiesPanel();
        this.add(morePropertiesPanel);
    }

    public void stopCellEditing() {
        TableCellEditor cellEditor = this.m_table.getCellEditor();
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
    }

    public void sync(FormFactor formFactor) {
        this.m_tableModel.setFormFactor(formFactor);
    }

    private JComponent initMorePropertiesPanel() {
        JButton addButton = new JButton(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FormFactorsDetailMorePropertiesPanel.this.stopCellEditing();
                int pos = FormFactorsDetailMorePropertiesPanel.this.m_tableModel.addEmptyProperty();
                pos = FormFactorsDetailMorePropertiesPanel.this.m_table.getRowSorter().convertRowIndexToView(pos);
                ListSelectionModel lsm = FormFactorsDetailMorePropertiesPanel.this.m_table.getSelectionModel();
                Rectangle cell = FormFactorsDetailMorePropertiesPanel.this.m_table.getCellRect(pos, 0, true);
                FormFactorsDetailMorePropertiesPanel.this.m_table.scrollRectToVisible(cell);
                lsm.setSelectionInterval(pos, pos);
                FormFactorsDetailMorePropertiesPanel.this.m_table.requestFocus();
                FormFactorsDetailMorePropertiesPanel.this.m_table.editCellAt(pos, 0);
            }
        });
        addButton.setToolTipText(StringUtils.stripMnemonic((String)MobileResourceUtils.getText("NEW_ACTION")));
        addButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)MobileResourceUtils.getText("NEW_ACTION")));
        addButton.setIcon(OracleIcons.getIcon((String)"add.png"));
        JButton deleteButton = new JButton(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FormFactorsDetailMorePropertiesPanel.this.stopCellEditing();
                ArrayList<DeviceProperty> deleteEntries = new ArrayList<DeviceProperty>();
                for (int row : FormFactorsDetailMorePropertiesPanel.this.m_table.getSelectedRows()) {
                    int rowIndex = FormFactorsDetailMorePropertiesPanel.this.m_table.getRowSorter().convertRowIndexToModel(row);
                    deleteEntries.add(FormFactorsDetailMorePropertiesPanel.this.m_tableModel.getProperty(rowIndex));
                }
                for (DeviceProperty property : deleteEntries) {
                    FormFactorsDetailMorePropertiesPanel.this.m_tableModel.removeProperty(property);
                }
            }
        });
        deleteButton.setToolTipText(StringUtils.stripMnemonic((String)MobileResourceUtils.getText("DELETE_ACTION")));
        deleteButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)MobileResourceUtils.getText("DELETE_ACTION")));
        deleteButton.setIcon(OracleIcons.getIcon((String)"delete.png"));
        this.m_tableModel = new FormFactorsMorePropertiesTableModel();
        TableRowSorter<FormFactorsMorePropertiesTableModel> m_tableSorter = new TableRowSorter<FormFactorsMorePropertiesTableModel>(this.m_tableModel);
        TableBuilder builder = new TableBuilder();
        builder.setRollover(true);
        builder.setModel((TableModel)this.m_tableModel);
        builder.setSorter(m_tableSorter);
        builder.setToolbarComponents(new JComponent[]{addButton, deleteButton});
        builder.setLabel(MobileResourceUtils.getText("CUSTOM_DEVICE_PROPERTIES"));
        builder.setSelectionMode(2);
        builder.setSelectionEnabledComponent((JComponent)deleteButton);
        BuiltTable builtTable = builder.build();
        this.m_table = builtTable.getTable();
        m_tableSorter.toggleSortOrder(0);
        JComboBox<String> propertyNameCombo = new JComboBox<String>(FormFactorsConstants.getCustomPropertyNames());
        propertyNameCombo.setEditable(false);
        this.m_table.getColumnModel().getColumn(0).setCellEditor(new DefaultCellEditor(propertyNameCombo));
        JComboBox<String> propertyValueCombo = new JComboBox<String>(FormFactorsConstants.getCustomPropertyValues());
        propertyNameCombo.setEditable(false);
        this.m_table.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(propertyValueCombo));
        return builtTable.getGUI();
    }
}

