/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.preferences.formfactors;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class FormFactorsConstants {
    public static final int LAYOUT_GAP_SIZE = 4;
    private static final String[] ORIENTATIONS = new String[]{"Portrait", "Landscape"};
    public static final String PROPERTY_IS_DEFAULT = "Default";
    public static final String PROPERTY_NAME = "Name";
    public static final String PROPERTY_ORIENTATION = "Default Orientation";
    public static final String PROPERTY_RESOLUTION_WIDTH = "Resolution Width";
    public static final String PROPERTY_RESOLUTION_HEIGHT = "Resolution Height";
    public static final String PROPERTY_SCALE_FACTOR = "Scale Factor";
    public static final String PROPERTY_PLATFORM = "Platform";
    public static final String IOS = "iOS";
    public static final String ANDROID = "Android";
    public static final String IPHONE = "iPhone";
    public static final String IPAD = "iPad";
    public static final String PROPERTY_MODEL = "Model";
    private static final String[] PLATFORMS = new String[]{"iOS", "Android"};
    private static final Map<String, String[]> PLATFORM_MODELS;
    private static final String[] CUSTOM_PROPERTY_NAMES;
    private static final String[] CUSTOM_PROPERTY_VALUES;
    private static final String[][] DEFAULT_FORM_FACTORS;

    public static String[][] getDefaultFormFactors() {
        return (String[][])DEFAULT_FORM_FACTORS.clone();
    }

    public static String[] getOrientations() {
        return (String[])ORIENTATIONS.clone();
    }

    public static String[] getCustomPropertyNames() {
        return (String[])CUSTOM_PROPERTY_NAMES.clone();
    }

    public static String[] getCustomPropertyValues() {
        return (String[])CUSTOM_PROPERTY_VALUES.clone();
    }

    public static String[] getPlatformModels(String platform) {
        if (PLATFORM_MODELS.containsKey(platform)) {
            return PLATFORM_MODELS.get(platform);
        }
        return new String[0];
    }

    public static String[] getPlatforms() {
        return (String[])PLATFORMS.clone();
    }

    public static boolean isRequiredField(int colIndex) {
        return MasterTableColumns.values()[colIndex].isRequired();
    }

    public static boolean isValueSet(String propertyValue) {
        return propertyValue != null && !propertyValue.trim().isEmpty();
    }

    public static boolean isScaleValid(String value) {
        if (!FormFactorsConstants.isValueSet(value)) {
            return false;
        }
        double number = 0.0;
        try {
            number = Double.parseDouble(value);
        }
        catch (Exception e) {
            return false;
        }
        return !(number <= 0.0) && !(number > 3.0);
    }

    public static boolean isResolutionValid(String value) {
        if (!FormFactorsConstants.isValueSet(value)) {
            return false;
        }
        int number = 0;
        try {
            number = Integer.parseInt(value);
        }
        catch (Exception e) {
            return false;
        }
        return number > 0;
    }

    static /* synthetic */ String[] access$000() {
        return ORIENTATIONS;
    }

    static {
        HashMap<String, String[]> platformModelsMap = new HashMap<String, String[]>();
        platformModelsMap.put(IOS, new String[]{IPAD, IPHONE});
        PLATFORM_MODELS = Collections.unmodifiableMap(platformModelsMap);
        CUSTOM_PROPERTY_NAMES = new String[]{"Supports Camera", "Supports GPS", "Supports Accelerometer"};
        CUSTOM_PROPERTY_VALUES = new String[]{"true", "false"};
        DEFAULT_FORM_FACTORS = new String[][]{{"true", "Android Low", ANDROID, "", "Portrait", "240", "400", "1.0"}, {"false", "Android Medium", ANDROID, "", "Portrait", "320", "480", "1.0"}, {"false", "Android High", ANDROID, "", "Portrait", "480", "800", "1.5"}, {"false", "Android Extra Large", ANDROID, "", "Landscape", "1280", "800", "2.0"}, {"false", IPHONE, IOS, IPHONE, "Portrait", "320", "480", "1.0"}, {"false", "iPhone Retina (3.5 inch)", IOS, IPHONE, "Portrait", "640", "960", "2.0"}, {"false", "iPhone Retina (4 inch)", IOS, IPHONE, "Portrait", "640", "1136", "2.0"}, {"false", "iPad Mini", IOS, IPAD, "Landscape", "1024", "768", "1.0"}, {"false", IPAD, IOS, IPAD, "Landscape", "820", "615", "0.8"}, {"false", "iPad Retina", IOS, IPAD, "Landscape", "1640", "1230", "1.6"}};
    }

    public static enum Orientation {
        PORTRAIT(FormFactorsConstants.access$000()[0]),
        LANDSCAPE(FormFactorsConstants.access$000()[1]);

        private String m_orientation;

        private Orientation(String orientation) {
            this.m_orientation = orientation;
        }

        public String getOrientation() {
            return this.m_orientation;
        }
    }

    public static enum MasterTableColumns {
        DEFAULT("Default"),
        NAME("Name"),
        PLATFORM("Platform"),
        MODEL("Model"),
        DEFAULT_ORIENTATION("Default Orientation"),
        RESOLUTION_WIDTH("Resolution Width"),
        RESOLUTION_HEIGHT("Resolution Height"),
        SCALE_FACTOR("Scale Factor");

        private String m_columnName;

        private MasterTableColumns(String name) {
            this.m_columnName = name;
        }

        public String getColumnName() {
            return this.m_columnName;
        }

        public boolean isRequired() {
            return !this.m_columnName.equals(FormFactorsConstants.PROPERTY_ORIENTATION) && !this.m_columnName.equals(FormFactorsConstants.PROPERTY_IS_DEFAULT) && !this.m_columnName.equals(FormFactorsConstants.PROPERTY_MODEL);
        }
    }
}

